/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner.util;

import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.groovy.grails.rt.GrailsRtMarker;

public final class GrailsExecutionUtils {
    @NonNls
    public static final String GROOVY_PAGE_ADD_LINE_NUMBERS = "GROOVY_PAGE_ADD_LINE_NUMBERS";
    @NonNls
    public static final String SERVER_RUNNING_BROWSE_TO = "Server running. Browse to ";
    @NonNls
    public static final String GRAILS_3_SERVER_MESSAGE = "Grails application running at ";
    @NonNls
    private static final String AGENT_JAR_SUFFIX = "ideaAgentJar.jar";

    public static int getGrailsConsolePrefixLength(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/plugins/grails/runner/util/GrailsExecutionUtils", "getGrailsConsolePrefixLength"));
        }
        if (line.startsWith("|")) {
            if (line.startsWith("| ")) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    @NotNull
    public static ProcessAdapter getBrowserLaunchListener(final ProcessHandler handler) {
        ProcessAdapter processAdapter = new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                int start;
                String s2 = event.getText().trim();
                String url = this.getUrl(s2, GrailsExecutionUtils.SERVER_RUNNING_BROWSE_TO, start = GrailsExecutionUtils.getGrailsConsolePrefixLength(s2));
                if (url == null) {
                    url = this.getUrl(s2, GrailsExecutionUtils.GRAILS_3_SERVER_MESSAGE, start);
                }
                if (url != null) {
                    BrowserUtil.browse((String)url);
                    handler.removeProcessListener((ProcessListener)this);
                }
            }

            String getUrl(String s2, String prefix, int start) {
                int space;
                String url = null;
                if (s2.startsWith(prefix, start) && (space = (url = s2.substring(start + prefix.length()).trim()).indexOf(32)) >= 0) {
                    url = url.substring(0, space);
                }
                return url;
            }
        };
        if (processAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/util/GrailsExecutionUtils", "getBrowserLaunchListener"));
        }
        return processAdapter;
    }

    public static void addAgentJar(@NotNull JavaParameters params) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/plugins/grails/runner/util/GrailsExecutionUtils", "addAgentJar"));
        }
        String listenerPath = PathUtil.getJarPathForClass(GrailsRtMarker.class);
        for (String vmParam : params.getVMParametersList().getList()) {
            if (!vmParam.startsWith("-javaagent:") || !vmParam.endsWith(listenerPath) && !vmParam.endsWith(AGENT_JAR_SUFFIX)) continue;
            return;
        }
        params.getVMParametersList().add("-javaagent:" + GrailsExecutionUtils.ensureJar(listenerPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String ensureJar(String path) {
        File file = new File(path);
        if (file.isDirectory()) {
            try {
                File tempFile = FileUtil.createTempFile((String)"idea", (String)AGENT_JAR_SUFFIX);
                tempFile.deleteOnExit();
                try (ZipOutputStream zipOutput = new ZipOutputStream(new FileOutputStream(tempFile));){
                    ZipUtil.addDirToZipRecursively((ZipOutputStream)zipOutput, null, (File)file, (String)"", null, null);
                }
                return tempFile.getAbsolutePath();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create template jar", e);
            }
        }
        return path;
    }

    public static void addCommonJvmOptions(@NotNull JavaParameters params) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/plugins/grails/runner/util/GrailsExecutionUtils", "addCommonJvmOptions"));
        }
        if (SystemInfo.isWindows && !params.getVMParametersList().getParametersString().contains("-Djline.WindowsTerminal.directConsole")) {
            params.getVMParametersList().add("-Djline.WindowsTerminal.directConsole=false");
        }
        if (Boolean.getBoolean("idea.grails.disable.class.modification")) {
            params.getVMParametersList().add("-Didea.grails.disable.class.modification=true");
        }
    }
}

