/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.plugins;

import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.ColumnInfo;
import java.awt.FontMetrics;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.mvc.plugins.AvailablePluginsModel;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginDescriptor;

public class MvcPluginsTable
extends JBTable {
    public MvcPluginsTable(AvailablePluginsModel model) {
        super((TableModel)model);
        this.initializeHeader();
        for (int i = 0; i < model.getColumnCount(); ++i) {
            TableColumn column = this.getColumnModel().getColumn(i);
            ColumnInfo columnInfo = model.getColumnInfos()[i];
            column.setCellEditor(columnInfo.getEditor(null));
            if (i != 0 && i != 2) continue;
            String name = columnInfo.getName();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int width = fontMetrics.stringWidth(" " + name + " ");
            if (i == 2) {
                width += fontMetrics.stringWidth(name);
            }
            column.setWidth(width);
            column.setPreferredWidth(width);
            column.setMaxWidth(width);
        }
        this.setSelectionMode(2);
        this.setShowGrid(false);
    }

    public void setValueAt(Object aValue, int row, int column) {
        super.setValueAt(aValue, row, column);
        this.repaint();
    }

    @Nullable
    public TableCellRenderer getCellRenderer(int row, int column) {
        ColumnInfo columnInfo = this.getModel().getColumnInfos()[column];
        return columnInfo.getRenderer(null);
    }

    private void initializeHeader() {
        JTableHeader header = this.getTableHeader();
        header.setReorderingAllowed(false);
    }

    public Object[] getElements() {
        return this.getModel().getAvailablePlugins().toArray();
    }

    @NotNull
    public MvcPluginDescriptor getPluginAt(int row) {
        MvcPluginDescriptor mvcPluginDescriptor = this.getModel().getRowValue(this.convertRowIndexToModel(row));
        if (mvcPluginDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginsTable", "getPluginAt"));
        }
        return mvcPluginDescriptor;
    }

    public AvailablePluginsModel getModel() {
        return (AvailablePluginsModel)super.getModel();
    }

    @Nullable
    public MvcPluginDescriptor getSelectedObject() {
        if (this.getSelectedRowCount() > 0) {
            return this.getPluginAt(this.getSelectedRow());
        }
        return null;
    }

    protected boolean isSortOnUpdates() {
        return false;
    }

    @NotNull
    public MvcPluginDescriptor[] getSelectedObjects() {
        if (this.getSelectedRowCount() == 0) {
            if (MvcPluginDescriptor.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginsTable", "getSelectedObjects"));
            }
            return MvcPluginDescriptor.EMPTY_ARRAY;
        }
        int[] poses = this.getSelectedRows();
        MvcPluginDescriptor[] selection = new MvcPluginDescriptor[poses.length];
        for (int i = 0; i < poses.length; ++i) {
            selection[i] = this.getPluginAt(poses[i]);
        }
        if (selection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginsTable", "getSelectedObjects"));
        }
        return selection;
    }
}

