/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;

public class ObjectKind {
    public static final ObjectKind NONE = new ObjectKind("NONE");
    public static final ObjectKind ROOT = new ObjectKind("ROOT");
    public static final ObjectKind DATABASE = new ObjectKind("DATABASE");
    public static final ObjectKind SCHEMA = new ObjectKind("SCHEMA");
    public static final ObjectKind SEQUENCE = new ObjectKind("SEQUENCE");
    public static final ObjectKind TABLE = new ObjectKind("TABLE");
    public static final ObjectKind COLUMN = new ObjectKind("COLUMN");
    public static final ObjectKind INDEX = new ObjectKind("INDEX");
    public static final ObjectKind KEY = new ObjectKind("KEY");
    public static final ObjectKind FOREIGN_KEY = new ObjectKind("FOREIGN KEY");
    public static final ObjectKind CLUSTER = new ObjectKind("CLUSTER");
    public static final ObjectKind VIEW = new ObjectKind("VIEW");
    public static final ObjectKind MAT_VIEW = new ObjectKind("MATERIALIZED VIEW");
    public static final ObjectKind CHECK = new ObjectKind("CHECK");
    public static final ObjectKind TRIGGER = new ObjectKind("TRIGGER");
    public static final ObjectKind RULE = new ObjectKind("RULE");
    public static final ObjectKind PACKAGE = new ObjectKind("PACKAGE");
    public static final ObjectKind ALIAS_TYPE = new ObjectKind("ALIAS TYPE");
    public static final ObjectKind TABLE_TYPE = new ObjectKind("TABLE TYPE");
    public static final ObjectKind OBJECT_TYPE = new ObjectKind("OBJECT TYPE");
    public static final ObjectKind OBJECT_ATTRIBUTE = new ObjectKind("OBJECT ATTRIBUTE");
    public static final ObjectKind COLLECTION_TYPE = new ObjectKind("COLLECTION TYPE");
    public static final ObjectKind BODY = new ObjectKind("BODY");
    public static final ObjectKind ROUTINE = new ObjectKind("ROUTINE");
    public static final ObjectKind ARGUMENT = new ObjectKind("ARGUMENT");
    public static final ObjectKind OPERATOR = new ObjectKind("OPERATOR");
    public static final ObjectKind VARIABLE = new ObjectKind("VARIABLE");
    public static final ObjectKind SYNONYM = new ObjectKind("SYNONYM");
    public static final ObjectKind DB_LINK = new ObjectKind("DBLINK");
    public static final ObjectKind COMMENT = new ObjectKind("COMMENT");
    public static final ObjectKind UNKNOWN_OBJECT = new ObjectKind("UNKNOWN OBJECT");
    private final String myName;
    public static final Map<String, ObjectKind> ourKinds;

    public ObjectKind(String name) {
        this.myName = name;
    }

    public String name() {
        return this.myName;
    }

    public String code() {
        return this.myName.toLowerCase(Locale.ENGLISH).replace(' ', '-');
    }

    public String toString() {
        return this.code();
    }

    static {
        ObjectKind[] theKinds = new ObjectKind[]{NONE, ROOT, DATABASE, SCHEMA, SEQUENCE, TABLE, COLUMN, INDEX, KEY, FOREIGN_KEY, CLUSTER, VIEW, MAT_VIEW, CHECK, TRIGGER, RULE, PACKAGE, ALIAS_TYPE, TABLE_TYPE, OBJECT_TYPE, OBJECT_ATTRIBUTE, COLLECTION_TYPE, BODY, ROUTINE, ARGUMENT, OPERATOR, VARIABLE, SYNONYM, DB_LINK, COMMENT, UNKNOWN_OBJECT};
        LinkedHashMap m = new LinkedHashMap(40);
        for (ObjectKind kind : theKinds) {
            m.put((Object)kind.code(), (Object)kind);
        }
        ourKinds = Collections.unmodifiableMap(m);
    }
}

