/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.stylus.highlighting;

import com.intellij.ide.highlighter.custom.tokens.TokenInfo;
import com.intellij.lexer.Lexer;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.CssHighlighterLexer;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.stylus.lexer.StylusLexer;
import org.jetbrains.plugins.stylus.psi.StylusTokenTypes;

public class StylusHighlighterLexer
extends CssHighlighterLexer {
    private StylusLexer lookAheadLexer;
    private int currentIndent;

    public StylusHighlighterLexer(@NotNull Set<String> propertyValues) {
        if (propertyValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyValues", "org/jetbrains/plugins/stylus/highlighting/StylusHighlighterLexer", "<init>"));
        }
        super((Lexer)new StylusLexer(), propertyValues);
        this.currentIndent = 0;
        this.lookAheadLexer = new StylusLexer();
    }

    public void advance() {
        IElementType tokenType = this.getTokenType();
        String tokenText = this.getTokenText();
        super.advance();
        if (tokenType == StylusTokenTypes.EOL) {
            this.myAfterColon = false;
            this.myInPropertyValue = false;
            this.myInsideBlock = false;
            this.currentIndent = 0;
        } else if (tokenType == StylusTokenTypes.INDENT) {
            this.myInsideBlock = true;
            this.currentIndent = tokenText.length();
        }
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/plugins/stylus/highlighting/StylusHighlighterLexer", "start"));
        }
        this.currentIndent = 0;
        super.start(buffer, startOffset, endOffset, initialState);
        this.lookAheadLexer.start(this.getDelegate().getBufferSequence(), this.getDelegate().getTokenStart(), this.getDelegate().getBufferEnd(), this.getDelegate().getState());
    }

    public boolean isSelectorAllowed() {
        if (this.currentIndent == 0) {
            return true;
        }
        int i = 1;
        TokenInfo tokenInfo = this.lookAheadInfo(i, false);
        IElementType tokenType = tokenInfo.getType();
        while (tokenType != null && tokenType != StylusTokenTypes.EOL) {
            tokenInfo = this.lookAheadInfo(++i, false);
            tokenType = tokenInfo.getType();
        }
        CharSequence previousIndentText = null;
        if (tokenType == StylusTokenTypes.EOL) {
            while (tokenType != null && (tokenType == CssElementTypes.CSS_WHITE_SPACE || tokenType == StylusTokenTypes.INDENT || tokenType == StylusTokenTypes.EOL || StylusTokenTypes.COMMENTS.contains(tokenType))) {
                if (tokenType == StylusTokenTypes.INDENT) {
                    previousIndentText = this.getBufferSequence().subSequence(tokenInfo.getStart(), tokenInfo.getEnd());
                }
                tokenInfo = this.lookAheadInfo(++i, false);
                tokenType = tokenInfo.getType();
            }
            return previousIndentText != null && previousIndentText.length() > this.currentIndent;
        }
        return false;
    }

    protected Lexer getLookAheadLexer() {
        return this.lookAheadLexer;
    }
}

