/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.sequentialparsers.LocalParsingResult;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserUtil;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.intellij.markdown.parser.sequentialparsers.impl.InlineLinkParser;
import org.intellij.markdown.parser.sequentialparsers.impl.ReferenceLinkParser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/impl/ImageParser;", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser;", "()V", "parse", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$ParsingResult;", "tokens", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "rangesToGlue", "", "Lkotlin/ranges/IntRange;", "52a7eb3df0584991-compileKotlin"})
public final class ImageParser
implements SequentialParser {
    @Override
    @NotNull
    public SequentialParser.ParsingResult parse(@NotNull TokensCache tokens, @NotNull Collection<IntRange> rangesToGlue) {
        Intrinsics.checkParameterIsNotNull((Object)tokens, (String)"tokens");
        Intrinsics.checkParameterIsNotNull(rangesToGlue, (String)"rangesToGlue");
        SequentialParser.ParsingResultBuilder result = new SequentialParser.ParsingResultBuilder();
        ArrayList<Integer> delegateIndices = new ArrayList<Integer>();
        List<Integer> indices = SequentialParserUtil.Companion.textRangesToIndices(rangesToGlue);
        TokensCache.Iterator iterator = tokens.new TokensCache.ListIterator(indices, 0);
        while (iterator.getType() != null) {
            if (Intrinsics.areEqual((Object)iterator.getType(), (Object)MarkdownTokenTypes.EXCLAMATION_MARK) && Intrinsics.areEqual((Object)iterator.rawLookup(1), (Object)MarkdownTokenTypes.LBRACKET)) {
                LocalParsingResult link;
                LocalParsingResult localParsingResult = InlineLinkParser.Companion.parseInlineLink(iterator.advance());
                if (localParsingResult == null) {
                    localParsingResult = link = ReferenceLinkParser.Companion.parseReferenceLink(iterator.advance());
                }
                if (link != null) {
                    result = result.withNode(new SequentialParser.Node(new IntRange(iterator.getIndex(), link.getIteratorPosition().getIndex() + 1), MarkdownElementTypes.IMAGE)).withOtherParsingResult(link);
                    iterator = link.getIteratorPosition().advance();
                    continue;
                }
            }
            delegateIndices.add(iterator.getIndex());
            iterator = iterator.advance();
        }
        return result.withFurtherProcessing(SequentialParserUtil.Companion.indicesToTextRanges((List<Integer>)delegateIndices));
    }
}

