/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.manager.CdiDescriptorsFactory;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiManagedBeanValidationUtils;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiModifierListOwner;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CdiManagedBeanInconsistencyInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/highlighting/CdiManagedBeanInconsistencyInspection", "checkClass"));
        }
        if (aClass.isAnnotationType() || CdiCommonUtils.isManagedBean(aClass) || CdiCommonUtils.isEnterpraiseCdiBean(aClass)) {
            return;
        }
        PsiIdentifier identifier = aClass.getNameIdentifier();
        if (identifier != null) {
            List<String> allAnnotations = CdiCommonUtils.collectCdiBeansAnnotations(module);
            if (CdiCommonUtils.isClassContainsCdiAnnotations(aClass, allAnnotations)) {
                String unallowedAncestor;
                if (!CdiManagedBeanValidationUtils.hasAppropriateConstructor(aClass)) {
                    holder.registerProblem((PsiElement)identifier, CdiInspectionBundle.message("CdiManagedBeanInconsistencyInspection.no.appropriate.constructor", new Object[0]), new LocalQuickFix[0]);
                }
                if (!aClass.hasModifierProperty("abstract") && CdiManagedBeanValidationUtils.isParameterizedType(aClass) && !CdiManagedBeanInconsistencyInspection.isDependentScoped(aClass)) {
                    holder.registerProblem((PsiElement)identifier, CdiInspectionBundle.message("CdiManagedBeanInconsistencyInspection.parameterized.class", new Object[0]), new LocalQuickFix[0]);
                }
                if (CdiManagedBeanValidationUtils.isNonStaticInner(aClass)) {
                    holder.registerProblem((PsiElement)identifier, CdiInspectionBundle.message("CdiManagedBeanInconsistencyInspection.static.inner.class", new Object[0]), new LocalQuickFix[0]);
                }
                if ((unallowedAncestor = CdiManagedBeanValidationUtils.getUnallowedAncestor(aClass)) != null) {
                    holder.registerProblem((PsiElement)identifier, CdiInspectionBundle.message("CdiManagedBeanInconsistencyInspection.unallowed.ancessor", unallowedAncestor), new LocalQuickFix[0]);
                }
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, allAnnotations) && !CdiManagedBeanValidationUtils.isConcreteClass(aClass) && !CdiManagedBeanValidationUtils.isDecoratorClass(aClass)) {
                holder.registerProblem((PsiElement)identifier, CdiInspectionBundle.message("CdiManagedBeanInconsistencyInspection.not.concrete.class", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    private static boolean isDependentScoped(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/cdi/highlighting/CdiManagedBeanInconsistencyInspection", "isDependentScoped"));
        }
        PsiClass type = CdiDescriptorsFactory.createCdiBeanDescriptor(aClass).getScopeType();
        return type != null && "javax.enterprise.context.Dependent".equals(type.getQualifiedName());
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CdiInspectionBundle.message("inspection.name.managed.bean.inconsistency.errors", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiManagedBeanInconsistencyInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("CdiManagedBeanInconsistencyInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiManagedBeanInconsistencyInspection", "getShortName"));
        }
        return "CdiManagedBeanInconsistencyInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiManagedBeanInconsistencyInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }
}

