/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.jam;

import com.intellij.cdi.jam.CdiNamedBean;
import com.intellij.cdi.jam.decorators.CdiDecorator;
import com.intellij.cdi.jam.events.CdiObserves;
import com.intellij.cdi.jam.inject.CdiInject;
import com.intellij.cdi.jam.interceptor.CdiInterceptor;
import com.intellij.cdi.jam.lifecycle.CdiDispose;
import com.intellij.cdi.jam.producers.CdiProduces;
import com.intellij.cdi.jam.specialization.CdiSpecializes;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMemberPattern;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemContributor;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemRegistrar;
import com.intellij.semantic.SemService;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class CdiSemContributor
extends SemContributor {
    private static final SemKey<JamMemberMeta<PsiMember, CdiNamedBean>> NAMED_META_KEY = JamService.ALIASING_MEMBER_META_KEY.subKey("CdiNamedBeanMeta", new SemKey[0]);
    public static final SemKey<CdiNamedBean> NAMED_JAM_KEY = JamService.JAM_ALIASING_ELEMENT_KEY.subKey("CdiNamedBean", new SemKey[0]);
    private final SemService mySemService;

    public CdiSemContributor(SemService semService) {
        this.mySemService = semService;
    }

    public void registerSemProviders(SemRegistrar registrar) {
        PsiMemberPattern.Capture beanPlace = PsiJavaPatterns.psiMember();
        registrar.registerSemElementProvider(NAMED_META_KEY, (ElementPattern)beanPlace, member -> CdiSemContributor.calcNamedBeanMeta(member));
        registrar.registerSemElementProvider(NAMED_JAM_KEY, (ElementPattern)beanPlace, member -> {
            JamMemberMeta memberMeta = (JamMemberMeta)this.mySemService.getSemElement(NAMED_META_KEY, (PsiElement)member);
            return memberMeta != null ? (CdiNamedBean)memberMeta.createJamElement(PsiElementRef.real((PsiElement)member)) : null;
        });
        CdiObserves.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiParameter().withAnnotation("javax.enterprise.event.Observes"));
        CdiDispose.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiParameter().withAnnotation("javax.enterprise.inject.Disposes"));
        CdiInject.METHOD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().withAnnotation("javax.inject.Inject"));
        CdiInject.FIELD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiField().withAnnotation("javax.inject.Inject"));
        CdiProduces.METHOD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().withAnnotation("javax.enterprise.inject.Produces"));
        CdiProduces.FIELD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiField().withAnnotation("javax.enterprise.inject.Produces"));
        CdiInterceptor.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("javax.interceptor.InterceptorBinding"));
        CdiDecorator.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("javax.decorator.Decorator"));
        CdiSpecializes.CLASS_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("javax.enterprise.inject.Specializes"));
        CdiSpecializes.METHOD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().withAnnotation("javax.enterprise.inject.Specializes"));
    }

    private static JamMemberMeta<PsiMember, CdiNamedBean> calcNamedBeanMeta(PsiMember member) {
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)member, (String)"javax.inject.Named", (boolean)true)) {
            return CdiSemContributor.createNamedBeanMeta("javax.inject.Named").addPomTargetProducer((cdiNamedBean, consumer) -> consumer.consume((Object)cdiNamedBean.getPsiTarget()));
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)member);
        if (module != null) {
            Collection<PsiClass> stereotypeAnnotationClasses = CdiCommonUtils.getStereotypeAnnotationClasses(module, "javax.inject.Named");
            for (PsiClass stereotypeAnnotation : stereotypeAnnotationClasses) {
                String annotationFQN = stereotypeAnnotation.getQualifiedName();
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)member, (String)annotationFQN, (boolean)true)) continue;
                return CdiSemContributor.createNamedBeanMeta(annotationFQN);
            }
        }
        return null;
    }

    private static JamMemberMeta<PsiMember, CdiNamedBean> createNamedBeanMeta(final String annotationFQN) {
        return new JamMemberMeta<PsiMember, CdiNamedBean>(null, CdiNamedBean.class, NAMED_JAM_KEY){

            public CdiNamedBean createJamElement(PsiElementRef<PsiMember> psiMemberPsiRef) {
                return CdiSemContributor.createNamedBean((PsiMember)psiMemberPsiRef.getPsiElement(), annotationFQN);
            }
        };
    }

    @Nullable
    private static CdiNamedBean createNamedBean(PsiMember member, String annoName) {
        if (member instanceof PsiClass && !((PsiClass)member).isAnnotationType()) {
            return new CdiNamedBean.ClassMapping((PsiClass)member, annoName);
        }
        if (member instanceof PsiMethod) {
            return new CdiNamedBean.MethodMapping((PsiMethod)member, annoName);
        }
        if (member instanceof PsiField) {
            return new CdiNamedBean.FieldMapping((PsiField)member, annoName);
        }
        return null;
    }
}

