/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.actions;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.editors.gfxtrace.DeviceInfo;
import com.android.tools.idea.editors.gfxtrace.GfxTracer;
import com.android.tools.idea.editors.gfxtrace.forms.ActivitySelector;
import com.android.tools.idea.editors.gfxtrace.forms.TraceDialog;
import com.android.tools.idea.editors.gfxtrace.gapi.GapiPaths;
import com.android.tools.idea.monitor.gpu.GpuMonitorView;
import com.android.tools.idea.profiling.capture.CaptureService;
import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import icons.AndroidIcons;
import java.awt.Component;
import java.awt.Container;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GfxTraceCaptureAction
extends ToggleAction {
    @NotNull
    protected final GpuMonitorView myView;
    @NotNull
    protected final String myText;
    private static JDialog sActiveForm = null;
    private JDialog myActiveForm;

    public GfxTraceCaptureAction(@NotNull GpuMonitorView view, @Nullable String text, @Nullable String description, @Nullable Icon icon) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/editors/gfxtrace/actions/GfxTraceCaptureAction", "<init>"));
        }
        super(text, description, icon);
        this.myActiveForm = null;
        this.myView = view;
        this.myText = text;
    }

    public boolean isSelected(AnActionEvent e) {
        return sActiveForm != null && sActiveForm == this.myActiveForm;
    }

    public final void setSelected(AnActionEvent e, boolean state) {
        IDevice device = this.myView.getDeviceContext().getSelectedDevice();
        if (device == null) {
            return;
        }
        if (this.myActiveForm == sActiveForm) {
            if (sActiveForm != null) {
                this.myActiveForm.setVisible(true);
            } else {
                Container window = ((JComponent)e.getInputEvent().getSource()).getTopLevelAncestor();
                this.start(window, device);
            }
        }
    }

    public final void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        if (!GapiPaths.isValid()) {
            presentation.setEnabled(false);
            presentation.setText(this.myText + " : GPU debugger tools not installed");
        } else {
            presentation.setEnabled(this.isEnabled());
            presentation.setText(this.myText);
        }
    }

    @Nullable
    private static RunConfiguration getSelectedRunConfiguration(@NotNull GpuMonitorView view) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/editors/gfxtrace/actions/GfxTraceCaptureAction", "getSelectedRunConfiguration"));
        }
        Project project = view.getProject();
        RunManager runMgr = RunManager.getInstance((Project)project);
        RunnerAndConfigurationSettings selected = runMgr.getSelectedConfiguration();
        if (selected == null) {
            return null;
        }
        return selected.getConfiguration();
    }

    private IDevice getDevice() {
        return this.myView.getDeviceContext().getSelectedDevice();
    }

    boolean isEnabled() {
        if (sActiveForm == null || sActiveForm == this.myActiveForm) {
            return this.getDevice() != null;
        }
        return false;
    }

    protected void setActiveForm(JDialog form) {
        this.myActiveForm = form;
        sActiveForm = form;
    }

    protected void onStop() {
        this.setActiveForm(null);
    }

    protected GfxTracer.Listener bindListener(final TraceDialog dialog) {
        return new GfxTracer.Listener(){
            @NotNull
            private String myCurrentAction = "";
            private long mySizeInBytes = 0L;

            @Override
            public void onAction(final @NotNull String name) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/gfxtrace/actions/GfxTraceCaptureAction$1", "onAction"));
                }
                EdtExecutor.INSTANCE.execute(new Runnable(){

                    @Override
                    public void run() {
                        myCurrentAction = name;
                        this.update();
                    }
                });
            }

            @Override
            public void onProgress(final long sizeInBytes) {
                EdtExecutor.INSTANCE.execute(new Runnable(){

                    @Override
                    public void run() {
                        mySizeInBytes = sizeInBytes;
                        this.update();
                    }
                });
            }

            @Override
            public void onStopped() {
                dialog.onStop();
            }

            @Override
            public void onError(@NotNull String error) {
                if (error == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/editors/gfxtrace/actions/GfxTraceCaptureAction$1", "onError"));
                }
                dialog.onError(error);
            }

            private void update() {
                long KB = 1024L;
                long MB = 0x100000L;
                long GB = 0x40000000L;
                String details = "";
                if (this.mySizeInBytes > 0L) {
                    details = this.mySizeInBytes < 1024L ? String.format("%d bytes", this.mySizeInBytes) : (this.mySizeInBytes < 0x100000L ? String.format("%.2f KB", Float.valueOf((float)this.mySizeInBytes / 1024.0f)) : (this.mySizeInBytes < 0x40000000L ? String.format("%.2f MB", Float.valueOf((float)this.mySizeInBytes / 1048576.0f)) : String.format("%.2f GB", Float.valueOf((float)this.mySizeInBytes / 1.0737418E9f))));
                }
                dialog.onProgress(this.myCurrentAction, details);
            }
        };
    }

    abstract void start(@NotNull Container var1, @NotNull IDevice var2);

    public static class Launch
    extends GfxTraceCaptureAction {
        private static final String NOTIFICATION_GROUP = "GPU trace";
        private static final String NOTIFICATION_LAUNCH_REQUIRES_ROOT_TITLE = "Rooted device required";
        private static final String NOTIFICATION_LAUNCH_REQUIRES_ROOT_CONTENT = "The device needs to be rooted in order to launch an application for GPU tracing.<br/>To trace your own application on a non-rooted device, build your application with the GPU tracing library.";

        public Launch(@NotNull GpuMonitorView view) {
            if (view == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/editors/gfxtrace/actions/GfxTraceCaptureAction$Launch", "<init>"));
            }
            super(view, "Launch", "Launch in GFX trace mode", AndroidIcons.GfxTrace.InjectSpy);
        }

        @Override
        void start(final @NotNull Container window, final @NotNull IDevice device) {
            if (window == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/android/tools/idea/editors/gfxtrace/actions/GfxTraceCaptureAction$Launch", "start"));
            }
            if (device == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/editors/gfxtrace/actions/GfxTraceCaptureAction$Launch", "start"));
            }
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){
                private static final int ROOT_QUERY_TIMEOUT = 3000;
                private static final int ROOT_QUERY_INTERVAL = 250;

                @Override
                public void run() {
                    try {
                        if (device.root()) {
                            this.rootingSucceeded();
                        } else {
                            this.rootingFailed();
                        }
                        return;
                    }
                    catch (Exception exception) {
                        new Runnable(){
                            long start = System.currentTimeMillis();

                            @Override
                            public void run() {
                                try {
                                    if (device.isRoot()) {
                                        this.rootingSucceeded();
                                    } else {
                                        this.rootingFailed();
                                    }
                                }
                                catch (Exception ignored) {
                                    if (System.currentTimeMillis() - this.start < 3000L) {
                                        JobScheduler.getScheduler().schedule(this, 250L, TimeUnit.MILLISECONDS);
                                    }
                                    this.rootingFailed();
                                }
                            }
                        }.run();
                        return;
                    }
                }

                private void rootingFailed() {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Notifications.Bus.notify((Notification)new Notification(Launch.NOTIFICATION_GROUP, Launch.NOTIFICATION_LAUNCH_REQUIRES_ROOT_TITLE, Launch.NOTIFICATION_LAUNCH_REQUIRES_ROOT_CONTENT, NotificationType.ERROR));
                        }
                    });
                    this.onStop();
                }

                private void rootingSucceeded() {
                    this.showLauncher(window, device, GfxTraceCaptureAction.getSelectedRunConfiguration(myView));
                }
            });
        }

        private void showLauncher(Component owner, final IDevice device, final RunConfiguration runConfig) {
            DeviceInfo.PkgInfoProvider provider = new DeviceInfo.PkgInfoProvider(device);
            final ActivitySelector selector = new ActivitySelector(provider);
            selector.setListener(new ActivitySelector.Listener(){

                @Override
                public void OnLaunch(DeviceInfo.Package pkg, DeviceInfo.Activity act, String name) {
                    this.showTraceDialog(selector, device, pkg, act, runConfig, name);
                }

                @Override
                public void OnCancel() {
                    this.onStop();
                }
            });
            selector.setLocationRelativeTo(owner);
            selector.setTitle("Launch activity...");
            selector.setVisible(true);
            this.setActiveForm(selector);
        }

        private void showTraceDialog(Component owner, final IDevice device, final DeviceInfo.Package pkg, final DeviceInfo.Activity act, final RunConfiguration runConfig, String name) {
            final TraceDialog dialog = new TraceDialog();
            dialog.setListener(new TraceDialog.Listener(){
                private GfxTracer myTracer = null;

                @Override
                public void onStartTrace(@NotNull String name) {
                    if (name == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/gfxtrace/actions/GfxTraceCaptureAction$Launch$3", "onStartTrace"));
                    }
                    GfxTracer.Options options = GfxTracer.Options.fromRunConfiguration(runConfig);
                    options.myTraceName = name;
                    this.myTracer = GfxTracer.launch(myView.getProject(), device, pkg, act, options, this.bindListener(dialog));
                }

                @Override
                public void onStopTrace() {
                    this.myTracer.stop();
                    this.onStop();
                }

                @Override
                public void onCancelTrace() {
                    this.onStop();
                }
            });
            dialog.setLocationRelativeTo(owner);
            dialog.setDefaultName(name.isEmpty() ? pkg.getDisplayName() : name);
            dialog.setVisible(true);
            this.setActiveForm(dialog);
            dialog.onBegin();
        }
    }

    public static class Listen
    extends GfxTraceCaptureAction {
        public Listen(@NotNull GpuMonitorView view) {
            if (view == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/editors/gfxtrace/actions/GfxTraceCaptureAction$Listen", "<init>"));
            }
            super(view, "Listen", "Listen for GFX traces", AndroidIcons.GfxTrace.ListenForTrace);
        }

        @Override
        void start(@NotNull Container window, final @NotNull IDevice device) {
            if (window == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/android/tools/idea/editors/gfxtrace/actions/GfxTraceCaptureAction$Listen", "start"));
            }
            if (device == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/editors/gfxtrace/actions/GfxTraceCaptureAction$Listen", "start"));
            }
            final TraceDialog dialog = new TraceDialog();
            dialog.setListener(new TraceDialog.Listener(){
                private GfxTracer myTracer = null;

                @Override
                public void onStartTrace(@NotNull String name) {
                    if (name == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/gfxtrace/actions/GfxTraceCaptureAction$Listen$1", "onStartTrace"));
                    }
                    GfxTracer.Options options = GfxTracer.Options.fromRunConfiguration(GfxTraceCaptureAction.getSelectedRunConfiguration(myView));
                    options.myTraceName = name;
                    this.myTracer = GfxTracer.listen(myView.getProject(), device, options, this.bindListener(dialog));
                }

                @Override
                public void onStopTrace() {
                    this.myTracer.stop();
                    this.onStop();
                }

                @Override
                public void onCancelTrace() {
                    this.onStop();
                }
            });
            CaptureService service = CaptureService.getInstance(this.myView.getProject());
            String name = service.getSuggestedName(this.myView.getDeviceContext().getSelectedClient());
            dialog.setLocationRelativeTo(window);
            dialog.setDefaultName(name);
            dialog.setVisible(true);
            this.setActiveForm(dialog);
        }
    }
}

