/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.gapi;

import com.android.tools.idea.editors.gfxtrace.gapi.ChildProcess;
import com.android.tools.idea.editors.gfxtrace.gapi.GapiPaths;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

public final class GapirProcess
extends ChildProcess {
    @NotNull
    private static final Logger LOG = Logger.getInstance(GapirProcess.class);
    private static final Object myInstanceLock = new Object();
    private static GapirProcess myInstance;
    private static final int SERVER_LAUNCH_TIMEOUT_MS = 10000;
    private final SettableFuture<Integer> myPortF = this.start();

    private GapirProcess() {
        super("gapir");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = myInstanceLock;
        synchronized (object) {
            if (myInstance == this) {
                myInstance = null;
                super.shutdown();
                this.myProcess.destroy();
            }
        }
    }

    @Override
    protected boolean prepare(ProcessBuilder pb) {
        if (!GapiPaths.gapir().exists()) {
            LOG.warn("Could not find gapir.");
            return false;
        }
        pb.command(GapiPaths.gapir().getAbsolutePath(), "--log", new File(PathManager.getLogPath(), "gapir.log").getAbsolutePath());
        return true;
    }

    @Override
    protected void onExit(int code) {
        if (code != 0) {
            LOG.warn("The gapir process exited with a non-zero exit value: " + code);
        } else {
            LOG.info("gapir exited cleanly");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GapirProcess get() {
        Object object = myInstanceLock;
        synchronized (object) {
            if (myInstance == null) {
                myInstance = new GapirProcess();
            }
            return myInstance;
        }
    }

    public int getPort() {
        if (this.myPortF == null) {
            return -1;
        }
        try {
            return (Integer)this.myPortF.get(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting for gapir: " + e);
        }
        catch (ExecutionException e) {
            LOG.warn("Failed while waiting for gapir: " + e);
        }
        catch (TimeoutException e) {
            LOG.warn("Timed out waiting for gapir: " + e);
        }
        return -1;
    }
}

