/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.project.AndroidGradleProjectComponent;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.GradleProjectSyncData;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.project.subset.ProjectSubset;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.ui.GuiUtils;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProjectSetUpTask
implements ExternalProjectRefreshCallback {
    private static final Logger LOG = Logger.getInstance(ProjectSetUpTask.class);
    @NotNull
    private final Project myProject;
    private final boolean myProjectIsNew;
    private final boolean mySelectModulesToImport;
    private final boolean mySyncSkipped;
    @Nullable
    private final GradleSyncListener mySyncListener;

    ProjectSetUpTask(@NotNull Project project, boolean projectIsNew, boolean selectModulesToImport, boolean syncSkipped, @Nullable GradleSyncListener syncListener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/ProjectSetUpTask", "<init>"));
        }
        this.myProject = project;
        this.myProjectIsNew = projectIsNew;
        this.mySelectModulesToImport = selectModulesToImport;
        this.mySyncSkipped = syncSkipped;
        this.mySyncListener = syncListener;
    }

    public void onSuccess(@Nullable DataNode<ProjectData> projectInfo) {
        assert (projectInfo != null);
        this.populateProject(projectInfo);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!(!ProjectSetUpTask.this.myProjectIsNew || ApplicationManager.getApplication().isUnitTestMode() && GradleProjectImporter.ourSkipSetupFromTest)) {
                    Projects.open(ProjectSetUpTask.this.myProject);
                }
                if (ProjectSetUpTask.this.myProjectIsNew) {
                    AndroidGradleProjectComponent projectComponent = AndroidGradleProjectComponent.getInstance(ProjectSetUpTask.this.myProject);
                    projectComponent.configureGradleProject();
                }
                if (ProjectSetUpTask.this.mySyncListener != null) {
                    if (ProjectSetUpTask.this.mySyncSkipped) {
                        ProjectSetUpTask.this.mySyncListener.syncSkipped(ProjectSetUpTask.this.myProject);
                    } else {
                        ProjectSetUpTask.this.mySyncListener.syncSucceeded(ProjectSetUpTask.this.myProject);
                    }
                }
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable.run();
        } else {
            GuiUtils.invokeLaterIfNeeded((Runnable)runnable, (ModalityState)ModalityState.defaultModalityState());
        }
    }

    private void populateProject(final @NotNull DataNode<ProjectData> projectInfo) {
        if (projectInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectInfo", "com/android/tools/idea/gradle/project/ProjectSetUpTask", "populateProject"));
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                Projects.populate(ProjectSetUpTask.this.myProject, ProjectSetUpTask.this.getModulesToImport((DataNode<ProjectData>)projectInfo));
            }
        });
    }

    @NotNull
    private Collection<DataNode<ModuleData>> getModulesToImport(DataNode<ProjectData> projectInfo) {
        Collection modules = ExternalSystemApiUtil.findAll(projectInfo, (Key)ProjectKeys.MODULE);
        ProjectSubset subview = ProjectSubset.getInstance(this.myProject);
        if (!ApplicationManager.getApplication().isUnitTestMode() && ProjectSubset.isSettingEnabled() && modules.size() > 1) {
            if (this.mySelectModulesToImport) {
                Collection<DataNode<ModuleData>> selection = subview.showModuleSelectionDialog(modules);
                if (selection != null) {
                    Collection<DataNode<ModuleData>> collection = selection;
                    if (collection == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/ProjectSetUpTask", "getModulesToImport"));
                    }
                    return collection;
                }
            } else {
                int moduleCount;
                Object[] persistedModuleNames = subview.getSelection();
                if (persistedModuleNames != null && (moduleCount = persistedModuleNames.length) > 0) {
                    ArrayList moduleNames = Lists.newArrayList((Object[])persistedModuleNames);
                    ArrayList selectedModules = Lists.newArrayListWithExpectedSize((int)moduleCount);
                    for (DataNode module : modules) {
                        String name = ((ModuleData)module.getData()).getExternalName();
                        if (!moduleNames.contains(name)) continue;
                        selectedModules.add(module);
                    }
                    ArrayList arrayList = selectedModules;
                    if (arrayList == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/ProjectSetUpTask", "getModulesToImport"));
                    }
                    return arrayList;
                }
            }
        }
        subview.clearSelection();
        Collection collection = modules;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/ProjectSetUpTask", "getModulesToImport"));
        }
        return collection;
    }

    public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/idea/gradle/project/ProjectSetUpTask", "onFailure"));
        }
        if (errorDetails != null) {
            LOG.warn(errorDetails);
        }
        String newMessage = ExternalSystemBundle.message((String)"error.resolve.with.reason", (Object[])new Object[]{errorMessage});
        LOG.info(newMessage);
        GradleProjectSyncData.removeFrom(this.myProject);
        GradleSyncState.getInstance(this.myProject).syncFailed(newMessage);
        if (this.mySyncListener != null) {
            this.mySyncListener.syncFailed(this.myProject, newMessage);
        }
    }
}

