/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.quickfix;

import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractGradleAwareFix
implements IntentionAction,
LocalQuickFix,
HighPriorityAction {
    AbstractGradleAwareFix() {
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/quickfix/AbstractGradleAwareFix", "getName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/quickfix/AbstractGradleAwareFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/android/tools/idea/gradle/quickfix/AbstractGradleAwareFix", "applyFix"));
        }
        this.invoke(project, null, descriptor.getPsiElement().getContainingFile());
    }

    static void registerUndoAction(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/quickfix/AbstractGradleAwareFix", "registerUndoAction"));
        }
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(){

            public void undo() throws UnexpectedUndoException {
                AbstractGradleAwareFix.requestProjectSync(project);
            }

            public void redo() throws UnexpectedUndoException {
                AbstractGradleAwareFix.requestProjectSync(project);
            }
        });
    }

    private static void requestProjectSync(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/quickfix/AbstractGradleAwareFix", "requestProjectSync"));
        }
        GradleProjectImporter.getInstance().requestProjectSync(project, false, null);
    }

    protected static void runWriteCommandActionAndSync(final @NotNull Project project, final @NotNull Runnable action, final @Nullable GradleSyncListener syncListener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/quickfix/AbstractGradleAwareFix", "runWriteCommandActionAndSync"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/idea/gradle/quickfix/AbstractGradleAwareFix", "runWriteCommandActionAndSync"));
        }
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)action);
                GradleProjectImporter.getInstance().requestProjectSync(project, false, syncListener);
            }
        });
    }
}

