/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables;

import com.android.tools.idea.gradle.structure.configurables.editor.ModuleEditor;
import com.android.tools.idea.gradle.structure.configurables.editor.TabbedModuleEditor;
import com.android.tools.idea.gradle.structure.configurables.model.ModuleMergedModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleConfigurable
extends ProjectStructureElementConfigurable<ModuleMergedModel>
implements SearchableConfigurable,
Place.Navigator {
    @NotNull
    private final ModuleMergedModel myModel;
    @NotNull
    private final ModuleEditor myModuleEditor;
    private String myDisplayName;

    public ModuleConfigurable(@NotNull ModuleMergedModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/structure/configurables/ModuleConfigurable", "<init>"));
        }
        this.myModel = model;
        this.myDisplayName = model.getModuleName();
        this.myModuleEditor = new TabbedModuleEditor(model);
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        return this.myModuleEditor.navigateTo(place, requestFocus);
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/android/tools/idea/gradle/structure/configurables/ModuleConfigurable", "queryPlace"));
        }
        this.myModuleEditor.queryPlace(place);
    }

    @NotNull
    public String getId() {
        String string = "module." + this.myDisplayName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/ModuleConfigurable", "getId"));
        }
        return string;
    }

    @Nls
    public String getDisplayName() {
        return this.myDisplayName;
    }

    @Nullable
    public String getHelpTopic() {
        return this.myModuleEditor.getHelpTopic();
    }

    public void setDisplayName(String name) {
        this.myDisplayName = name;
    }

    public ModuleMergedModel getEditableObject() {
        return this.myModel;
    }

    public String getBannerSlogan() {
        return "Module '" + this.myDisplayName + "'";
    }

    public boolean isModified() {
        return false;
    }

    public JComponent createOptionsPanel() {
        return this.myModuleEditor.getPanel();
    }

    public void apply() throws ConfigurationException {
    }

    public void reset() {
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myModuleEditor);
    }

    @Nullable
    public ProjectStructureElement getProjectStructureElement() {
        return null;
    }

    @Nullable
    public Icon getIcon(boolean expanded) {
        return this.myModel.getIcon();
    }

    public void setHistory(History history) {
    }
}

