/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.SdkConstants;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Dependencies;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.NativeAndroidGradleModel;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.eclipse.GradleImport;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.facet.AndroidGradleFacetConfiguration;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.service.notification.hyperlink.SearchInBuildFilesHyperlink;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.gradle.util.GradleProperties;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.util.PropertiesUtil;
import com.android.tools.idea.startup.AndroidStudioInitializer;
import com.android.tools.idea.templates.TemplateManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.jarFinder.InternetAttachSourceProvider;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public final class GradleUtil {
    public static final ProjectSystemId GRADLE_SYSTEM_ID = GradleConstants.SYSTEM_ID;
    @NonNls
    public static final String BUILD_DIR_DEFAULT_NAME = "build";
    @NonNls
    public static final String GRADLEW_PROPERTIES_PATH = FileUtil.join((String[])new String[]{SdkConstants.FD_GRADLE_WRAPPER, "gradle-wrapper.properties"});
    @NonNls
    private static final String ANDROID_PLUGIN_GROUP_ID = "com.android.tools.build";
    @NonNls
    private static final String ANDROID_PLUGIN_ARTIFACT_ID = "gradle";
    private static final Logger LOG = Logger.getInstance(GradleUtil.class);
    private static final Pattern GRADLE_JAR_NAME_PATTERN = Pattern.compile("gradle-([^-]*)-(.*)\\.jar");
    private static final String SOURCES_JAR_NAME_SUFFIX = "-sources.jar";
    private static final CharMatcher ILLEGAL_GRADLE_PATH_CHARS_MATCHER = CharMatcher.anyOf((CharSequence)"\\/");
    private static final Pattern GRADLE_DISTRIBUTION_URL_PATTERN = Pattern.compile(".*-([^-]+)-([^.]+).zip");

    private GradleUtil() {
    }

    public static void clearStoredGradleJvmArgs(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "clearStoredGradleJvmArgs"));
        }
        GradleSettings settings = GradleSettings.getInstance((Project)project);
        final String existingJvmArgs = settings.getGradleVmOptions();
        settings.setGradleVmOptions(null);
        if (!StringUtil.isEmptyOrSpaces((String)existingJvmArgs)) {
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    String jvmArgs = existingJvmArgs.trim();
                    String msg = String.format("Starting with version 1.3, Android Studio no longer supports IDE-specific Gradle JVM arguments.\n\nAndroid Studio will now remove any stored Gradle JVM arguments.\n\nWould you like to copy these JVM arguments:\n%1$s\nto the project's gradle.properties file?\n\n(Any existing JVM arguments in the gradle.properties file will be overwritten.)", jvmArgs);
                    int result = Messages.showYesNoDialog((Project)project, (String)msg, (String)"Gradle Settings", (Icon)Messages.getQuestionIcon());
                    if (result == 0) {
                        try {
                            GradleProperties gradleProperties = new GradleProperties(project);
                            gradleProperties.setJvmArgs(jvmArgs);
                            gradleProperties.save();
                        }
                        catch (IOException e) {
                            String err = String.format("Failed to copy JVM arguments '%1$s' to the project's gradle.properties file.", existingJvmArgs);
                            LOG.info(err, (Throwable)e);
                            String cause = e.getMessage();
                            if (StringUtil.isNotEmpty((String)cause)) {
                                err = err + String.format("<br>\nCause: %1$s", cause);
                            }
                            AndroidGradleNotification.getInstance(project).showBalloon("Gradle Settings", err, NotificationType.ERROR);
                        }
                    } else {
                        String text = String.format("JVM arguments<br>\n'%1$s'<br>\nwere not copied to the project's gradle.properties file.", existingJvmArgs);
                        AndroidGradleNotification.getInstance(project).showBalloon("Gradle Settings", text, NotificationType.WARNING);
                    }
                }
            });
        }
    }

    public static boolean isSupportedGradleVersion(@NotNull GradleVersion gradleVersion) {
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/gradle/util/GradleUtil", "isSupportedGradleVersion"));
        }
        GradleVersion supported = GradleVersion.parse((String)"2.2.1");
        return supported.compareTo(gradleVersion) <= 0;
    }

    @Deprecated
    @NotNull
    public static AndroidArtifactOutput getOutput(@NotNull AndroidArtifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/util/GradleUtil", "getOutput"));
        }
        Collection outputs = artifact.getOutputs();
        assert (!outputs.isEmpty());
        AndroidArtifactOutput output = (AndroidArtifactOutput)ContainerUtil.getFirstItem((Collection)outputs);
        assert (output != null);
        AndroidArtifactOutput androidArtifactOutput = output;
        if (androidArtifactOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getOutput"));
        }
        return androidArtifactOutput;
    }

    @NotNull
    public static Icon getModuleIcon(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/GradleUtil", "getModuleIcon"));
        }
        AndroidProject androidProject = GradleUtil.getAndroidProject(module);
        if (androidProject != null) {
            Icon icon = androidProject.isLibrary() ? AndroidIcons.LibraryModule : AndroidIcons.AppModule;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getModuleIcon"));
            }
            return icon;
        }
        Icon icon = Projects.requiresAndroidModel(module.getProject()) ? AllIcons.Nodes.PpJdk : AllIcons.Nodes.Module;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getModuleIcon"));
        }
        return icon;
    }

    @Nullable
    public static AndroidProject getAndroidProject(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/GradleUtil", "getAndroidProject"));
        }
        AndroidGradleModel gradleModel = AndroidGradleModel.get(module);
        return gradleModel != null ? gradleModel.getAndroidProject() : null;
    }

    @Nullable
    public static NativeAndroidProject getNativeAndroidProject(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/GradleUtil", "getNativeAndroidProject"));
        }
        NativeAndroidGradleModel gradleModel = NativeAndroidGradleModel.get(module);
        return gradleModel != null ? gradleModel.getNativeAndroidProject() : null;
    }

    @Nullable
    public static String getGradlePath(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/GradleUtil", "getGradlePath"));
        }
        AndroidGradleFacet facet = AndroidGradleFacet.getInstance(module);
        return facet != null ? ((AndroidGradleFacetConfiguration)facet.getConfiguration()).GRADLE_PROJECT_PATH : null;
    }

    public static boolean isRootModuleWithNoSources(@NotNull Module module) {
        String gradlePath;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/GradleUtil", "isRootModuleWithNoSources"));
        }
        return ModuleRootManager.getInstance((Module)module).getSourceRoots().length == 0 && ((gradlePath = GradleUtil.getGradlePath(module)) == null || gradlePath.equals(":"));
    }

    @NotNull
    public static List<AndroidLibrary> getDirectLibraryDependencies(@NotNull Variant variant, @NotNull AndroidGradleModel androidModel) {
        if (variant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variant", "com/android/tools/idea/gradle/util/GradleUtil", "getDirectLibraryDependencies"));
        }
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/util/GradleUtil", "getDirectLibraryDependencies"));
        }
        ArrayList libraries = Lists.newArrayList();
        libraries.addAll(variant.getMainArtifact().getDependencies().getLibraries());
        BaseArtifact testArtifact = androidModel.findSelectedTestArtifact(variant);
        if (testArtifact != null) {
            libraries.addAll(testArtifact.getDependencies().getLibraries());
        }
        ArrayList arrayList = libraries;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getDirectLibraryDependencies"));
        }
        return arrayList;
    }

    @Nullable
    public static Module findModuleByGradlePath(@NotNull Project project, @NotNull String gradlePath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "findModuleByGradlePath"));
        }
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/util/GradleUtil", "findModuleByGradlePath"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            AndroidGradleFacet gradleFacet = AndroidGradleFacet.getInstance(module);
            if (gradleFacet == null || !gradlePath.equals(((AndroidGradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH)) continue;
            return module;
        }
        return null;
    }

    @NotNull
    public static List<String> getPathSegments(@NotNull String gradlePath) {
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/util/GradleUtil", "getPathSegments"));
        }
        List list = Splitter.on((String)":").omitEmptyStrings().splitToList((CharSequence)gradlePath);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getPathSegments"));
        }
        return list;
    }

    @Nullable
    public static VirtualFile getGradleBuildFile(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleBuildFile"));
        }
        AndroidGradleFacet gradleFacet = AndroidGradleFacet.getInstance(module);
        if (gradleFacet != null && gradleFacet.getGradleModel() != null) {
            return gradleFacet.getGradleModel().getBuildFile();
        }
        File moduleFilePath = new File(module.getModuleFilePath());
        File parentFile = moduleFilePath.getParentFile();
        return parentFile != null ? GradleUtil.getGradleBuildFile(parentFile) : null;
    }

    @Nullable
    public static VirtualFile getGradleBuildFile(@NotNull File dirPath) {
        if (dirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirPath", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleBuildFile"));
        }
        File gradleBuildFilePath = GradleUtil.getGradleBuildFilePath(dirPath);
        return VfsUtil.findFileByIoFile((File)gradleBuildFilePath, (boolean)true);
    }

    @NotNull
    public static File getGradleBuildFilePath(@NotNull File dirPath) {
        if (dirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirPath", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleBuildFilePath"));
        }
        File file = new File(dirPath, "build.gradle");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleBuildFilePath"));
        }
        return file;
    }

    @Nullable
    public static VirtualFile getGradleSettingsFile(@NotNull File dirPath) {
        if (dirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirPath", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleSettingsFile"));
        }
        File gradleSettingsFilePath = GradleUtil.getGradleSettingsFilePath(dirPath);
        return VfsUtil.findFileByIoFile((File)gradleSettingsFilePath, (boolean)true);
    }

    @NotNull
    public static File getGradleSettingsFilePath(@NotNull File dirPath) {
        if (dirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirPath", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleSettingsFilePath"));
        }
        File file = new File(dirPath, "settings.gradle");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleSettingsFilePath"));
        }
        return file;
    }

    @NotNull
    public static File getGradleWrapperPropertiesFilePath(@NotNull File projectRootDir) {
        if (projectRootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectRootDir", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleWrapperPropertiesFilePath"));
        }
        File file = new File(projectRootDir, GRADLEW_PROPERTIES_PATH);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleWrapperPropertiesFilePath"));
        }
        return file;
    }

    public static boolean updateGradleDistributionUrl(@NotNull Project project, @NotNull File propertiesFile, @NotNull String gradleVersion) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "updateGradleDistributionUrl"));
        }
        if (propertiesFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesFile", "com/android/tools/idea/gradle/util/GradleUtil", "updateGradleDistributionUrl"));
        }
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/gradle/util/GradleUtil", "updateGradleDistributionUrl"));
        }
        try {
            boolean updated = GradleUtil.updateGradleDistributionUrl(gradleVersion, propertiesFile);
            if (updated) {
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)propertiesFile, (boolean)true);
                if (virtualFile != null) {
                    virtualFile.refresh(false, false);
                }
                return true;
            }
        }
        catch (IOException e) {
            String msg = String.format("Unable to update Gradle wrapper to use Gradle %1$s\n", gradleVersion);
            msg = msg + e.getMessage();
            Messages.showErrorDialog((Project)project, (String)msg, (String)"Unexpected Error");
        }
        return false;
    }

    public static boolean updateGradleDistributionUrl(@NotNull String gradleVersion, @NotNull File propertiesFile) throws IOException {
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/gradle/util/GradleUtil", "updateGradleDistributionUrl"));
        }
        if (propertiesFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesFile", "com/android/tools/idea/gradle/util/GradleUtil", "updateGradleDistributionUrl"));
        }
        Properties properties = PropertiesUtil.getProperties(propertiesFile);
        String gradleDistributionUrl = GradleUtil.getGradleDistributionUrl(gradleVersion, false);
        String property = properties.getProperty("distributionUrl");
        if (property != null && (property.equals(gradleDistributionUrl) || property.equals(GradleUtil.getGradleDistributionUrl(gradleVersion, true)))) {
            return false;
        }
        properties.setProperty("distributionUrl", gradleDistributionUrl);
        PropertiesUtil.savePropertiesToFile(properties, propertiesFile, null);
        return true;
    }

    @Nullable
    public static String getGradleWrapperVersion(@NotNull File propertiesFile) throws IOException {
        Matcher m;
        if (propertiesFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesFile", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleWrapperVersion"));
        }
        Properties properties = PropertiesUtil.getProperties(propertiesFile);
        String url = properties.getProperty("distributionUrl");
        if (url != null && (m = GRADLE_DISTRIBUTION_URL_PATTERN.matcher(url)).matches()) {
            return m.group(1);
        }
        return null;
    }

    @NotNull
    private static String getGradleDistributionUrl(@NotNull String gradleVersion, boolean binOnly) {
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleDistributionUrl"));
        }
        String suffix = binOnly ? "bin" : "all";
        String string = String.format("https://services.gradle.org/distributions/gradle-%1$s-" + suffix + ".zip", gradleVersion);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleDistributionUrl"));
        }
        return string;
    }

    @Nullable
    public static GradleExecutionSettings getGradleExecutionSettings(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleExecutionSettings"));
        }
        GradleProjectSettings projectSettings = GradleUtil.getGradleProjectSettings(project);
        if (projectSettings == null) {
            File baseDirPath = Projects.getBaseDirPath(project);
            String msg = String.format("Unable to obtain Gradle project settings for project '%1$s', located at '%2$s'", project.getName(), baseDirPath.getPath());
            LOG.info(msg);
            return null;
        }
        try {
            GradleExecutionSettings settings = (GradleExecutionSettings)ExternalSystemApiUtil.getExecutionSettings((Project)project, (String)projectSettings.getExternalProjectPath(), (ProjectSystemId)GRADLE_SYSTEM_ID);
            if (settings != null) {
                settings.setRemoteProcessIdleTtlInMs(-1L);
            }
            return settings;
        }
        catch (IllegalArgumentException e) {
            LOG.info("Failed to obtain Gradle execution settings", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static File findWrapperPropertiesFile(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "findWrapperPropertiesFile"));
        }
        String basePath = project.getBasePath();
        if (basePath == null) {
            return null;
        }
        File baseDir = new File(basePath);
        File wrapperPropertiesFile = GradleUtil.getGradleWrapperPropertiesFilePath(baseDir);
        return wrapperPropertiesFile.isFile() ? wrapperPropertiesFile : null;
    }

    @Nullable
    public static GradleProjectSettings getGradleProjectSettings(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleProjectSettings"));
        }
        GradleSettings settings = (GradleSettings)ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GRADLE_SYSTEM_ID);
        GradleSettings.MyState state = settings.getState();
        assert (state != null);
        Set allProjectsSettings = state.getLinkedExternalProjectsSettings();
        return GradleUtil.getFirstNotNull(allProjectsSettings);
    }

    @Nullable
    private static GradleProjectSettings getFirstNotNull(@Nullable Set<GradleProjectSettings> allProjectSettings) {
        if (allProjectSettings != null) {
            for (GradleProjectSettings settings : allProjectSettings) {
                if (settings == null) continue;
                return settings;
            }
        }
        return null;
    }

    @VisibleForTesting
    @Nullable
    static String getGradleInvocationJvmArg(@Nullable BuildMode buildMode) {
        if (BuildMode.ASSEMBLE_TRANSLATE == buildMode) {
            return AndroidGradleSettings.createJvmArg((String)"enableTranslation", (boolean)true);
        }
        return null;
    }

    public static void stopAllGradleDaemonsAndRestart() {
        DefaultGradleConnector.close();
        Application application = ApplicationManager.getApplication();
        if (application instanceof ApplicationImpl) {
            ((ApplicationImpl)application).restart(true);
        } else {
            application.restart();
        }
    }

    @NotNull
    public static String getDefaultPhysicalPathFromGradlePath(@NotNull String gradlePath) {
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/util/GradleUtil", "getDefaultPhysicalPathFromGradlePath"));
        }
        List<String> segments = GradleUtil.getPathSegments(gradlePath);
        String string = FileUtil.join((String[])ArrayUtil.toStringArray(segments));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getDefaultPhysicalPathFromGradlePath"));
        }
        return string;
    }

    @NotNull
    public static File getModuleDefaultPath(@NotNull VirtualFile parentDir, @NotNull String gradlePath) {
        if (parentDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDir", "com/android/tools/idea/gradle/util/GradleUtil", "getModuleDefaultPath"));
        }
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/util/GradleUtil", "getModuleDefaultPath"));
        }
        assert (gradlePath.length() > 0);
        String relativePath = GradleUtil.getDefaultPhysicalPathFromGradlePath(gradlePath);
        File file = new File(VfsUtilCore.virtualToIoFile((VirtualFile)parentDir), relativePath);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getModuleDefaultPath"));
        }
        return file;
    }

    public static int isValidGradlePath(@NotNull String gradlePath) {
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/util/GradleUtil", "isValidGradlePath"));
        }
        return ILLEGAL_GRADLE_PATH_CHARS_MATCHER.indexIn((CharSequence)gradlePath);
    }

    public static boolean hasModule(@Nullable Project project, @NotNull String gradlePath, boolean checkProjectFolder) {
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/util/GradleUtil", "hasModule"));
        }
        if (project == null) {
            return false;
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!gradlePath.equals(GradleUtil.getGradlePath(module))) continue;
            return true;
        }
        if (checkProjectFolder) {
            File location = GradleUtil.getModuleDefaultPath(project.getBaseDir(), gradlePath);
            if (location.isFile()) {
                return true;
            }
            if (location.isDirectory()) {
                File[] children = location.listFiles();
                return children == null || children.length > 0;
            }
            return false;
        }
        return false;
    }

    public static void cleanUpPreferences(@NotNull ExtensionPoint<ConfigurableEP<Configurable>> preferences, @NotNull List<String> bundlesToRemove) {
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/android/tools/idea/gradle/util/GradleUtil", "cleanUpPreferences"));
        }
        if (bundlesToRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundlesToRemove", "com/android/tools/idea/gradle/util/GradleUtil", "cleanUpPreferences"));
        }
        ArrayList nonStudioExtensions = Lists.newArrayList();
        ConfigurableEP[] extensions = (ConfigurableEP[])preferences.getExtensions();
        for (ConfigurableEP extension : extensions) {
            if (!bundlesToRemove.contains(extension.instanceClass)) continue;
            nonStudioExtensions.add(extension);
        }
        for (ConfigurableEP toRemove : nonStudioExtensions) {
            preferences.unregisterExtension((Object)toRemove);
        }
    }

    @Nullable
    public static GradleVersion getGradleVersion(@NotNull Project project) {
        GradleVersion revision;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleVersion"));
        }
        String gradleVersion = Projects.getGradleVersionUsed(project);
        if (StringUtil.isNotEmpty((String)gradleVersion) && (revision = GradleVersion.tryParse((String)GradleUtil.removeTimestampFromGradleVersion(gradleVersion))) != null) {
            return revision;
        }
        GradleProjectSettings gradleSettings = GradleUtil.getGradleProjectSettings(project);
        if (gradleSettings != null) {
            String gradleHome;
            DistributionType distributionType = gradleSettings.getDistributionType();
            if (distributionType == DistributionType.DEFAULT_WRAPPED) {
                File wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project);
                if (wrapperPropertiesFile != null) {
                    try {
                        String wrapperVersion = GradleUtil.getGradleWrapperVersion(wrapperPropertiesFile);
                        if (wrapperVersion != null) {
                            return GradleVersion.tryParse((String)GradleUtil.removeTimestampFromGradleVersion(wrapperVersion));
                        }
                    }
                    catch (IOException e) {
                        LOG.info("Failed to read Gradle version in wrapper", (Throwable)e);
                    }
                }
            } else if (distributionType == DistributionType.LOCAL && StringUtil.isNotEmpty((String)(gradleHome = gradleSettings.getGradleHome()))) {
                File gradleHomePath = new File(gradleHome);
                return GradleUtil.getGradleVersion(gradleHomePath);
            }
        }
        return null;
    }

    @Nullable
    public static GradleVersion getGradleVersion(@NotNull File gradleHomePath) {
        if (gradleHomePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleHomePath", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleVersion"));
        }
        File libDirPath = new File(gradleHomePath, "lib");
        for (File child : FileUtil.notNullize((File[])libDirPath.listFiles())) {
            GradleVersion version = GradleUtil.getGradleVersionFromJar(child);
            if (version == null) continue;
            return version;
        }
        return null;
    }

    @VisibleForTesting
    @Nullable
    static GradleVersion getGradleVersionFromJar(@NotNull File libraryJarFile) {
        if (libraryJarFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryJarFile", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleVersionFromJar"));
        }
        String fileName = libraryJarFile.getName();
        Matcher matcher = GRADLE_JAR_NAME_PATTERN.matcher(fileName);
        if (matcher.matches()) {
            String version = matcher.group(2);
            return GradleVersion.tryParse((String)GradleUtil.removeTimestampFromGradleVersion(version));
        }
        return null;
    }

    @NotNull
    private static String removeTimestampFromGradleVersion(@NotNull String gradleVersion) {
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/gradle/util/GradleUtil", "removeTimestampFromGradleVersion"));
        }
        int dashIndex = gradleVersion.indexOf(45);
        if (dashIndex != -1) {
            String string = gradleVersion.substring(0, dashIndex);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "removeTimestampFromGradleVersion"));
            }
            return string;
        }
        String string = gradleVersion;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "removeTimestampFromGradleVersion"));
        }
        return string;
    }

    public static boolean createGradleWrapper(@NotNull File projectDirPath) throws IOException {
        if (projectDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDirPath", "com/android/tools/idea/gradle/util/GradleUtil", "createGradleWrapper"));
        }
        return GradleUtil.createGradleWrapper(projectDirPath, "2.10");
    }

    @VisibleForTesting
    public static boolean createGradleWrapper(@NotNull File projectDirPath, @NotNull String gradleVersion) throws IOException {
        if (projectDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDirPath", "com/android/tools/idea/gradle/util/GradleUtil", "createGradleWrapper"));
        }
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/gradle/util/GradleUtil", "createGradleWrapper"));
        }
        File projectWrapperDirPath = new File(projectDirPath, SdkConstants.FD_GRADLE_WRAPPER);
        if (!projectWrapperDirPath.isDirectory()) {
            File wrapperSrcDirPath = new File(TemplateManager.getTemplateRootFolder(), SdkConstants.FD_GRADLE_WRAPPER);
            if (!wrapperSrcDirPath.exists()) {
                File root;
                Iterator<File> iterator = TemplateManager.getExtraTemplateRootFolders().iterator();
                while (iterator.hasNext() && !(wrapperSrcDirPath = new File(root = iterator.next(), SdkConstants.FD_GRADLE_WRAPPER)).exists()) {
                    wrapperSrcDirPath = null;
                }
            }
            if (wrapperSrcDirPath == null) {
                return false;
            }
            FileUtil.copyDirContent((File)wrapperSrcDirPath, (File)projectDirPath);
        }
        File wrapperPropertiesFile = GradleUtil.getGradleWrapperPropertiesFilePath(projectDirPath);
        GradleUtil.updateGradleDistributionUrl(gradleVersion, wrapperPropertiesFile);
        return true;
    }

    @Nullable
    public static GradleVersion getAndroidGradleModelVersionInUse(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "getAndroidGradleModelVersionInUse"));
        }
        HashSet foundInLibraries = Sets.newHashSet();
        HashSet foundInApps = Sets.newHashSet();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidProject androidProject = GradleUtil.getAndroidProject(module);
            if (androidProject == null) continue;
            String modelVersion = androidProject.getModelVersion();
            if (androidProject.isLibrary()) {
                foundInLibraries.add(modelVersion);
                continue;
            }
            foundInApps.add(modelVersion);
        }
        String found = null;
        if (foundInApps.size() == 1) {
            found = (String)Iterables.getOnlyElement((Iterable)foundInApps);
        } else if (foundInApps.isEmpty() && foundInLibraries.size() == 1) {
            found = (String)Iterables.getOnlyElement((Iterable)foundInLibraries);
        }
        return found != null ? GradleVersion.tryParse((String)found) : null;
    }

    @Nullable
    public static GradleVersion getAndroidGradleModelVersionFromBuildFile(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "getAndroidGradleModelVersionFromBuildFile"));
        }
        final Ref modelVersionRef = new Ref();
        GradleUtil.processBuildModelsRecursively(project, new Processor<GradleBuildModel>(){

            public boolean process(GradleBuildModel buildModel) {
                DependenciesModel dependencies = buildModel.buildscript().dependencies();
                for (ArtifactDependencyModel dependency : dependencies.artifacts("classpath")) {
                    GradleVersion version;
                    ArtifactDependencySpec spec = dependency.getSpec();
                    if (!GradleUtil.isAndroidPlugin(spec)) continue;
                    String versionValue = spec.version;
                    if (versionValue == null || (version = GradleVersion.tryParse((String)versionValue)) == null) break;
                    modelVersionRef.set((Object)version);
                    return false;
                }
                return true;
            }
        });
        GradleVersion gradleVersion = (GradleVersion)modelVersionRef.get();
        if (gradleVersion != null) {
            GradleCoordinate foundInCache;
            GradleVersion.VersionSegment majorSegment = gradleVersion.getMajorSegment();
            GradleVersion.VersionSegment minorSegment = gradleVersion.getMinorSegment();
            if ((majorSegment.acceptsGreaterValue() || minorSegment != null && minorSegment.acceptsGreaterValue()) && (foundInCache = GradleUtil.findLatestVersionInGradleCache(ANDROID_PLUGIN_GROUP_ID, ANDROID_PLUGIN_GROUP_ID, null, project)) != null) {
                String revision = foundInCache.getRevision();
                return GradleVersion.tryParse((String)revision);
            }
            GradleVersion.VersionSegment microSegment = gradleVersion.getMicroSegment();
            if (microSegment != null && microSegment.acceptsGreaterValue()) {
                int major = gradleVersion.getMajor();
                int minor = gradleVersion.getMinor();
                return new GradleVersion(major, minor, 0);
            }
        }
        return gradleVersion;
    }

    @Nullable
    public static GradleCoordinate findLatestVersionInGradleCache(@NotNull GradleCoordinate original, @Nullable String filter, @Nullable Project project) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/android/tools/idea/gradle/util/GradleUtil", "findLatestVersionInGradleCache"));
        }
        String groupId = original.getGroupId();
        String artifactId = original.getArtifactId();
        if (StringUtil.isNotEmpty((String)groupId) && StringUtil.isNotEmpty((String)artifactId)) {
            return GradleUtil.findLatestVersionInGradleCache(groupId, artifactId, filter, project);
        }
        return null;
    }

    @Nullable
    public static GradleCoordinate findLatestVersionInGradleCache(@NotNull String groupId, @NotNull String artifactId, @Nullable String filter, @Nullable Project project) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/android/tools/idea/gradle/util/GradleUtil", "findLatestVersionInGradleCache"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "com/android/tools/idea/gradle/util/GradleUtil", "findLatestVersionInGradleCache"));
        }
        for (File gradleServicePath : GradleUtil.getGradleServicePaths(project)) {
            GradleCoordinate version = GradleUtil.findLatestVersionInGradleCache(gradleServicePath, groupId, artifactId, filter);
            if (version == null) continue;
            return version;
        }
        return null;
    }

    @Nullable
    private static GradleCoordinate findLatestVersionInGradleCache(@NotNull File gradleServicePath, @NotNull String groupId, @NotNull String artifactId, @Nullable String filter) {
        if (gradleServicePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleServicePath", "com/android/tools/idea/gradle/util/GradleUtil", "findLatestVersionInGradleCache"));
        }
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/android/tools/idea/gradle/util/GradleUtil", "findLatestVersionInGradleCache"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "com/android/tools/idea/gradle/util/GradleUtil", "findLatestVersionInGradleCache"));
        }
        File gradleCache = new File(gradleServicePath, "caches");
        if (gradleCache.exists()) {
            ArrayList coordinates = Lists.newArrayList();
            for (File moduleDir : FileUtil.notNullize((File[])gradleCache.listFiles())) {
                if (!moduleDir.getName().startsWith("modules-") || !moduleDir.isDirectory()) continue;
                for (File metadataDir : FileUtil.notNullize((File[])moduleDir.listFiles())) {
                    File versionDir;
                    if (!metadataDir.getName().startsWith("metadata-") || !metadataDir.isDirectory() || !(versionDir = new File(metadataDir, FileUtil.join((String[])new String[]{"descriptors", groupId, artifactId}))).isDirectory()) continue;
                    for (File version : FileUtil.notNullize((File[])versionDir.listFiles())) {
                        GradleCoordinate found;
                        String name = version.getName();
                        if (filter != null && !name.startsWith(filter) || name.isEmpty() || !Character.isDigit(name.charAt(0)) || (found = GradleCoordinate.parseCoordinateString((String)(groupId + ":" + artifactId + ":" + name))) == null) continue;
                        coordinates.add(found);
                    }
                }
            }
            if (!coordinates.isEmpty()) {
                Collections.sort(coordinates, GradleCoordinate.COMPARE_PLUS_LOWER);
                return (GradleCoordinate)coordinates.get(coordinates.size() - 1);
            }
        }
        return null;
    }

    public static void addLocalMavenRepoInitScriptCommandLineOption(@NotNull List<String> args) {
        File repoPath;
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/android/tools/idea/gradle/util/GradleUtil", "addLocalMavenRepoInitScriptCommandLineOption"));
        }
        if ((AndroidStudioInitializer.isAndroidStudio() || ApplicationManager.getApplication().isUnitTestMode()) && (repoPath = EmbeddedDistributionPaths.findAndroidStudioLocalMavenRepoPath()) != null && repoPath.isDirectory()) {
            GradleUtil.addLocalMavenRepoInitScriptCommandLineOption(args, repoPath);
        }
    }

    @VisibleForTesting
    @Nullable
    static File addLocalMavenRepoInitScriptCommandLineOption(@NotNull List<String> args, @NotNull File repoPath) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/android/tools/idea/gradle/util/GradleUtil", "addLocalMavenRepoInitScriptCommandLineOption"));
        }
        if (repoPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repoPath", "com/android/tools/idea/gradle/util/GradleUtil", "addLocalMavenRepoInitScriptCommandLineOption"));
        }
        try {
            File file = FileUtil.createTempFile((String)"asLocalRepo", (String)".gradle");
            file.deleteOnExit();
            String path = GradleImport.escapeGroovyStringLiteral(repoPath.getPath());
            String contents = "allprojects {\n  buildscript {\n    repositories {\n      maven { url '" + path + "'}\n    }\n  }\n  repositories {\n    maven { url '" + path + "'}\n  }\n}\n";
            FileUtil.writeToFile((File)file, (String)contents);
            ContainerUtil.addAll(args, (Object[])new String[]{"--init-script", file.getAbsolutePath()});
            return file;
        }
        catch (IOException e) {
            LOG.warn("Failed to set up 'local repo' Gradle init script", (Throwable)e);
            return null;
        }
    }

    public static void attemptToUseEmbeddedGradle(@NotNull Project project) {
        File wrapperPropertiesFile;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "attemptToUseEmbeddedGradle"));
        }
        if (AndroidStudioInitializer.isAndroidStudio() && (wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project)) != null) {
            GradleProjectSettings gradleSettings;
            File embeddedGradlePath;
            String gradleVersion = null;
            try {
                Properties properties = PropertiesUtil.getProperties(wrapperPropertiesFile);
                String url = properties.getProperty("distributionUrl");
                gradleVersion = GradleUtil.getGradleWrapperVersionOnlyIfComingForGradleDotOrg(url);
            }
            catch (IOException e) {
                LOG.warn("Failed to read file " + wrapperPropertiesFile.getPath());
            }
            if (gradleVersion != null && GradleUtil.isCompatibleWithEmbeddedGradleVersion(gradleVersion) && !GradleUtil.isWrapperInGradleCache(project, gradleVersion) && (embeddedGradlePath = EmbeddedDistributionPaths.findEmbeddedGradleDistributionPath()) != null && (gradleSettings = GradleUtil.getGradleProjectSettings(project)) != null) {
                gradleSettings.setDistributionType(DistributionType.LOCAL);
                gradleSettings.setGradleHome(embeddedGradlePath.getPath());
            }
        }
    }

    @VisibleForTesting
    @Nullable
    static String getGradleWrapperVersionOnlyIfComingForGradleDotOrg(@Nullable String url) {
        String version;
        String expectedPrefix;
        String protocol;
        int foundIndex;
        if (url != null && (foundIndex = url.indexOf("://")) != -1 && ((protocol = url.substring(0, foundIndex)).equals("http") || protocol.equals("https")) && url.startsWith(expectedPrefix = protocol + "://services.gradle.org/distributions/gradle-") && (foundIndex = url.indexOf(45, expectedPrefix.length())) != -1 && StringUtil.isNotEmpty((String)(version = url.substring(expectedPrefix.length(), foundIndex)))) {
            return version;
        }
        return null;
    }

    private static boolean isCompatibleWithEmbeddedGradleVersion(@NotNull String gradleVersion) {
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/gradle/util/GradleUtil", "isCompatibleWithEmbeddedGradleVersion"));
        }
        return gradleVersion.equals("2.2.1") || gradleVersion.equals("2.10");
    }

    private static boolean isWrapperInGradleCache(@NotNull Project project, @NotNull String gradleVersion) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "isWrapperInGradleCache"));
        }
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/gradle/util/GradleUtil", "isWrapperInGradleCache"));
        }
        String distFolderDirName = "gradle-" + gradleVersion;
        String wrapperDirNamePrefix = distFolderDirName + "-";
        String[] wrapperDirNames = new String[]{wrapperDirNamePrefix + "all", wrapperDirNamePrefix + "bin"};
        for (File gradleServicePath : GradleUtil.getGradleServicePaths(project)) {
            for (String wrapperDirName : wrapperDirNames) {
                File wrapperDirPath = new File(gradleServicePath, FileUtil.join((String[])new String[]{"wrapper", "dists", wrapperDirName}));
                if (!wrapperDirPath.isDirectory()) continue;
                for (File mayBeDistParent : FileUtil.notNullize((File[])wrapperDirPath.listFiles())) {
                    if (!mayBeDistParent.isDirectory()) continue;
                    for (File mayBeDistFolder : FileUtil.notNullize((File[])mayBeDistParent.listFiles())) {
                        if (!mayBeDistFolder.isDirectory() || !distFolderDirName.equals(mayBeDistFolder.getName())) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @NotNull
    private static Collection<File> getGradleServicePaths(@Nullable Project project) {
        File path;
        File file;
        GradleSettings settings;
        String path2;
        LinkedHashSet paths = Sets.newLinkedHashSet();
        if (project != null && StringUtil.isNotEmpty((String)(path2 = (settings = GradleSettings.getInstance((Project)project)).getServiceDirectoryPath())) && (file = new File(path2)).isDirectory()) {
            paths.add(file);
        }
        if ((path = new File(SystemProperties.getUserHome(), ".gradle")).isDirectory()) {
            paths.add(path);
        }
        LinkedHashSet linkedHashSet = paths;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleServicePaths"));
        }
        return linkedHashSet;
    }

    public static boolean dependsOn(AndroidGradleModel androidModel, String artifact) {
        Dependencies dependencies = androidModel.getMainArtifact().getDependencies();
        return GradleUtil.dependsOn(dependencies, artifact);
    }

    private static boolean dependsOn(Dependencies dependencies, String artifact) {
        for (AndroidLibrary library : dependencies.getLibraries()) {
            if (!GradleUtil.dependsOn(library, artifact, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean dependsOn(AndroidLibrary library, String artifact, boolean transitively) {
        String s;
        MavenCoordinates resolvedCoordinates = library.getResolvedCoordinates();
        if (resolvedCoordinates != null && artifact.equals(s = resolvedCoordinates.getGroupId() + ':' + resolvedCoordinates.getArtifactId())) {
            return true;
        }
        if (transitively) {
            for (AndroidLibrary dependency : library.getLibraryDependencies()) {
                if (!GradleUtil.dependsOn(dependency, artifact, true)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasCause(@NotNull Throwable e, @NotNull Class<?> causeClass) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/util/GradleUtil", "hasCause"));
        }
        if (causeClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "causeClass", "com/android/tools/idea/gradle/util/GradleUtil", "hasCause"));
        }
        String causeClassName = causeClass.getName();
        for (Throwable ex = e; ex != null; ex = ex.getCause()) {
            if (!causeClassName.equals(ex.getClass().getName())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static File getGradleUserSettingsFile() {
        String homePath = SystemProperties.getUserHome();
        if (homePath == null) {
            return null;
        }
        return new File(homePath, FileUtil.join((String[])new String[]{".gradle", "gradle.properties"}));
    }

    @Nullable
    public static DataNode<ProjectData> getCachedProjectData(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "getCachedProjectData"));
        }
        ProjectDataManager dataManager = ProjectDataManager.getInstance();
        ExternalProjectInfo projectInfo = dataManager.getExternalProjectData(project, GRADLE_SYSTEM_ID, Projects.getBaseDirPath(project).getPath());
        return projectInfo != null ? projectInfo.getExternalProjectStructure() : null;
    }

    public static boolean hasLayoutRenderingIssue(@NotNull AndroidProject model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/util/GradleUtil", "hasLayoutRenderingIssue"));
        }
        String modelVersion = model.getModelVersion();
        return modelVersion.startsWith("1.2.0") || modelVersion.equals("1.2.1") || modelVersion.equals("1.2.2");
    }

    @Nullable
    public static VirtualFile findSourceJarForLibrary(@NotNull File libraryFilePath) {
        if (libraryFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryFilePath", "com/android/tools/idea/gradle/util/GradleUtil", "findSourceJarForLibrary"));
        }
        VirtualFile realJarFile = VfsUtil.findFileByIoFile((File)libraryFilePath, (boolean)true);
        if (realJarFile == null) {
            return null;
        }
        VirtualFile parent = realJarFile.getParent();
        String name = FileUtil.getNameWithoutExtension((File)libraryFilePath);
        String sourceFileName = name + SOURCES_JAR_NAME_SUFFIX;
        if (parent != null) {
            VirtualFile sourceJar = parent.findChild(sourceFileName);
            if (sourceJar != null) {
                return sourceJar;
            }
            if ((parent = parent.getParent()) != null) {
                for (VirtualFile child : parent.getChildren()) {
                    if (!child.isDirectory() || (sourceJar = child.findChild(sourceFileName)) == null) continue;
                    return sourceJar;
                }
            }
        }
        File librarySourceDirPath = InternetAttachSourceProvider.getLibrarySourceDir();
        File sourceJar = new File(librarySourceDirPath, sourceFileName);
        return VfsUtil.findFileByIoFile((File)sourceJar, (boolean)true);
    }

    public static boolean updateGradlePluginVersionAndNotifyFailure(@NotNull Project project, @NotNull String pluginVersion, @Nullable String gradleVersion, boolean invalidateSyncOnFailure) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "updateGradlePluginVersionAndNotifyFailure"));
        }
        if (pluginVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginVersion", "com/android/tools/idea/gradle/util/GradleUtil", "updateGradlePluginVersionAndNotifyFailure"));
        }
        if (GradleUtil.updateGradlePluginVersion(project, pluginVersion, gradleVersion)) {
            GradleProjectImporter.getInstance().requestProjectSync(project, false, true, true, null);
            return true;
        }
        if (invalidateSyncOnFailure) {
            GradleUtil.invalidateLastSync(project, String.format("Failed to update Android plugin to version '%1$s'", pluginVersion));
        }
        String msg = "Failed to update the version of the Android Gradle plugin.\n\nPlease click 'OK' to perform a textual search and then update the build files manually.";
        Messages.showErrorDialog((Project)project, (String)msg, (String)"Gradle Sync Issue");
        SearchInBuildFilesHyperlink.searchInBuildFiles("com.android.tools.build:gradle:", project);
        return false;
    }

    public static void invalidateLastSync(@NotNull Project project, @NotNull String error) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "invalidateLastSync"));
        }
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/util/GradleUtil", "invalidateLastSync"));
        }
        GradleSyncState.getInstance(project).syncFailed(error);
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) continue;
            facet.setAndroidModel(null);
        }
    }

    public static boolean updateGradlePluginVersion(@NotNull Project project, @NotNull String pluginVersion, @Nullable String gradleVersion) {
        File wrapperPropertiesFilePath;
        GradleVersion current;
        String basePath;
        boolean updateModels;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "updateGradlePluginVersion"));
        }
        if (pluginVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginVersion", "com/android/tools/idea/gradle/util/GradleUtil", "updateGradlePluginVersion"));
        }
        final ArrayList modelsToUpdate = Lists.newArrayList();
        final GradleVersion parsedPluginVersion = GradleVersion.parse((String)pluginVersion);
        final Ref alreadyInCorrectVersion = new Ref((Object)false);
        GradleUtil.processBuildModelsRecursively(project, new Processor<GradleBuildModel>(){

            public boolean process(GradleBuildModel buildModel) {
                DependenciesModel dependencies = buildModel.buildscript().dependencies();
                for (ArtifactDependencyModel dependency : dependencies.artifacts("classpath")) {
                    ArtifactDependencySpec spec = dependency.getSpec();
                    if (!GradleUtil.isAndroidPlugin(spec)) continue;
                    if (spec.version != null && parsedPluginVersion.compareTo(spec.version) == 0) {
                        alreadyInCorrectVersion.set((Object)true);
                        break;
                    }
                    dependency.setVersion(parsedPluginVersion.toString());
                    modelsToUpdate.add(buildModel);
                    break;
                }
                return true;
            }
        });
        boolean bl = updateModels = !modelsToUpdate.isEmpty();
        if (updateModels) {
            WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

                @Override
                public void run() {
                    for (GradleBuildModel buildModel : modelsToUpdate) {
                        buildModel.applyChanges();
                    }
                }
            });
        } else if (((Boolean)alreadyInCorrectVersion.get()).booleanValue()) {
            return true;
        }
        if (updateModels && StringUtil.isNotEmpty((String)gradleVersion) && (basePath = project.getBasePath()) != null && (current = GradleUtil.getGradleVersionInWrapper(wrapperPropertiesFilePath = GradleUtil.getGradleWrapperPropertiesFilePath(new File(basePath)))) != null && !GradleUtil.isSupportedGradleVersion(current)) {
            try {
                GradleUtil.updateGradleDistributionUrl(gradleVersion, wrapperPropertiesFilePath);
            }
            catch (IOException e) {
                LOG.warn("Failed to update Gradle version in wrapper", (Throwable)e);
            }
        }
        return updateModels;
    }

    private static boolean isAndroidPlugin(@NotNull ArtifactDependencySpec spec) {
        if (spec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "spec", "com/android/tools/idea/gradle/util/GradleUtil", "isAndroidPlugin"));
        }
        return ANDROID_PLUGIN_GROUP_ID.equals(spec.group) && ANDROID_PLUGIN_ARTIFACT_ID.equals(spec.name);
    }

    public static void processBuildModelsRecursively(final @NotNull Project project, final @NotNull Processor<GradleBuildModel> processor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "processBuildModelsRecursively"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/android/tools/idea/gradle/util/GradleUtil", "processBuildModelsRecursively"));
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                VirtualFile baseDir = project.getBaseDir();
                if (baseDir == null) {
                    return;
                }
                VfsUtil.processFileRecursivelyWithoutIgnored((VirtualFile)baseDir, (Processor)new Processor<VirtualFile>(){

                    public boolean process(VirtualFile virtualFile) {
                        if ("build.gradle".equals(virtualFile.getName())) {
                            GradleBuildModel buildModel = GradleBuildModel.parseBuildFile(virtualFile, project);
                            return processor.process((Object)buildModel);
                        }
                        return true;
                    }
                });
            }
        });
    }

    @Nullable
    private static GradleVersion getGradleVersionInWrapper(@NotNull File wrapperPropertiesFilePath) {
        if (wrapperPropertiesFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapperPropertiesFilePath", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleVersionInWrapper"));
        }
        String version = null;
        try {
            version = GradleUtil.getGradleWrapperVersion(wrapperPropertiesFilePath);
        }
        catch (IOException e) {
            LOG.warn("Failed to obtain Gradle version in wrapper", (Throwable)e);
        }
        if (StringUtil.isNotEmpty((String)version)) {
            return GradleVersion.tryParse((String)version);
        }
        return null;
    }

    public static void setBuildToolsVersion(@NotNull Project project, @NotNull String version) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "setBuildToolsVersion"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/gradle/util/GradleUtil", "setBuildToolsVersion"));
        }
        final ArrayList modelsToUpdate = Lists.newArrayList();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidModel android;
            GradleBuildModel buildModel;
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null || (buildModel = GradleBuildModel.get(module)) == null || version.equals((android = buildModel.android()).buildToolsVersion())) continue;
            android.setBuildToolsVersion(version);
            modelsToUpdate.add(buildModel);
        }
        if (!modelsToUpdate.isEmpty()) {
            WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

                @Override
                public void run() {
                    for (GradleBuildModel buildModel : modelsToUpdate) {
                        buildModel.applyChanges();
                    }
                }
            });
        }
    }
}

