/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.Client;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.fd.InstantRunUtils;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.run.testing.AndroidTestRunConfiguration;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.DefaultProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

public class AndroidProgramRunner
extends DefaultProgramRunner {
    public static final String ANDROID_LOGCAT_CONTENT_ID = "Android Logcat";
    public static final Key<Client> ANDROID_DEBUG_CLIENT = new Key("ANDROID_DEBUG_CLIENT");
    public static final Key<AndroidVersion> ANDROID_DEVICE_API_LEVEL = new Key("ANDROID_DEVICE_API_LEVEL");
    private RunContentDescriptor myDescriptor;

    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/run/AndroidProgramRunner", "doExecute"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/run/AndroidProgramRunner", "doExecute"));
        }
        boolean showRunContent = env.getRunProfile() instanceof AndroidTestRunConfiguration;
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = env.getRunnerAndConfigurationSettings();
        if (runnerAndConfigurationSettings != null) {
            runnerAndConfigurationSettings.setActivateToolWindowBeforeRun(showRunContent);
        }
        this.myDescriptor = super.doExecute(state, env);
        if (this.myDescriptor != null) {
            ProcessHandler processHandler = this.myDescriptor.getProcessHandler();
            assert (processHandler != null);
            RunProfile runProfile = env.getRunProfile();
            int uniqueId = runProfile instanceof AndroidRunConfigurationBase ? ((AndroidRunConfigurationBase)runProfile).getUniqueID() : -1;
            AndroidSessionInfo sessionInfo = new AndroidSessionInfo(processHandler, this.myDescriptor, uniqueId, env.getExecutor().getId(), InstantRunUtils.isInstantRunEnabled(env));
            processHandler.putUserData(AndroidSessionInfo.KEY, (Object)sessionInfo);
        }
        return this.myDescriptor;
    }

    public RunContentDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    @NotNull
    public String getRunnerId() {
        if ("AndroidProgramRunner" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidProgramRunner", "getRunnerId"));
        }
        return "AndroidProgramRunner";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/android/tools/idea/run/AndroidProgramRunner", "canRun"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/android/tools/idea/run/AndroidProgramRunner", "canRun"));
        }
        if (!DefaultDebugExecutor.EXECUTOR_ID.equals(executorId) && !DefaultRunExecutor.EXECUTOR_ID.equals(executorId)) {
            return false;
        }
        return profile instanceof AndroidRunConfigurationBase;
    }
}

