/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.dialog;

import com.android.tools.idea.gradle.structure.DefaultSdksConfigurable;
import com.android.tools.idea.structure.dialog.ModuleStructureConfigurableContributor;
import com.android.tools.idea.structure.dialog.ProjectStructureItemGroup;
import com.android.tools.idea.structure.dialog.ProjectStructureItemsContributor;
import com.google.common.collect.Lists;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ui.configuration.ErrorPaneConfigurable;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.SidePanel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.navigation.BackAction;
import com.intellij.ui.navigation.ForwardAction;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureConfigurable
extends BaseConfigurable
implements SearchableConfigurable,
Place.Navigator,
Configurable.NoMargin,
Configurable.NoScroll {
    public static final DataKey<ProjectStructureConfigurable> KEY = DataKey.create((String)"ProjectStructureConfiguration");
    @NonNls
    public static final String CATEGORY = "category";
    @NonNls
    private static final String LAST_EDITED_PROPERTY = "project.structure.last.edited";
    @NonNls
    private static final String PROPORTION_PROPERTY = "project.structure.proportion";
    @NonNls
    private static final String SIDE_PROPORTION_PROPERTY = "project.structure.side.proportion";
    @NotNull
    private final Project myProject;
    @NotNull
    private final DefaultSdksConfigurable mySdksConfigurable;
    @NotNull
    private final Wrapper myDetails;
    @NotNull
    private final List<Configurable> myConfigurables;
    @NotNull
    private final UIState myUiState;
    @NotNull
    private final StructureConfigurableContext myContext;
    @NotNull
    private final ModulesConfigurator myModulesConfigurator;
    private History myHistory;
    private JBSplitter mySplitter;
    private SidePanel mySidePanel;
    private JPanel myNotificationPanel;
    private JComponent myToolbarComponent;
    private ErrorPaneConfigurable myErrorsComponent;
    private JComponent myToFocus;
    private boolean myUiInitialized;
    private Configurable mySelectedConfigurable;
    private final JLabel myEmptySelection;

    @NotNull
    public static ProjectStructureConfigurable getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/structure/dialog/ProjectStructureConfigurable", "getInstance"));
        }
        ProjectStructureConfigurable projectStructureConfigurable = (ProjectStructureConfigurable)((Object)ServiceManager.getService((Project)project, ProjectStructureConfigurable.class));
        if (projectStructureConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/dialog/ProjectStructureConfigurable", "getInstance"));
        }
        return projectStructureConfigurable;
    }

    public ProjectStructureConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/structure/dialog/ProjectStructureConfigurable", "<init>"));
        }
        this.myDetails = new Wrapper();
        this.myConfigurables = Lists.newArrayList();
        this.myUiState = new UIState();
        this.myHistory = new History((Place.Navigator)this);
        this.myEmptySelection = new JLabel("<html><body><center>Select a setting to view or edit its details here</center></body></html>", 0);
        this.myProject = project;
        this.mySdksConfigurable = new DefaultSdksConfigurable(this, project);
        this.mySdksConfigurable.setHistory(this.myHistory);
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        this.myUiState.lastEditedConfigurable = propertiesComponent.getValue(LAST_EDITED_PROPERTY);
        String proportion = propertiesComponent.getValue(PROPORTION_PROPERTY);
        this.myUiState.proportion = ProjectStructureConfigurable.parseFloatValue(proportion);
        String sideProportion = propertiesComponent.getValue(SIDE_PROPORTION_PROPERTY);
        this.myUiState.sideProportion = ProjectStructureConfigurable.parseFloatValue(sideProportion);
        this.myModulesConfigurator = new ModulesConfigurator(this.myProject);
        this.myContext = new StructureConfigurableContext(this.myProject, this.myModulesConfigurator);
        this.myModulesConfigurator.setContext(this.myContext);
    }

    private static float parseFloatValue(@Nullable String value) {
        if (value != null) {
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myToFocus;
    }

    public boolean showDialog() {
        return this.showDialog(null);
    }

    private boolean showDialog(@Nullable Runnable advanceInit) {
        return ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)this, advanceInit);
    }

    public void setHistory(History history) {
        this.myHistory = history;
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        BaseConfigurable configurable;
        if (place == null) {
            return null;
        }
        Configurable toSelect = (Configurable)place.getPath(CATEGORY);
        JComponent detailsContent = this.myDetails.getTargetComponent();
        if (this.mySelectedConfigurable != toSelect) {
            this.saveSideProportion();
            this.removeSelected();
        }
        if (toSelect != null) {
            detailsContent = toSelect.createComponent();
            this.myDetails.setContent(detailsContent);
        }
        this.mySelectedConfigurable = toSelect;
        if (this.mySelectedConfigurable != null) {
            this.myUiState.lastEditedConfigurable = this.mySelectedConfigurable.getDisplayName();
        }
        if (toSelect instanceof MasterDetailsComponent) {
            MasterDetailsComponent masterDetails = (MasterDetailsComponent)toSelect;
            if (this.myUiState.sideProportion > 0.0f) {
                masterDetails.getSplitter().setProportion(this.myUiState.sideProportion);
            }
            masterDetails.setHistory(this.myHistory);
        } else if (toSelect == this.mySdksConfigurable) {
            this.mySdksConfigurable.setHistory(this.myHistory);
        }
        if (toSelect != null) {
            this.mySidePanel.select(ProjectStructureConfigurable.createPlaceFor(toSelect));
        }
        JComponent toFocus = null;
        if (this.mySelectedConfigurable instanceof BaseConfigurable) {
            configurable = (BaseConfigurable)this.mySelectedConfigurable;
            toFocus = configurable.getPreferredFocusedComponent();
        } else if (this.mySelectedConfigurable instanceof MasterDetailsComponent) {
            configurable = (MasterDetailsComponent)this.mySelectedConfigurable;
            toFocus = configurable.getMaster();
        }
        if (toFocus == null && detailsContent != null && (toFocus = IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)detailsContent)) == null) {
            toFocus = detailsContent;
        }
        this.myToFocus = toFocus;
        if (this.myToFocus != null) {
            UIUtil.requestFocus((JComponent)this.myToFocus);
        }
        ActionCallback result = new ActionCallback();
        Place.goFurther((Object)toSelect, (Place)place, (boolean)requestFocus).notifyWhenDone(result);
        this.myDetails.revalidate();
        this.myDetails.repaint();
        if (!this.myHistory.isNavigatingNow() && this.mySelectedConfigurable != null) {
            this.myHistory.pushQueryPlace();
        }
        return result;
    }

    private void saveSideProportion() {
        if (this.mySelectedConfigurable instanceof MasterDetailsComponent) {
            this.myUiState.sideProportion = ((MasterDetailsComponent)this.mySelectedConfigurable).getSplitter().getProportion();
        }
    }

    private void removeSelected() {
        this.myDetails.removeAll();
        this.mySelectedConfigurable = null;
        this.myUiState.lastEditedConfigurable = null;
        this.myDetails.add((Component)this.myEmptySelection, (Object)"Center");
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/android/tools/idea/structure/dialog/ProjectStructureConfigurable", "queryPlace"));
        }
        place.putPath(CATEGORY, (Object)this.mySelectedConfigurable);
        Place.queryFurther((Object)this.mySelectedConfigurable, (Place)place);
    }

    @NotNull
    public String getId() {
        if ("android.project.structure" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/dialog/ProjectStructureConfigurable", "getId"));
        }
        return "android.project.structure";
    }

    @Nls
    public String getDisplayName() {
        return ProjectBundle.message((String)"project.settings.display.name", (Object[])new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        MyPanel component = new MyPanel();
        this.mySplitter = new OnePixelSplitter(false, 0.15f);
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.initSidePanel();
        JPanel left = new JPanel(new BorderLayout()){

            @Override
            public Dimension getMinimumSize() {
                Dimension original = super.getMinimumSize();
                return new Dimension(Math.max(original.width, 100), original.height);
            }
        };
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add((AnAction)new BackAction((JComponent)component));
        toolbarGroup.add((AnAction)new ForwardAction((JComponent)component));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)toolbarGroup, true);
        toolbar.setTargetComponent((JComponent)component);
        this.myToolbarComponent = toolbar.getComponent();
        left.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        this.myToolbarComponent.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        left.add((Component)this.myToolbarComponent, "North");
        left.add((Component)this.mySidePanel, "Center");
        this.mySplitter.setFirstComponent((JComponent)left);
        this.mySplitter.setSecondComponent((JComponent)this.myDetails);
        component.add((Component)this.mySplitter, "Center");
        this.myErrorsComponent = new ErrorPaneConfigurable(this.myProject, this.myContext, null);
        component.add((Component)this.myErrorsComponent.createComponent(), "South");
        this.myUiInitialized = true;
        return component;
    }

    private void initSidePanel() {
        boolean isDefaultProject = this.myProject == ProjectManager.getInstance().getDefaultProject();
        this.mySidePanel = new SidePanel((Place.Navigator)this, this.myHistory);
        this.addConfigurable((Configurable)this.mySdksConfigurable);
        if (!isDefaultProject) {
            this.addConfigurables();
        }
    }

    private void addConfigurables() {
        for (ModuleStructureConfigurableContributor moduleStructureConfigurableContributor : (ModuleStructureConfigurableContributor[])ModuleStructureConfigurableContributor.EP_NAME.getExtensions()) {
            Configurable configurable = moduleStructureConfigurableContributor.getModuleStructureConfigurable(this.myProject);
            if (configurable == null) continue;
            this.addConfigurable(configurable);
            break;
        }
        for (ProjectStructureItemsContributor projectStructureItemsContributor : (ProjectStructureItemsContributor[])ProjectStructureItemsContributor.EP_NAME.getExtensions()) {
            List<ProjectStructureItemGroup> itemGroups = projectStructureItemsContributor.getItemGroups(this.myProject);
            for (ProjectStructureItemGroup group : itemGroups) {
                String name = group.getGroupName();
                this.mySidePanel.addSeparator(name);
                for (Configurable configurable : group.getItems()) {
                    this.addConfigurable(configurable);
                }
            }
        }
    }

    private void addConfigurable(@NotNull Configurable configurable) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/android/tools/idea/structure/dialog/ProjectStructureConfigurable", "addConfigurable"));
        }
        if (configurable instanceof BaseStructureConfigurable) {
            ((BaseStructureConfigurable)configurable).init(this.myContext);
        }
        this.myConfigurables.add(configurable);
        this.mySidePanel.addPlace(ProjectStructureConfigurable.createPlaceFor(configurable), new Presentation(configurable.getDisplayName()));
    }

    @NotNull
    private static Place createPlaceFor(@NotNull Configurable configurable) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/android/tools/idea/structure/dialog/ProjectStructureConfigurable", "createPlaceFor"));
        }
        Place place = new Place().putPath(CATEGORY, (Object)configurable);
        if (place == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/dialog/ProjectStructureConfigurable", "createPlaceFor"));
        }
        return place;
    }

    public void apply() throws ConfigurationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        AccessToken token = HeavyProcessLatch.INSTANCE.processStarted("Resetting Project Structure");
        try {
            this.mySdksConfigurable.reset();
            this.myContext.reset();
            Configurable toSelect = null;
            for (Configurable each : this.myConfigurables) {
                if (this.myUiState.lastEditedConfigurable != null && this.myUiState.lastEditedConfigurable.equals(each.getDisplayName())) {
                    toSelect = each;
                }
                if (each instanceof MasterDetailsComponent) {
                    ((MasterDetailsComponent)each).setHistory(this.myHistory);
                }
                each.reset();
            }
            this.myHistory.clear();
            if (toSelect == null && !this.myConfigurables.isEmpty()) {
                toSelect = this.myConfigurables.get(0);
            }
            this.removeSelected();
            this.navigateTo(toSelect != null ? ProjectStructureConfigurable.createPlaceFor(toSelect) : null, false);
            if (this.myUiState.proportion > 0.0f) {
                this.mySplitter.setProportion(this.myUiState.proportion);
            }
        }
        finally {
            token.finish();
        }
    }

    public void disposeUIResources() {
        if (!this.myUiInitialized) {
            return;
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        propertiesComponent.setValue(LAST_EDITED_PROPERTY, this.myUiState.lastEditedConfigurable);
        propertiesComponent.setValue(PROPORTION_PROPERTY, String.valueOf(this.myUiState.proportion));
        propertiesComponent.setValue(SIDE_PROPORTION_PROPERTY, String.valueOf(this.myUiState.sideProportion));
        this.myUiState.proportion = this.mySplitter.getProportion();
        this.saveSideProportion();
        this.myContext.getDaemonAnalyzer().stop();
        for (Configurable each : this.myConfigurables) {
            each.disposeUIResources();
        }
        this.myConfigurables.clear();
        this.myContext.clear();
        this.myModulesConfigurator.getFacetsConfigurator().clearMaps();
        Disposer.dispose((Disposable)this.myErrorsComponent);
        this.myUiInitialized = false;
    }

    @Nullable
    public History getHistory() {
        return this.myHistory;
    }

    public static class UIState {
        public float proportion;
        public float sideProportion;
        @Nullable
        public String lastEditedConfigurable;
    }

    private class MyPanel
    extends JPanel
    implements DataProvider {
        MyPanel() {
            super(new BorderLayout());
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (KEY.is(dataId)) {
                return ProjectStructureConfigurable.this;
            }
            if (History.KEY.is(dataId)) {
                return ProjectStructureConfigurable.this.getHistory();
            }
            return null;
        }
    }
}

