/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.sdklib.repositoryv2.AndroidSdkHandler;
import com.android.tools.idea.welcome.install.ComponentTreeNode;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.wizard.ProgressStep;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ComponentCategory
extends ComponentTreeNode {
    @NotNull
    private final String myName;
    @NotNull
    private final Collection<ComponentTreeNode> myComponents;

    public ComponentCategory(@NotNull String name, @NotNull String description, ComponentTreeNode ... components) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/welcome/install/ComponentCategory", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/android/tools/idea/welcome/install/ComponentCategory", "<init>"));
        }
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/welcome/install/ComponentCategory", "<init>"));
        }
        this(name, description, Arrays.asList(components));
    }

    @Override
    public void init(@NotNull ProgressStep progressStep) {
        if (progressStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressStep", "com/android/tools/idea/welcome/install/ComponentCategory", "init"));
        }
        for (ComponentTreeNode component : this.myComponents) {
            component.init(progressStep);
        }
    }

    public ComponentCategory(@NotNull String name, @NotNull String description, @NotNull Collection<ComponentTreeNode> components) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/welcome/install/ComponentCategory", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/android/tools/idea/welcome/install/ComponentCategory", "<init>"));
        }
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/welcome/install/ComponentCategory", "<init>"));
        }
        super(description);
        this.myName = name;
        this.myComponents = components;
    }

    @Override
    public String getLabel() {
        return this.myName;
    }

    @Override
    public Collection<InstallableComponent> getChildrenToInstall() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ComponentTreeNode component : this.myComponents) {
            builder.addAll(component.getChildrenToInstall());
        }
        return builder.build();
    }

    @Override
    public void updateState(@NotNull AndroidSdkHandler sdkHandler) {
        if (sdkHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHandler", "com/android/tools/idea/welcome/install/ComponentCategory", "updateState"));
        }
        for (ComponentTreeNode component : this.myComponents) {
            component.updateState(sdkHandler);
        }
    }

    @Override
    @NotNull
    public Collection<DynamicWizardStep> createSteps() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ComponentTreeNode component : this.myComponents) {
            builder.addAll(component.createSteps());
        }
        ImmutableList immutableList = builder.build();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/ComponentCategory", "createSteps"));
        }
        return immutableList;
    }

    @Override
    public boolean isChecked() {
        for (ComponentTreeNode component : this.myComponents) {
            if (component.isChecked()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean componentStateChanged(@NotNull Set<ScopedStateStore.Key> modified) {
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "com/android/tools/idea/welcome/install/ComponentCategory", "componentStateChanged"));
        }
        for (ComponentTreeNode component : this.myComponents) {
            if (!component.componentStateChanged(modified)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<ComponentTreeNode> getImmediateChildren() {
        return this.myComponents;
    }

    @Override
    public boolean isOptional() {
        for (ComponentTreeNode component : this.myComponents) {
            if (!component.isOptional()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void toggle(boolean isSelected) {
        for (ComponentTreeNode component : this.myComponents) {
            component.toggle(isSelected);
        }
    }
}

