/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import java.util.Map;
import org.jetbrains.android.refactoring.AndroidAttributeInfo;
import org.jetbrains.android.refactoring.AndroidInlineAllStyleUsagesProcessor;
import org.jetbrains.android.refactoring.StyleRefData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AndroidInlineStyleDialog
extends InlineOptionsDialog {
    private final String myStyleName;
    private final boolean myInlineThisByDefault;
    private final Map<AndroidAttributeInfo, String> myAttributeValues;
    private final StyleRefData myParentStyleRef;
    private final XmlTag myStyleTag;

    public AndroidInlineStyleDialog(@NotNull Project project, @NotNull PsiElement styleElement, @NotNull XmlTag styleTag, @NotNull String styleName, @NotNull Map<AndroidAttributeInfo, String> attributeValues, @Nullable StyleRefData parentStyleRef, boolean inlineThisByDefault, boolean invokedOnReference) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/refactoring/AndroidInlineStyleDialog", "<init>"));
        }
        if (styleElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleElement", "org/jetbrains/android/refactoring/AndroidInlineStyleDialog", "<init>"));
        }
        if (styleTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleTag", "org/jetbrains/android/refactoring/AndroidInlineStyleDialog", "<init>"));
        }
        if (styleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleName", "org/jetbrains/android/refactoring/AndroidInlineStyleDialog", "<init>"));
        }
        if (attributeValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeValues", "org/jetbrains/android/refactoring/AndroidInlineStyleDialog", "<init>"));
        }
        super(project, true, styleElement);
        this.myStyleTag = styleTag;
        this.myStyleName = styleName;
        this.myInlineThisByDefault = inlineThisByDefault;
        this.myAttributeValues = attributeValues;
        this.myParentStyleRef = parentStyleRef;
        this.myInvokedOnReference = invokedOnReference;
        this.setTitle(AndroidBundle.message("android.inline.style.title", styleName));
        this.init();
    }

    protected String getNameLabelText() {
        return "Style '" + this.myStyleName + "'";
    }

    protected String getBorderTitle() {
        return "Inline";
    }

    protected String getInlineAllText() {
        return AndroidBundle.message("android.inline.style.inline.all.text", new Object[0]);
    }

    protected String getInlineThisText() {
        return AndroidBundle.message("android.inline.style.inline.this.text", new Object[0]);
    }

    protected boolean isInlineThis() {
        return this.myInlineThisByDefault;
    }

    protected void doAction() {
        if (this.isInlineThisOnly()) {
            this.close(0);
        } else {
            this.invokeRefactoring(new AndroidInlineAllStyleUsagesProcessor(this.myProject, this.myElement, this.myStyleTag, this.myStyleName, this.myAttributeValues, this.myParentStyleRef, null));
        }
    }
}

