/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.code;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.gutter.SpringClassAnnotator;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringImplicitUsageProvider
implements ImplicitUsageProvider {
    @NonNls
    private static final List<String> WRITE_ANNOTATIONS = ContainerUtil.immutableList((Object[])new String[]{"org.springframework.beans.factory.annotation.Autowired", "org.springframework.context.annotation.Bean", "org.springframework.beans.factory.annotation.Required", "javax.inject.Inject", "javax.annotation.Resource", "org.springframework.beans.factory.annotation.Value", "org.springframework.jmx.export.annotation.ManagedOperation", "org.springframework.jmx.export.annotation.ManagedAttribute", "org.springframework.scheduling.annotation.Scheduled", "org.springframework.context.event.EventListener", "org.springframework.test.context.transaction.BeforeTransaction", "org.springframework.test.context.transaction.AfterTransaction"});
    private static final List<String> READ_ANNOTATIONS = ContainerUtil.immutableList((Object[])new String[]{"org.springframework.beans.factory.annotation.Value"});

    public boolean isImplicitUsage(PsiElement element) {
        return this.isImplicitWrite(element) || SpringImplicitUsageProvider.isBeanClassOrConstructor(element);
    }

    public boolean isImplicitRead(PsiElement element) {
        return element instanceof PsiModifierListOwner && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), READ_ANNOTATIONS);
    }

    private static boolean isMetaAnnotated(@NotNull PsiModifierListOwner element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/code/SpringImplicitUsageProvider", "isMetaAnnotated"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        return module != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)element, SpringImplicitUsageProvider.getMetaAnnotations(module, "org.springframework.beans.factory.annotation.Autowired", "org.springframework.context.annotation.Bean"));
    }

    @NotNull
    private static List<String> getMetaAnnotations(@NotNull Module module, String ... annotations) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/code/SpringImplicitUsageProvider", "getMetaAnnotations"));
        }
        List strings = ContainerUtil.newSmartList();
        for (String annotation : annotations) {
            strings.addAll(JamCommonUtil.getAnnotationTypesWithChildren((Module)module, (String)annotation, (boolean)false));
        }
        List list = ContainerUtil.mapNotNull((Collection)strings, (Function)((NullableFunction)PsiClass::getQualifiedName));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/code/SpringImplicitUsageProvider", "getMetaAnnotations"));
        }
        return list;
    }

    public boolean isImplicitWrite(PsiElement element) {
        return SpringImplicitUsageProvider.hasWriteAnnotation(element) || SpringImplicitUsageProvider.isBeanSetter(element);
    }

    private static boolean hasWriteAnnotation(PsiElement element) {
        return element instanceof PsiModifierListOwner && !(element instanceof PsiParameter) && !(element instanceof PsiLocalVariable) && SpringLibraryUtil.hasSpringLibrary((Project)element.getProject()) && (AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), WRITE_ANNOTATIONS) || SpringImplicitUsageProvider.isMetaAnnotated((PsiModifierListOwner)element));
    }

    private static boolean isBeanSetter(PsiElement element) {
        PsiMethod method;
        PsiClass psiClass;
        if (element instanceof PsiMethod && PropertyUtil.isSimplePropertySetter((PsiMethod)((PsiMethod)element)) && SpringCommonUtils.isSpringBeanCandidateClassInSpringProject((PsiClass)(psiClass = (method = (PsiMethod)element).getContainingClass()))) {
            SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)psiClass);
            return info.isMappedProperty(method) || info.isAutowired() && SpringClassAnnotator.checkAutowiredMethod(method, null, info);
        }
        return false;
    }

    private static boolean isBeanClassOrConstructor(PsiElement element) {
        if (element instanceof PsiClass) {
            return SpringImplicitUsageProvider.isMappedBeanClass((PsiClass)element);
        }
        if (element instanceof PsiMethod && ((PsiMethod)element).isConstructor()) {
            PsiClass containingClass = ((PsiMethod)element).getContainingClass();
            return SpringImplicitUsageProvider.isMappedBeanClass(containingClass);
        }
        return false;
    }

    private static boolean isMappedBeanClass(PsiClass containingClass) {
        return SpringCommonUtils.isSpringBeanCandidateClassInSpringProject((PsiClass)containingClass) && SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)containingClass).isMapped();
    }
}

