/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model.diagram.gutter;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.contexts.model.diagram.actions.OpenSpringModelDependenciesAction;
import com.intellij.spring.contexts.model.diagram.actions.OpenSpringModelDependenciesModuleDiagramAction;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import icons.SpringCoreIcons;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ModelDependenciesLineMarkerProviderBase
extends LineMarkerProviderDescriptor {
    ModelDependenciesLineMarkerProviderBase() {
    }

    protected abstract boolean isRelevantPsiElement(PsiElement var1);

    @Nullable
    protected abstract LineMarkerInfo doAnnotate(PsiElement var1);

    @Nullable
    public Icon getIcon() {
        return SpringCoreIcons.SpringModelsDependencyGraph;
    }

    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/contexts/model/diagram/gutter/ModelDependenciesLineMarkerProviderBase", "getLineMarkerInfo"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (!this.isRelevantPsiElement(element)) {
            return null;
        }
        if (!SpringLibraryUtil.hasSpringLibrary((Project)element.getProject())) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        if (SpringModelUtils.getInstance().isUsedConfigurationFile(psiFile, false)) {
            return this.doAnnotate(element);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/spring/contexts/model/diagram/gutter/ModelDependenciesLineMarkerProviderBase", "collectSlowLineMarkers"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/contexts/model/diagram/gutter/ModelDependenciesLineMarkerProviderBase", "collectSlowLineMarkers"));
        }
    }

    @NotNull
    protected LineMarkerInfo<PsiElement> createLineMarkerInfo(PsiElement element) {
        LineMarkerInfo lineMarkerInfo = new LineMarkerInfo(element, element.getTextRange(), SpringCoreIcons.SpringModelsDependencyGraph, 11, (Function)new ConstantFunction((Object)SpringBundle.message("local.model.dependencies.diagram.title", new Object[0])), ModelDependenciesLineMarkerProviderBase.createNavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
        if (lineMarkerInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/diagram/gutter/ModelDependenciesLineMarkerProviderBase", "createLineMarkerInfo"));
        }
        return lineMarkerInfo;
    }

    @NotNull
    private static GutterIconNavigationHandler<PsiElement> createNavigationHandler() {
        GutterIconNavigationHandler<PsiElement> gutterIconNavigationHandler = new GutterIconNavigationHandler<PsiElement>(){

            public void navigate(MouseEvent e, PsiElement elt) {
                DefaultActionGroup group = new DefaultActionGroup();
                group.add((AnAction)new OpenSpringModelDependenciesModuleDiagramAction());
                group.add((AnAction)new OpenSpringModelDependenciesAction());
                DataContext context = SimpleDataContext.getProjectContext(null);
                ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
                popup.show(new RelativePoint(e));
            }
        };
        if (gutterIconNavigationHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/diagram/gutter/ModelDependenciesLineMarkerProviderBase", "createNavigationHandler"));
        }
        return gutterIconNavigationHandler;
    }
}

