/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet.nodes;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringConfigurationTabSettings;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.nodes.AbstractFilesetNode;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import icons.SpringApiIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigFileNode
extends AbstractFilesetNode {
    private final VirtualFilePointer myFilePointer;

    ConfigFileNode(@NotNull SpringConfigurationTabSettings settings, @NotNull SpringFileSet fileSet, VirtualFilePointer filePointer, @NotNull SimpleNode parent) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/spring/facet/nodes/ConfigFileNode", "<init>"));
        }
        if (fileSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSet", "com/intellij/spring/facet/nodes/ConfigFileNode", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/spring/facet/nodes/ConfigFileNode", "<init>"));
        }
        super(fileSet, settings, parent);
        this.myFilePointer = filePointer;
    }

    protected void doUpdate() {
        VirtualFile file;
        VirtualFile virtualFile = file = this.myFilePointer.isValid() ? this.myFilePointer.getFile() : null;
        if (file == null) {
            this.renderError(SpringBundle.message("config.file.not.found", new Object[0]));
            return;
        }
        Project project = this.getFileSet().getFacet().getModule().getProject();
        if (DumbService.isDumb((Project)project)) {
            this.renderFile(null);
            return;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile instanceof XmlFile) {
            if (SpringDomUtils.isSpringXml((XmlFile)((XmlFile)psiFile))) {
                this.renderFile(null);
            } else {
                this.renderError(SpringBundle.message("config.file.is.not.spring", new Object[0]));
            }
        } else if (psiFile instanceof PsiClassOwner) {
            PsiClass[] classes;
            for (PsiClass aClass : classes = ((PsiClassOwner)psiFile).getClasses()) {
                if (!SpringCommonUtils.isConfiguration((PsiClass)aClass)) continue;
                this.renderPsiClass(aClass, SimpleTextAttributes.REGULAR_ATTRIBUTES, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                this.setIcon(SpringApiIcons.SpringJavaConfig);
                return;
            }
            if (classes.length == 0) {
                this.renderError(SpringBundle.message("config.file.is.not.spring", new Object[0]));
            } else {
                this.renderPsiClass(classes[0], SimpleTextAttributes.REGULAR_ATTRIBUTES, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        } else {
            this.renderFile(null);
        }
        if (psiFile != null) {
            this.setIcon(psiFile.getIcon(0));
        }
    }

    private void renderError(String msg) {
        this.renderFile(SimpleTextAttributes.ERROR_ATTRIBUTES, SimpleTextAttributes.ERROR_ATTRIBUTES, msg);
    }

    private void renderFile(@Nullable String toolTip) {
        this.renderFile(SimpleTextAttributes.REGULAR_ATTRIBUTES, SimpleTextAttributes.GRAYED_ATTRIBUTES, toolTip);
    }

    private void renderFile(SimpleTextAttributes main, SimpleTextAttributes full, @Nullable String toolTip) {
        this.clearColoredText();
        if (!this.myFilePointer.isValid()) {
            this.addColoredFragment(toolTip, toolTip, main);
            return;
        }
        this.addColoredFragment(this.myFilePointer.getFileName(), toolTip, main);
        VirtualFile file = this.myFilePointer.getFile();
        VirtualFile parent = file != null ? file.getParent() : null;
        String location = parent != null ? parent.getPresentableUrl() : this.myFilePointer.getPresentableUrl();
        this.addColoredFragment(" (" + location + ")", toolTip, full);
    }

    private void renderPsiClass(PsiClass psiClass, SimpleTextAttributes main, SimpleTextAttributes full) {
        this.clearColoredText();
        this.addColoredFragment(psiClass.getName(), main);
        this.addColoredFragment(" (" + StringUtil.getPackageName((String)psiClass.getQualifiedName()) + ")", full);
    }

    public SimpleNode[] getChildren() {
        return NO_CHILDREN;
    }

    public VirtualFilePointer getFilePointer() {
        return this.myFilePointer;
    }

    public boolean isAlwaysLeaf() {
        return true;
    }

    @Override
    @NotNull
    public Object[] getEqualityObjects() {
        SpringFileSet set = this.getFileSet();
        Object[] objectArray = new Object[]{this.myFilePointer, set, set.getName(), set.getFiles(), set.getDependencyFileSets()};
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/nodes/ConfigFileNode", "getEqualityObjects"));
        }
        return objectArray;
    }
}

