/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.factories;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.factories.FactoriesBean;
import com.intellij.spring.factories.FactoryBeanInfo;
import com.intellij.spring.factories.ObjectTypeResolver;
import com.intellij.spring.factories.SpringFactoryBeanEP;
import com.intellij.spring.factories.SpringFactoryBeansManager;
import com.intellij.spring.factories.resolvers.BeanReferenceFactoryBeanTypeResolver;
import com.intellij.spring.factories.resolvers.FactoryPropertiesDependentTypeResolver;
import com.intellij.spring.factories.resolvers.JndiObjectFactoryBeanTypeResolver;
import com.intellij.spring.factories.resolvers.MethodInvokingFactoryBeanTypeResolver;
import com.intellij.spring.factories.resolvers.MyBatisPlaceMapperTypeResolver;
import com.intellij.spring.factories.resolvers.ProxyFactoryBeanTypeResolver;
import com.intellij.spring.factories.resolvers.ScopedProxyFactoryBeanTypeResolver;
import com.intellij.spring.factories.resolvers.SingleObjectTypeResolver;
import com.intellij.spring.factories.resolvers.SpringEjbTypeResolver;
import com.intellij.spring.factories.resolvers.TransactionProxyFactoryBeanTypeResolver;
import com.intellij.spring.factories.resolvers.UtilConstantTypeResolver;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.utils.PsiTypeUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public class SpringFactoryBeansManagerImpl
extends SpringFactoryBeansManager {
    private static final Key<CachedValue<Set<PsiType>>> CACHED_OBJECT_TYPE = Key.create((String)"CACHED_OBJECT_TYPE");
    private final Map<String, ObjectTypeResolver> mySpringFactories = new HashMap();
    private final ObjectTypeResolver[] myCustomResolvers = new ObjectTypeResolver[]{new TransactionProxyFactoryBeanTypeResolver(), new JndiObjectFactoryBeanTypeResolver(), new SpringEjbTypeResolver(), new ProxyFactoryBeanTypeResolver(), new ScopedProxyFactoryBeanTypeResolver(), new BeanReferenceFactoryBeanTypeResolver(), new UtilConstantTypeResolver(), new MethodInvokingFactoryBeanTypeResolver(), new MyBatisPlaceMapperTypeResolver()};
    @NonNls
    private static final String FACTORIES_RESOURCE_XML = "/resources/factories/factories.xml";
    @NonNls
    private static final String PROPERTY_NAME_DELIMITER = ",";

    public SpringFactoryBeansManagerImpl() {
        SpringFactoryBeanEP[] extensions;
        FactoriesBean factoriesBean = (FactoriesBean)XmlSerializer.deserialize((URL)SpringFactoryBeansManagerImpl.class.getResource(FACTORIES_RESOURCE_XML), FactoriesBean.class);
        assert (factoriesBean != null);
        assert (factoriesBean.getFactories() != null);
        for (FactoryBeanInfo factoryBeanInfo : factoriesBean.getFactories()) {
            String factory = factoryBeanInfo.getFactory();
            if (factory == null || factory.trim().length() <= 0) continue;
            this.mySpringFactories.put(factory, this.getObjectTypeResolver(factoryBeanInfo));
        }
        for (SpringFactoryBeanEP extension : extensions = (SpringFactoryBeanEP[])Extensions.getExtensions(SpringFactoryBeanEP.EP_NAME)) {
            this.mySpringFactories.put(extension.factoryClass, new SingleObjectTypeResolver(extension.productType));
        }
    }

    public int getIndexingVersion() {
        int result = 0;
        for (String key : this.mySpringFactories.keySet()) {
            result += key.hashCode();
        }
        return result;
    }

    @Nullable
    private ObjectTypeResolver getObjectTypeResolver(FactoryBeanInfo factoryBeanInfo) {
        String type = factoryBeanInfo.getObjectType();
        if (!StringUtil.isEmptyOrSpaces((String)type)) {
            return new SingleObjectTypeResolver(type);
        }
        String delimitedNames = factoryBeanInfo.getPropertyNames();
        if (!StringUtil.isEmptyOrSpaces((String)delimitedNames)) {
            return new FactoryPropertiesDependentTypeResolver(StringUtil.split((String)delimitedNames, (String)PROPERTY_NAME_DELIMITER));
        }
        String factoryClass = factoryBeanInfo.getFactory();
        for (ObjectTypeResolver customResolver : this.myCustomResolvers) {
            if (!customResolver.accept(factoryClass)) continue;
            return customResolver;
        }
        return null;
    }

    @NotNull
    public PsiType[] getObjectTypes(@NotNull PsiClass factoryClass, @Nullable CommonSpringBean context) {
        if (factoryClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factoryClass", "com/intellij/spring/factories/SpringFactoryBeansManagerImpl", "getObjectTypes"));
        }
        Set<String> names = this.getObjectTypeNames(factoryClass, context);
        if (names.isEmpty()) {
            Set<PsiType> psiTypes = SpringFactoryBeansManagerImpl.guessObjectTypes(factoryClass);
            PsiType[] psiTypeArray = psiTypes.toArray(new PsiType[psiTypes.size()]);
            if (psiTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/SpringFactoryBeansManagerImpl", "getObjectTypes"));
            }
            return psiTypeArray;
        }
        ArrayList types = new ArrayList(names.size());
        for (String typeName : names) {
            ContainerUtil.addIfNotNull(types, (Object)SpringFactoryBeansManagerImpl.createTypeByTypeName(factoryClass, typeName));
        }
        PsiType[] psiTypeArray = types.toArray(new PsiType[types.size()]);
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/SpringFactoryBeansManagerImpl", "getObjectTypes"));
        }
        return psiTypeArray;
    }

    @Nullable
    private static PsiType createTypeByTypeName(@NotNull PsiClass factoryClass, @Nullable String typeName) {
        if (factoryClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factoryClass", "com/intellij/spring/factories/SpringFactoryBeansManagerImpl", "createTypeByTypeName"));
        }
        if (StringUtil.isEmptyOrSpaces((String)typeName)) {
            return null;
        }
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)factoryClass.getProject()).findClass(typeName, factoryClass.getResolveScope());
        if (psiClass != null) {
            return PsiTypesUtil.getClassType((PsiClass)psiClass);
        }
        try {
            return JavaPsiFacade.getElementFactory((Project)factoryClass.getProject()).createTypeFromText(typeName, (PsiElement)factoryClass);
        }
        catch (IncorrectOperationException incorrectOperationException) {
            return null;
        }
    }

    @NotNull
    public PsiClass[] getProductTypes(@NotNull PsiClass factoryClass, @Nullable CommonSpringBean context) {
        if (factoryClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factoryClass", "com/intellij/spring/factories/SpringFactoryBeansManagerImpl", "getProductTypes"));
        }
        PsiClass[] psiClassArray = (PsiClass[])ContainerUtil.mapNotNull((Object[])this.getObjectTypes(factoryClass, context), PsiTypesUtil::getPsiClass, (Object[])PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/SpringFactoryBeansManagerImpl", "getProductTypes"));
        }
        return psiClassArray;
    }

    public Set<PsiClass> getKnownBeanFactories(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/factories/SpringFactoryBeansManagerImpl", "getKnownBeanFactories"));
        }
        return (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/factories/SpringFactoryBeansManagerImpl", "lambda$getKnownBeanFactories$0"));
            }
            HashSet factories = ContainerUtil.newHashSet();
            PsiClass beanFactoryClass = JavaPsiFacade.getInstance((Project)project).findClass("org.springframework.beans.factory.FactoryBean", ProjectScope.getLibrariesScope((Project)project));
            if (beanFactoryClass != null) {
                Collection inheritors = ClassInheritorsSearch.search((PsiClass)beanFactoryClass, (SearchScope)GlobalSearchScope.allScope((Project)project), (boolean)true, (boolean)true, (boolean)false).findAll();
                factories.addAll(inheritors);
            }
            return CachedValueProvider.Result.create((Object)factories, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)project)});
        });
    }

    public boolean isKnownBeanFactory(@Nullable String factoryClass) {
        return this.mySpringFactories.containsKey(factoryClass);
    }

    @NotNull
    private Set<String> getObjectTypeNames(@NotNull PsiClass factoryClass, @Nullable CommonSpringBean context) {
        if (factoryClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factoryClass", "com/intellij/spring/factories/SpringFactoryBeansManagerImpl", "getObjectTypeNames"));
        }
        ObjectTypeResolver objectTypeResolver = this.getObjectTypeResolver(factoryClass);
        Set<String> set = objectTypeResolver != null ? objectTypeResolver.getObjectType(context) : Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/SpringFactoryBeansManagerImpl", "getObjectTypeNames"));
        }
        return set;
    }

    @Nullable
    private ObjectTypeResolver getObjectTypeResolver(@NotNull PsiClass factoryClass) {
        if (factoryClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factoryClass", "com/intellij/spring/factories/SpringFactoryBeansManagerImpl", "getObjectTypeResolver"));
        }
        return (ObjectTypeResolver)CachedValuesManager.getCachedValue((PsiElement)factoryClass, () -> {
            if (factoryClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factoryClass", "com/intellij/spring/factories/SpringFactoryBeansManagerImpl", "lambda$getObjectTypeResolver$1"));
            }
            return new CachedValueProvider.Result((Object)this.doGetObjectTypeResolver(factoryClass), new Object[]{factoryClass});
        });
    }

    @Nullable
    private ObjectTypeResolver doGetObjectTypeResolver(@NotNull PsiClass factoryClass) {
        if (factoryClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factoryClass", "com/intellij/spring/factories/SpringFactoryBeansManagerImpl", "doGetObjectTypeResolver"));
        }
        String qualifiedName = factoryClass.getQualifiedName();
        ObjectTypeResolver typeResolver = this.mySpringFactories.get(qualifiedName);
        if (typeResolver != null) {
            return typeResolver;
        }
        GlobalSearchScope resolveScope = factoryClass.getResolveScope();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)factoryClass.getProject());
        for (String factoryClassName : this.mySpringFactories.keySet()) {
            ObjectTypeResolver resolver;
            PsiClass psiClass = facade.findClass(factoryClassName, resolveScope);
            if (psiClass == null || !factoryClass.isInheritor(psiClass, false) || (resolver = this.mySpringFactories.get(factoryClassName)) == null) continue;
            return resolver;
        }
        return null;
    }

    private static Set<PsiType> guessObjectTypes(PsiClass factoryClass) {
        return (Set)CachedValuesManager.getManager((Project)factoryClass.getProject()).getCachedValue((UserDataHolder)factoryClass, CACHED_OBJECT_TYPE, () -> {
            Set<PsiType> types = SpringFactoryBeansManagerImpl.doGuessObjectType(factoryClass);
            return new CachedValueProvider.Result(types, SpringFactoryBeansManagerImpl.getDependencies(factoryClass, types));
        }, false);
    }

    private static Object[] getDependencies(@NotNull PsiClass factoryClass, @NotNull Set<PsiType> types) {
        if (factoryClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factoryClass", "com/intellij/spring/factories/SpringFactoryBeansManagerImpl", "getDependencies"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/spring/factories/SpringFactoryBeansManagerImpl", "getDependencies"));
        }
        HashSet deps = ContainerUtil.newHashSet();
        deps.add(factoryClass);
        for (PsiType type : types) {
            if (type instanceof PsiClassType) {
                ContainerUtil.addIfNotNull((Collection)deps, (Object)((PsiClassType)type).resolve());
                continue;
            }
            return new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT};
        }
        return ArrayUtil.toObjectArray((Collection)deps);
    }

    @Nullable
    private static PsiMethod getProductTypeMethod(PsiClass factoryClass) {
        for (PsiMethod psiMethod : factoryClass.findMethodsByName("getObjectType", true)) {
            if (psiMethod.getParameterList().getParameters().length != 0) continue;
            return psiMethod;
        }
        return null;
    }

    @NotNull
    private static Set<PsiType> doGuessObjectType(PsiClass factoryClass) {
        PsiType factoryBeanGenericType;
        PsiExpression value;
        PsiStatement[] statements;
        VirtualFile file;
        PsiMethod method = SpringFactoryBeansManagerImpl.getProductTypeMethod(factoryClass);
        if (method == null) {
            Set<PsiType> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/SpringFactoryBeansManagerImpl", "doGuessObjectType"));
            }
            return set;
        }
        if (method instanceof PsiCompiledElement && (file = method.getContainingFile().getVirtualFile()) != null) {
            FactoryBeanObjectTypeReader reader = new FactoryBeanObjectTypeReader();
            try {
                new ClassReader(file.contentsToByteArray()).accept((ClassVisitor)reader, 2);
            }
            catch (IOException iOException) {
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            String qName = reader.getResultQName();
            PsiType psiType = SpringFactoryBeansManagerImpl.createTypeByTypeName(factoryClass, qName);
            Set<Object> set = psiType != null ? Collections.singleton(psiType) : Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/SpringFactoryBeansManagerImpl", "doGuessObjectType"));
            }
            return set;
        }
        PsiCodeBlock body = method.getBody();
        if (body != null && (statements = body.getStatements()).length == 1 && statements[0] instanceof PsiReturnStatement && (value = ((PsiReturnStatement)statements[0]).getReturnValue()) != null) {
            if (value instanceof PsiClassObjectAccessExpression) {
                Set<PsiType> set = Collections.singleton(((PsiClassObjectAccessExpression)value).getOperand().getType());
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/SpringFactoryBeansManagerImpl", "doGuessObjectType"));
                }
                return set;
            }
            PsiType psiType = value.getType();
            if (psiType instanceof PsiClassType) {
                PsiType classType = PsiTypeUtil.getInstance((Project)factoryClass.getProject()).findType(Class.class);
                if (classType != null && psiType.isAssignableFrom(classType)) {
                    Set<PsiType> set = SpringFactoryBeansManagerImpl.getClassTypes((PsiClassType)psiType);
                    if (set == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/SpringFactoryBeansManagerImpl", "doGuessObjectType"));
                    }
                    return set;
                }
            } else if (psiType != null) {
                Set<PsiType> set = Collections.singleton(psiType);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/SpringFactoryBeansManagerImpl", "doGuessObjectType"));
                }
                return set;
            }
        }
        if ((factoryBeanGenericType = PsiUtil.substituteTypeParameter((PsiType)PsiTypesUtil.getClassType((PsiClass)factoryClass), (String)"org.springframework.beans.factory.FactoryBean", (int)0, (boolean)false)) != null) {
            Set<PsiType> set = Collections.singleton(factoryBeanGenericType);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/SpringFactoryBeansManagerImpl", "doGuessObjectType"));
            }
            return set;
        }
        Set<PsiType> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/SpringFactoryBeansManagerImpl", "doGuessObjectType"));
        }
        return set;
    }

    @NotNull
    private static Set<PsiType> getClassTypes(PsiClassType psiType) {
        PsiType type;
        List types = SpringCommonUtils.resolveGenerics((PsiClassType)psiType);
        if (types.size() == 1 && (type = (PsiType)types.get(0)) instanceof PsiClassType) {
            PsiClass aClass = ((PsiClassType)type).resolve();
            if (aClass instanceof PsiTypeParameter) {
                HashSet classNames = ContainerUtil.newHashSet();
                Collections.addAll(classNames, aClass.getExtendsListTypes());
                HashSet hashSet = classNames;
                if (hashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/SpringFactoryBeansManagerImpl", "getClassTypes"));
                }
                return hashSet;
            }
            Set<PsiType> set = Collections.singleton(type);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/SpringFactoryBeansManagerImpl", "getClassTypes"));
            }
            return set;
        }
        Set<PsiType> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/SpringFactoryBeansManagerImpl", "getClassTypes"));
        }
        return set;
    }

    public void registerFactory(String className, ObjectTypeResolver resolver) {
        this.mySpringFactories.put(className, resolver);
    }

    public void unregisterFactory(String className) {
        this.mySpringFactories.remove(className);
    }

    public boolean isFactoryBeanClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/factories/SpringFactoryBeansManagerImpl", "isFactoryBeanClass"));
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/factories/SpringFactoryBeansManagerImpl", "lambda$isFactoryBeanClass$3"));
            }
            GlobalSearchScope scope = psiClass.getResolveScope();
            PsiClass beanFactoryClass = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass("org.springframework.beans.factory.FactoryBean", scope);
            boolean isBeanFactory = beanFactoryClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)beanFactoryClass, (boolean)true);
            return CachedValueProvider.Result.createSingleDependency((Object)isBeanFactory, (Object)psiClass);
        });
    }

    public boolean isValidFactoryMethod(@NotNull PsiMethod psiMethod, boolean isBeansXmlFactoryBean) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/factories/SpringFactoryBeansManagerImpl", "isValidFactoryMethod"));
        }
        if (psiMethod.isConstructor() || psiMethod.getReturnType() == null) {
            return false;
        }
        boolean isStatic = psiMethod.hasModifierProperty("static");
        return (isBeansXmlFactoryBean && !isStatic || !isBeansXmlFactoryBean && isStatic) && SpringFactoryBeansManagerImpl.hasFactoryReturnType(psiMethod);
    }

    public static boolean hasFactoryReturnType(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/factories/SpringFactoryBeansManagerImpl", "hasFactoryReturnType"));
        }
        PsiType returnType = psiMethod.getReturnType();
        return returnType instanceof PsiPrimitiveType || returnType instanceof PsiClassType || returnType instanceof PsiArrayType;
    }

    private static class FactoryBeanObjectTypeReader
    extends ClassVisitor {
        private String myResultQName;

        public FactoryBeanObjectTypeReader() {
            super(393216);
        }

        public String getResultQName() {
            return this.myResultQName;
        }

        public MethodVisitor visitMethod(int access, @NonNls String name, String desc, String signature, String[] exceptions) {
            if ("getObjectType".equals(name) && (signature == null || signature.startsWith("()"))) {
                return new MethodVisitor(393216){
                    private String qname;
                    private int number;
                    {
                        super(x0);
                        this.number = 0;
                    }

                    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                        if ((this.number == 0 || this.number == 7) && opcode == 178 || this.number == 5 && opcode == 179) {
                            ++this.number;
                        }
                    }

                    public void visitJumpInsn(int opcode, Label label) {
                        if (this.number == 1 && opcode == 199 || this.number == 6 && opcode == 167) {
                            ++this.number;
                        }
                    }

                    public void visitLdcInsn(Object cst) {
                        if (this.number == 2 && cst instanceof String) {
                            ++this.number;
                            this.qname = (String)cst;
                        } else if (this.number == 0 && cst instanceof Type) {
                            ++this.number;
                            this.qname = ((Type)cst).getClassName();
                        }
                    }

                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                        if (this.number != 3 || opcode != 184 || !"class$".equals(name)) {
                            return;
                        }
                        ++this.number;
                    }

                    public void visitInsn(int opcode) {
                        if (this.number == 4 && opcode == 89) {
                            ++this.number;
                        }
                        if ((this.number == 8 || this.number == 1) && opcode == 176) {
                            if (myResultQName == null) {
                                myResultQName = this.qname;
                            }
                            ++this.number;
                        }
                    }
                };
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

