/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.impl;

import com.intellij.facet.FacetFinder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.AnnotationSpringModelImpl;
import com.intellij.spring.contexts.model.CombinedSpringModelImpl;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.contexts.model.XmlSpringModelImpl;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringCombinedModelFactory {
    private static final Key<CachedValue<Set<SpringModel>>> SPRING_MODELS_KEY = Key.create((String)"SPRING_MODELS_KEY");

    static Set<SpringModel> getAllModelsWithoutDependencies(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringCombinedModelFactory", "getAllModelsWithoutDependencies"));
        }
        if (module.isDisposed()) {
            return Collections.emptySet();
        }
        return (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, SPRING_MODELS_KEY, () -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringCombinedModelFactory", "lambda$getAllModelsWithoutDependencies$0"));
            }
            SpringFacet facet = SpringFacet.getInstance((Module)module);
            if (facet == null) {
                return CachedValueProvider.Result.create(Collections.emptySet(), (Object[])new Object[]{FacetFinder.getInstance((Project)module.getProject()).getAllFacetsOfTypeModificationTracker(SpringFacet.FACET_TYPE_ID)});
            }
            Set fileSets = SpringFileSetService.getInstance().getAllSets(facet);
            LinkedHashSet<SpringModel> models = new LinkedHashSet<SpringModel>(fileSets.size());
            for (SpringFileSet set : fileSets) {
                SpringModel model;
                if (set.isRemoved() || (model = SpringCombinedModelFactory.createModel(set, module)) == null) continue;
                models.add(model);
            }
            return CachedValueProvider.Result.create(models, (Object[])SpringManager.getInstance((Project)module.getProject()).getModelsDependencies(module, new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT}));
        }, false);
    }

    static void setDependencies(Set<SpringModel> models) {
        for (SpringModel model : models) {
            SpringFileSet fileSet = model.getFileSet();
            assert (fileSet != null) : model;
            Set dependencyFileSets = fileSet.getDependencyFileSets();
            if (dependencyFileSets.isEmpty()) continue;
            LinkedHashSet set = ContainerUtil.newLinkedHashSet();
            Iterator it = dependencyFileSets.iterator();
            while (it.hasNext()) {
                SpringFileSet depend = (SpringFileSet)it.next();
                boolean valid = false;
                for (SpringModel depModel : models) {
                    if (depModel == model || !depend.equals((Object)depModel.getFileSet())) continue;
                    set.add(depModel);
                    valid = true;
                    break;
                }
                if (valid) continue;
                it.remove();
            }
            model.setDependencies((Set)set);
        }
    }

    @Nullable
    public static SpringModel createModel(SpringFileSet set, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringCombinedModelFactory", "createModel"));
        }
        LinkedHashSet<SpringModel> mixed = new LinkedHashSet<SpringModel>();
        List<XmlFile> xmlConfigs = SpringCombinedModelFactory.getXmlConfigs(set, module.getProject());
        Set<PsiClass> codeConfigurations = SpringCombinedModelFactory.getCodeConfigs(set, module.getProject());
        if (xmlConfigs.size() > 0) {
            XmlSpringModel xmlModel = SpringCombinedModelFactory.createXmlModel(xmlConfigs, module, set);
            if (codeConfigurations.isEmpty()) {
                return xmlModel;
            }
            ContainerUtil.addIfNotNull(mixed, (Object)xmlModel);
        }
        if (codeConfigurations.size() > 0) {
            AnnotationSpringModelImpl annotationSpringModel = new AnnotationSpringModelImpl(codeConfigurations, module, set);
            if (xmlConfigs.isEmpty()) {
                return annotationSpringModel;
            }
            mixed.add((SpringModel)annotationSpringModel);
        }
        return new CombinedSpringModelImpl(mixed, module, set);
    }

    @NotNull
    private static List<XmlFile> getXmlConfigs(@Nullable SpringFileSet set, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/impl/SpringCombinedModelFactory", "getXmlConfigs"));
        }
        if (set == null) {
            List<XmlFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/impl/SpringCombinedModelFactory", "getXmlConfigs"));
            }
            return list;
        }
        ArrayList<XmlFile> xmlConfigs = new ArrayList<XmlFile>();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (VirtualFilePointer pointer : set.getXmlFiles()) {
            PsiFile psiFile;
            VirtualFile file = pointer.getFile();
            if (file == null || !((psiFile = psiManager.findFile(file)) instanceof XmlFile)) continue;
            xmlConfigs.add((XmlFile)psiFile);
        }
        ArrayList<XmlFile> arrayList = xmlConfigs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/impl/SpringCombinedModelFactory", "getXmlConfigs"));
        }
        return arrayList;
    }

    @NotNull
    private static Set<PsiClass> getCodeConfigs(@Nullable SpringFileSet set, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/impl/SpringCombinedModelFactory", "getCodeConfigs"));
        }
        if (set == null) {
            Set<PsiClass> set2 = Collections.emptySet();
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/impl/SpringCombinedModelFactory", "getCodeConfigs"));
            }
            return set2;
        }
        LinkedHashSet<PsiClass> configurations = new LinkedHashSet<PsiClass>();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (VirtualFilePointer pointer : set.getCodeConfigurationFiles()) {
            PsiFile psiFile;
            VirtualFile file = pointer.getFile();
            if (file == null || !((psiFile = psiManager.findFile(file)) instanceof PsiClassOwner)) continue;
            configurations.addAll(SpringCombinedModelFactory.getConfigurationPsiClasses((PsiClassOwner)psiFile));
        }
        LinkedHashSet<PsiClass> linkedHashSet = configurations;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/impl/SpringCombinedModelFactory", "getCodeConfigs"));
        }
        return linkedHashSet;
    }

    private static void addConfigurations(@NotNull Set<PsiClass> configurations, @NotNull PsiClass psiClass) {
        if (configurations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurations", "com/intellij/spring/impl/SpringCombinedModelFactory", "addConfigurations"));
        }
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/impl/SpringCombinedModelFactory", "addConfigurations"));
        }
        if (configurations.contains(psiClass)) {
            return;
        }
        configurations.add(psiClass);
        for (PsiClass aClass : psiClass.getInnerClasses()) {
            if (!SpringCommonUtils.isConfiguration((PsiClass)aClass)) continue;
            SpringCombinedModelFactory.addConfigurations(configurations, aClass);
        }
    }

    @Nullable
    private static XmlSpringModel createXmlModel(Collection<XmlFile> configs, Module module, @Nullable SpringFileSet set) {
        return SpringCombinedModelFactory.createXmlModel(configs, module, set, (NullableFactory<Set<String>>)((NullableFactory)() -> set == null ? null : set.getActiveProfiles()));
    }

    @Nullable
    public static XmlSpringModel createXmlModel(Collection<XmlFile> configs, Module module, @NotNull Set<String> activeProfiles) {
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "com/intellij/spring/impl/SpringCombinedModelFactory", "createXmlModel"));
        }
        return SpringCombinedModelFactory.createXmlModel(configs, module, null, (NullableFactory<Set<String>>)((NullableFactory)() -> {
            if (activeProfiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "com/intellij/spring/impl/SpringCombinedModelFactory", "lambda$createXmlModel$2"));
            }
            return activeProfiles;
        }));
    }

    @Nullable
    private static XmlSpringModel createXmlModel(@NotNull Collection<XmlFile> configs, @NotNull Module module, @Nullable SpringFileSet set, final @NotNull NullableFactory<Set<String>> activeProfilesFactory) {
        if (configs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/spring/impl/SpringCombinedModelFactory", "createXmlModel"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringCombinedModelFactory", "createXmlModel"));
        }
        if (activeProfilesFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfilesFactory", "com/intellij/spring/impl/SpringCombinedModelFactory", "createXmlModel"));
        }
        LinkedHashSet<XmlFile> files = new LinkedHashSet<XmlFile>(configs.size());
        for (XmlFile psiFile : configs) {
            if (!SpringDomUtils.isSpringXml((XmlFile)psiFile)) continue;
            files.add(psiFile);
        }
        if (files.isEmpty()) {
            return null;
        }
        return new XmlSpringModelImpl(files, module, set){

            public Set<String> getActiveProfiles() {
                return (Set)activeProfilesFactory.create();
            }
        };
    }

    @Nullable
    static SpringModel createSingleModel(@NotNull PsiFile psiFile, @NotNull Module module) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/spring/impl/SpringCombinedModelFactory", "createSingleModel"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringCombinedModelFactory", "createSingleModel"));
        }
        if (psiFile instanceof XmlFile) {
            return SpringCombinedModelFactory.createSingleXmlModel((XmlFile)psiFile, module);
        }
        if (psiFile instanceof PsiClassOwner) {
            return SpringCombinedModelFactory.createSingleAnnotationModel((PsiClassOwner)psiFile, module);
        }
        return null;
    }

    @Nullable
    static SpringModel createSingleXmlModel(@NotNull XmlFile psiFile, @NotNull Module module) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/spring/impl/SpringCombinedModelFactory", "createSingleXmlModel"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringCombinedModelFactory", "createSingleXmlModel"));
        }
        if (module.isDisposed()) {
            return null;
        }
        DomFileElement beans = SpringDomUtils.getSpringDomFileElement((XmlFile)psiFile);
        if (beans != null) {
            return new XmlSpringModelImpl(Collections.singleton(psiFile), module, null);
        }
        return null;
    }

    @Nullable
    private static SpringModel createSingleAnnotationModel(@NotNull PsiClassOwner psiClassOwner, @NotNull Module module) {
        if (psiClassOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClassOwner", "com/intellij/spring/impl/SpringCombinedModelFactory", "createSingleAnnotationModel"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringCombinedModelFactory", "createSingleAnnotationModel"));
        }
        Set<PsiClass> configurations = SpringCombinedModelFactory.getConfigurationPsiClasses(psiClassOwner);
        if (!configurations.isEmpty()) {
            return new AnnotationSpringModelImpl(configurations, module, null);
        }
        return null;
    }

    private static Set<PsiClass> getConfigurationPsiClasses(PsiClassOwner psiClassOwner) {
        LinkedHashSet<PsiClass> configurations = new LinkedHashSet<PsiClass>();
        for (PsiClass psiClass : psiClassOwner.getClasses()) {
            SpringCombinedModelFactory.addConfigurations(configurations, psiClass);
        }
        return configurations;
    }

    @NotNull
    static Set<SpringModel> findModelsInScope(@NotNull PsiFile psiFile, @NotNull Module module) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/spring/impl/SpringCombinedModelFactory", "findModelsInScope"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringCombinedModelFactory", "findModelsInScope"));
        }
        PsiFile originalFile = psiFile.getOriginalFile();
        VirtualFile virtualFile = originalFile.getVirtualFile();
        LinkedHashSet<SpringModel> models = new LinkedHashSet<SpringModel>();
        for (SpringModel model : SpringManager.getInstance((Project)module.getProject()).getAllModels(module)) {
            if (SpringCombinedModelFactory.isConfiguredInFileSet(model, virtualFile)) {
                models.add(model);
                continue;
            }
            if (!model.hasConfigFile(originalFile)) continue;
            models.add(model);
        }
        LinkedHashSet<SpringModel> linkedHashSet = models;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/impl/SpringCombinedModelFactory", "findModelsInScope"));
        }
        return linkedHashSet;
    }

    private static boolean isConfiguredInFileSet(SpringModel model, VirtualFile virtualFile) {
        SpringFileSet fileSet = model.getFileSet();
        if (fileSet == null) {
            return false;
        }
        if (fileSet.hasFile(virtualFile)) {
            return true;
        }
        for (SpringFileSet dep : fileSet.getDependencyFileSets()) {
            if (!dep.hasFile(virtualFile)) continue;
            return true;
        }
        return false;
    }
}

