/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.transaction;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.transaction.SpringTransactionalComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringTransactionalComponentInspection
extends BaseJavaLocalInspectionTool {
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/model/jam/transaction/SpringTransactionalComponentInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/model/jam/transaction/SpringTransactionalComponentInspection", "checkClass"));
        }
        if (!JamCommonUtil.isPlainJavaFile((PsiElement)aClass.getContainingFile())) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
        if (module != null && SpringFacet.getInstance((Module)module) != null) {
            SpringTransactionalComponent transactionConfiguration = (SpringTransactionalComponent)SpringTransactionalComponent.META.getJamElement((PsiModifierListOwner)aClass);
            if (transactionConfiguration == null) {
                return null;
            }
            ProblemsHolder holder = new ProblemsHolder(manager, aClass.getContainingFile(), isOnTheFly);
            SpringTransactionalComponentInspection.checkTransactionManagerBeanResolve(holder, transactionConfiguration.getValueAttributeElement());
            return holder.getResultsArray();
        }
        return null;
    }

    public static void checkTransactionManagerBeanResolve(ProblemsHolder holder, JamStringAttributeElement<SpringBeanPointer> element) {
        PsiAnnotationMemberValue memberValue;
        String beanName = element.getStringValue();
        if (beanName != null && (memberValue = element.getPsiElement()) != null) {
            SpringBeanPointer value = (SpringBeanPointer)element.getValue();
            if (value == null) {
                holder.registerProblem((PsiElement)memberValue, SpringApiBundle.message((String)"model.bean.error.message", (Object[])new Object[]{beanName}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            } else {
                PsiClass psiClass = value.getBeanClass();
                if (psiClass != null && !InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.transaction.PlatformTransactionManager")) {
                    holder.registerProblem((PsiElement)memberValue, SpringApiBundle.message((String)"bean.must.be.of.type", (Object[])new Object[]{"org.springframework.transaction.PlatformTransactionManager"}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }
        }
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringTransactionalComponentInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/transaction/SpringTransactionalComponentInspection", "getShortName"));
        }
        return "SpringTransactionalComponentInspection";
    }
}

