/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml.beans.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.spring.model.xml.beans.CNamespaceDomElement;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringValueHolderDefinitionBase;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CNamespaceValueBaseImpl
extends SpringValueHolderDefinitionBase
implements CNamespaceDomElement {
    @NotNull
    public List<PsiType> getRequiredTypes() {
        SpringBean bean = (SpringBean)this.getParent();
        assert (bean != null);
        LinkedHashSet psiTypes = ContainerUtil.newLinkedHashSet();
        List psiMethods = bean.getInstantiationMethods();
        for (PsiMethod psiMethod : psiMethods) {
            int idx = 0;
            for (PsiParameter psiParameter : psiMethod.getParameterList().getParameters()) {
                if (this.matchesByName(psiParameter) || this.matchesByIndex(idx)) {
                    psiTypes.add(psiParameter.getType());
                }
                ++idx;
            }
        }
        ArrayList<PsiType> arrayList = new ArrayList<PsiType>(psiTypes);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/beans/impl/CNamespaceValueBaseImpl", "getRequiredTypes"));
        }
        return arrayList;
    }

    public boolean isIndexAttribute() {
        return StringUtil.startsWithChar((CharSequence)this.getAttributeName(), (char)'_');
    }

    @Nullable
    public Integer getIndex() {
        String number = this.getAttributeName().substring(1);
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private boolean matchesByIndex(int matchIndex) {
        if (!this.isIndexAttribute()) {
            return false;
        }
        Integer myIndex = this.getIndex();
        return myIndex != null && myIndex == matchIndex;
    }

    private boolean matchesByName(PsiParameter psiParameter) {
        return this.getAttributeName().equals(psiParameter.getName());
    }
}

