/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.refactoring;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameInputValidatorEx;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringBeanPsiTarget;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.Nullable;

public class SpringBeanRenameInputValidator
implements RenameInputValidatorEx {
    @Nullable
    public String getErrorMessage(String newName, Project project) {
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            for (SpringModel springModel : SpringManager.getInstance((Project)project).getAllModelsWithoutDependencies(module)) {
                SpringBeanPointer foundValue = SpringModelSearchers.findBean((CommonSpringModel)springModel, (String)newName);
                if (foundValue == null) continue;
                return "Spring Bean with name '" + newName + "' already exists in " + foundValue.getContainingFile().getName();
            }
        }
        return null;
    }

    public ElementPattern<? extends PsiElement> getPattern() {
        return PlatformPatterns.pomElement((ElementPattern)StandardPatterns.instanceOf(SpringBeanPsiTarget.class));
    }

    public boolean isInputValid(String newName, PsiElement element, ProcessingContext context) {
        return true;
    }
}

