/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.run;

import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.run.AutowireMethodFieldLinkFilter;
import com.intellij.spring.run.BeanNameFilter;
import org.jetbrains.annotations.NotNull;

public class SpringConsoleFilterProvider
implements ConsoleFilterProvider {
    @NotNull
    public Filter[] getDefaultFilters(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/run/SpringConsoleFilterProvider", "getDefaultFilters"));
        }
        if (SpringConsoleFilterProvider.isSpringProject(project)) {
            Filter[] filterArray = new Filter[]{new BeanNameFilter(), new AutowireMethodFieldLinkFilter()};
            if (filterArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/run/SpringConsoleFilterProvider", "getDefaultFilters"));
            }
            return filterArray;
        }
        if (Filter.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/run/SpringConsoleFilterProvider", "getDefaultFilters"));
        }
        return Filter.EMPTY_ARRAY;
    }

    private static boolean isSpringProject(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/run/SpringConsoleFilterProvider", "isSpringProject"));
        }
        if (!project.isInitialized()) {
            return false;
        }
        return SpringCommonUtils.hasSpringFacets((Project)project) || (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return SpringLibraryUtil.hasSpringLibrary((Project)project);
            }
        }) != false;
    }
}

