/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit5;

import com.intellij.junit4.ExpectedPatterns;
import com.intellij.rt.execution.junit.ComparisonFailureData;
import com.intellij.rt.execution.junit.MapSerializerUtil;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.descriptor.JavaMethodSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.ValueWrapper;

public class JUnit5TestExecutionListener
implements TestExecutionListener {
    private final PrintStream myPrintStream;
    private TestPlan myTestPlan;
    private long myCurrentTestStart;
    private int myFinishCount = 0;
    private String myRootName;
    private Set<TestIdentifier> myRoots;

    public JUnit5TestExecutionListener() {
        this(System.out);
    }

    public JUnit5TestExecutionListener(PrintStream printStream) {
        this.myPrintStream = printStream;
        this.myPrintStream.println("##teamcity[enteredTheMatrix]");
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        if (this.myRootName != null) {
            int lastPointIdx = this.myRootName.lastIndexOf(46);
            String name = this.myRootName;
            String comment = null;
            if (lastPointIdx >= 0) {
                name = this.myRootName.substring(lastPointIdx + 1);
                comment = this.myRootName.substring(0, lastPointIdx);
            }
            this.myPrintStream.println("##teamcity[rootName name = '" + JUnit5TestExecutionListener.escapeName(name) + (comment != null ? "' comment = '" + JUnit5TestExecutionListener.escapeName(comment) : "") + "' location = 'java:suite://" + JUnit5TestExecutionListener.escapeName(this.myRootName) + "']");
        }
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.myTestPlan = null;
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.executionStarted(testIdentifier);
        this.executionFinished(testIdentifier, TestExecutionResult.Status.ABORTED, null, reason);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (testIdentifier.isTest()) {
            this.testStarted(testIdentifier);
            this.myCurrentTestStart = System.currentTimeMillis();
        } else if (!this.myRoots.contains(testIdentifier)) {
            this.myFinishCount = 0;
            this.myPrintStream.println("##teamcity[testSuiteStarted" + JUnit5TestExecutionListener.idAndName(testIdentifier) + "']");
        }
    }

    private static String idAndName(TestIdentifier testIdentifier) {
        return JUnit5TestExecutionListener.idAndName(testIdentifier, testIdentifier.getDisplayName());
    }

    private static String idAndName(TestIdentifier testIdentifier, String displayName) {
        return " id='" + testIdentifier.getUniqueId().toString() + "' name='" + JUnit5TestExecutionListener.escapeName(displayName);
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        TestExecutionResult.Status status = testExecutionResult.getStatus();
        Throwable throwableOptional = testExecutionResult.getThrowable().orElse(null);
        this.executionFinished(testIdentifier, status, throwableOptional, null);
    }

    private void executionFinished(TestIdentifier testIdentifier, TestExecutionResult.Status status, Throwable throwableOptional, String reason) {
        String displayName = testIdentifier.getDisplayName();
        if (testIdentifier.isTest()) {
            long duration = System.currentTimeMillis() - this.myCurrentTestStart;
            if (status == TestExecutionResult.Status.FAILED) {
                this.testFailure(testIdentifier, "testFailed", throwableOptional, duration, reason);
            } else if (status == TestExecutionResult.Status.ABORTED) {
                this.testFailure(testIdentifier, "testIgnored", throwableOptional, duration, reason);
            }
            this.testFinished(testIdentifier, duration);
            ++this.myFinishCount;
        } else if (!this.myRoots.contains(testIdentifier)) {
            String messageName = null;
            if (status == TestExecutionResult.Status.FAILED) {
                messageName = "testFailed";
            } else if (status == TestExecutionResult.Status.ABORTED) {
                messageName = "testIgnored";
            }
            if (messageName != null && this.myFinishCount == 0) {
                for (TestIdentifier childIdentifier : this.myTestPlan.getDescendants(testIdentifier)) {
                    this.testStarted(childIdentifier);
                    this.testFailure(childIdentifier, messageName, throwableOptional, 0L, reason);
                    this.testFinished(childIdentifier, 0L);
                }
            }
            this.myPrintStream.println("##teamcity[testSuiteFinished " + JUnit5TestExecutionListener.idAndName(testIdentifier, displayName) + "']");
        }
    }

    private void testStarted(TestIdentifier testIdentifier) {
        this.myPrintStream.println("\n##teamcity[testStarted" + JUnit5TestExecutionListener.idAndName(testIdentifier) + "']");
    }

    private void testFinished(TestIdentifier testIdentifier, long duration) {
        this.myPrintStream.println("\n##teamcity[testFinished" + JUnit5TestExecutionListener.idAndName(testIdentifier) + (duration > 0L ? "' duration='" + Long.toString(duration) : "") + "']");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFailure(TestIdentifier testIdentifier, String messageName, Throwable ex, long duration, String reason) {
        block9: {
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("name", testIdentifier.getDisplayName());
            attrs.put("id", testIdentifier.getUniqueId().toString());
            if (duration > 0L) {
                attrs.put("duration", Long.toString(duration));
            }
            if (reason != null) {
                attrs.put("message", reason);
            }
            try {
                if (ex == null) break block9;
                StringWriter stringWriter = new StringWriter();
                PrintWriter writer = new PrintWriter(stringWriter);
                ex.printStackTrace(writer);
                ComparisonFailureData failureData = null;
                if (ex instanceof AssertionFailedError && ((AssertionFailedError)ex).isActualDefined() && ((AssertionFailedError)ex).isExpectedDefined()) {
                    ValueWrapper actual = ((AssertionFailedError)ex).getActual();
                    ValueWrapper expected = ((AssertionFailedError)ex).getExpected();
                    failureData = new ComparisonFailureData(expected.getStringRepresentation(), actual.getStringRepresentation());
                } else {
                    try {
                        failureData = ExpectedPatterns.createExceptionNotification((Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                ComparisonFailureData.registerSMAttributes((ComparisonFailureData)failureData, (String)stringWriter.toString(), (String)ex.getMessage(), attrs, (Throwable)ex);
            }
            finally {
                this.myPrintStream.println("\n" + MapSerializerUtil.asString((String)messageName, attrs));
            }
        }
    }

    public void sendTree(TestPlan testPlan, String rootName) {
        this.myTestPlan = testPlan;
        this.myRootName = rootName;
        this.myRoots = testPlan.getRoots();
        for (TestIdentifier root : this.myRoots) {
            assert (root.isContainer());
            for (TestIdentifier testIdentifier : testPlan.getChildren(root)) {
                this.sendTreeUnderRoot(testPlan, testIdentifier);
            }
        }
        this.myPrintStream.println("##teamcity[treeEnded]");
    }

    private void sendTreeUnderRoot(TestPlan testPlan, TestIdentifier root) {
        String idAndName = JUnit5TestExecutionListener.idAndName(root);
        if (root.isContainer()) {
            this.myPrintStream.println("##teamcity[suiteTreeStarted" + idAndName + "' locationHint='java:suite://" + JUnit5TestExecutionListener.escapeName(JUnit5TestExecutionListener.getClassName(root)) + "']");
            for (TestIdentifier childIdentifier : testPlan.getChildren(root)) {
                this.sendTreeUnderRoot(testPlan, childIdentifier);
            }
            this.myPrintStream.println("##teamcity[suiteTreeEnded" + idAndName + "']");
        } else if (root.isTest()) {
            this.myPrintStream.println("##teamcity[suiteTreeNode " + idAndName + "' locationHint='java:test://" + JUnit5TestExecutionListener.escapeName(JUnit5TestExecutionListener.getClassName(root) + "." + JUnit5TestExecutionListener.getMethodName(root)) + "']");
        }
    }

    private static String escapeName(String str) {
        return MapSerializerUtil.escapeStr((String)str, (MapSerializerUtil.EscapeInfoProvider)MapSerializerUtil.STD_ESCAPER);
    }

    static String getClassName(TestIdentifier description) {
        Optional<JavaMethodSource> javaSource = JUnit5TestExecutionListener.getJavaSource(description);
        return javaSource.map(source -> source.getJavaClass().getName()).orElse(null);
    }

    static String getMethodName(TestIdentifier testIdentifier) {
        return JUnit5TestExecutionListener.getJavaSource(testIdentifier).map(JavaMethodSource::getJavaMethodName).orElse(null);
    }

    private static Optional<JavaMethodSource> getJavaSource(TestIdentifier testIdentifier) {
        return testIdentifier.getSource().filter(JavaMethodSource.class::isInstance).map(JavaMethodSource.class::cast);
    }
}

