/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.references;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.PsiMethodCallFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.filters.position.ParentElementFilter;
import com.intellij.spring.ws.util.SpringWebServicesUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringWebServicesReferenceContributor
extends PsiReferenceContributor {
    private static final String SOAP_MESSAGE_CLASS = "org.springframework.ws.soap.SoapMessage";
    private static final String SOAP_ACTION_SETTER = "setSoapAction";

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/ws/references/SpringWebServicesReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression().and((ElementPattern)new FilterPattern((ElementFilter)new ParentElementFilter((ElementFilter)new PsiMethodCallFilter(SOAP_MESSAGE_CLASS, new String[]{SOAP_ACTION_SETTER}), 2))), (PsiReferenceProvider)new SoapActionReferenceProvider());
    }

    private static class SoapActionReferenceProvider
    extends PsiReferenceProvider {
        private SoapActionReferenceProvider() {
        }

        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/ws/references/SpringWebServicesReferenceContributor$SoapActionReferenceProvider", "getReferencesByElement"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/ws/references/SpringWebServicesReferenceContributor$SoapActionReferenceProvider", "getReferencesByElement"));
            }
            PsiReference[] psiReferenceArray = new PsiReference[]{new PsiReferenceBase<PsiElement>(element, true){

                public PsiElement resolve() {
                    Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
                    if (module != null) {
                        return SpringWebServicesUtil.collectWebServiceAddressingInputActions(module).get(this.getValue());
                    }
                    return null;
                }

                @NotNull
                public Object[] getVariants() {
                    Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
                    if (module != null) {
                        Set<String> set = SpringWebServicesUtil.collectWebServiceAddressingInputActions(module).keySet();
                        Object[] objectArray = ArrayUtil.toObjectArray(set);
                        if (objectArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/references/SpringWebServicesReferenceContributor$SoapActionReferenceProvider$1", "getVariants"));
                        }
                        return objectArray;
                    }
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/references/SpringWebServicesReferenceContributor$SoapActionReferenceProvider$1", "getVariants"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
            }};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/references/SpringWebServicesReferenceContributor$SoapActionReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
    }
}

