/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\n \u0010*\u0004\u0018\u00010\u000e0\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SafeDeleteFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/psi/KtDeclaration;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "kotlin.jvm.PlatformType", "idea"})
public final class SafeDeleteFix
implements LocalQuickFix {
    @NotNull
    private final KtDeclaration declaration;

    public String getName() {
        return this.declaration instanceof KtConstructor ? "Safe delete constructor" : QuickFixBundle.message((String)"safe.delete.text", (Object[])new Object[]{this.declaration.getName()});
    }

    @NotNull
    public String getFamilyName() {
        return "Safe delete";
    }

    /*
     * WARNING - void declaration
     */
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        void elements$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        if (!FileModificationService.getInstance().prepareFileForWrite(this.declaration.getContainingFile())) {
            return;
        }
        KtDeclaration[] ktDeclarationArray = new KtDeclaration[]{this.declaration};
        Project project2 = project;
        Object[] objectArray = (Object[])elements$iv;
        SafeDeleteHandler.invoke((Project)project2, (PsiElement[])((PsiElement[])objectArray), (boolean)false);
    }

    @NotNull
    public final KtDeclaration getDeclaration() {
        return this.declaration;
    }

    public SafeDeleteFix(@NotNull KtDeclaration declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        this.declaration = declaration;
    }
}

