/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.bundling;

import org.gradle.api.Incubating;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.file.archive.ZipCopyAction;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.DefaultZipCompressor;
import org.gradle.api.internal.file.copy.ZipCompressor;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.ZipEntryCompression;

public class Zip
extends AbstractArchiveTask {
    public static final String ZIP_EXTENSION = "zip";
    private ZipEntryCompression entryCompression = ZipEntryCompression.DEFLATED;
    private boolean allowZip64;
    private String encoding;

    public Zip() {
        this.setExtension(ZIP_EXTENSION);
        this.allowZip64 = false;
    }

    protected ZipCompressor getCompressor() {
        switch (this.entryCompression) {
            case DEFLATED: {
                return new DefaultZipCompressor(this.allowZip64, 8);
            }
            case STORED: {
                return new DefaultZipCompressor(this.allowZip64, 0);
            }
        }
        throw new IllegalArgumentException(String.format("Unknown Compression type %s", new Object[]{this.entryCompression}));
    }

    protected CopyAction createCopyAction() {
        DocumentationRegistry documentationRegistry = (DocumentationRegistry)this.getServices().get(DocumentationRegistry.class);
        return new ZipCopyAction(this.getArchivePath(), this.getCompressor(), documentationRegistry, this.encoding);
    }

    public ZipEntryCompression getEntryCompression() {
        return this.entryCompression;
    }

    public void setEntryCompression(ZipEntryCompression entryCompression) {
        this.entryCompression = entryCompression;
    }

    @Incubating
    public void setZip64(boolean allowZip64) {
        this.allowZip64 = allowZip64;
    }

    @Incubating
    public boolean isZip64() {
        return this.allowZip64;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Deprecated
    protected class ZipCopyActionImpl {
        protected ZipCopyActionImpl() {
        }
    }
}

