/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.maven;

import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.LifecycleExecutionPlanCalculator;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.version.DefaultPluginVersionRequest;
import org.apache.maven.plugin.version.PluginVersionRequest;
import org.apache.maven.plugin.version.PluginVersionResolver;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;

final class Maven {
    private final ConcurrentHashMap<File, AtomicNotNullLazyValue<MavenProject>> projectsCache = new ConcurrentHashMap();
    private final PlexusContainer plexusContainer;
    private final MavenSession session;
    private final BuildPluginManager pluginManager;
    private final ProjectBuilder projectBuilder;
    private final Date buildStartDate = new Date();

    public Maven(PlexusContainer plexusContainer, MavenSession session) throws ComponentLookupException {
        this.plexusContainer = plexusContainer;
        this.session = session;
        this.pluginManager = (BuildPluginManager)plexusContainer.lookup(BuildPluginManager.class);
        this.projectBuilder = (ProjectBuilder)plexusContainer.lookup(ProjectBuilder.class);
    }

    public MavenProject readProject(final File pomFile, final Logger logger) {
        AtomicNotNullLazyValue<MavenProject> candidate;
        AtomicNotNullLazyValue<MavenProject> projectRef = this.projectsCache.get(pomFile);
        if (projectRef == null && (candidate = this.projectsCache.putIfAbsent(pomFile, projectRef = new AtomicNotNullLazyValue<MavenProject>(){

            @Override
            protected MavenProject compute() {
                ProjectBuildingRequest projectBuildingRequest = Maven.this.session.getRequest().getProjectBuildingRequest();
                projectBuildingRequest.setResolveDependencies(true);
                projectBuildingRequest.setValidationLevel(0);
                projectBuildingRequest.setRepositorySession(Maven.this.session.getRepositorySession());
                projectBuildingRequest.setBuildStartTime(Maven.this.buildStartDate);
                try {
                    return Maven.this.projectBuilder.build(pomFile, projectBuildingRequest).getProject();
                }
                catch (Throwable e) {
                    logger.error("Cannot read project " + pomFile.getPath(), e);
                    return null;
                }
            }
        })) != null) {
            projectRef = candidate;
        }
        return projectRef.getValue();
    }

    public MojoExecution createMojoExecution(Plugin plugin, String goal, MavenProject project) throws Exception {
        if (plugin.getVersion() == null) {
            plugin.setVersion(((PluginVersionResolver)this.plexusContainer.lookup(PluginVersionResolver.class)).resolve((PluginVersionRequest)new DefaultPluginVersionRequest(plugin, this.session)).getVersion());
        }
        MojoDescriptor mojoDescriptor = this.pluginManager.getMojoDescriptor(plugin, goal, project.getRemotePluginRepositories(), this.session.getRepositorySession());
        List executions = plugin.getExecutions();
        MojoExecution mojoExecution = new MojoExecution(mojoDescriptor, executions.isEmpty() ? null : ((PluginExecution)executions.get(executions.size() - 1)).getId(), MojoExecution.Source.CLI);
        ((LifecycleExecutionPlanCalculator)this.plexusContainer.lookup(LifecycleExecutionPlanCalculator.class)).setupMojoExecution(this.session, project, mojoExecution);
        return mojoExecution;
    }

    public synchronized void releaseMojoExecution(MojoExecution mojoExecution) throws Exception {
    }

    public ClassRealm getPluginRealm(MojoExecution mojoExecution) throws PluginManagerException, PluginResolutionException {
        return this.pluginManager.getPluginRealm(this.session, mojoExecution.getMojoDescriptor().getPluginDescriptor());
    }

    private abstract class AtomicNotNullLazyValue<T> {
        private volatile T myValue;

        private AtomicNotNullLazyValue() {
        }

        protected abstract T compute();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final T getValue() {
            T value = this.myValue;
            if (value != null) {
                return value;
            }
            AtomicNotNullLazyValue atomicNotNullLazyValue = this;
            synchronized (atomicNotNullLazyValue) {
                value = this.myValue;
                if (value == null) {
                    this.myValue = value = this.compute();
                }
            }
            return value;
        }
    }
}

