/*
 * Decompiled with CFR 0.152.
 */
package git4idea.annotate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspectAdapter;
import com.intellij.openapi.vcs.annotate.ShowAllAffectedGenericAction;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitVcs;
import git4idea.i18n.GitBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitFileAnnotation
extends FileAnnotation {
    private final Project myProject;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final GitVcs myVcs;
    @Nullable
    private final VcsRevisionNumber myBaseRevision;
    @NotNull
    private final List<LineInfo> myLines;
    @Nullable
    private List<VcsFileRevision> myRevisions;
    private final LineAnnotationAspect DATE_ASPECT;
    private final LineAnnotationAspect REVISION_ASPECT;
    private final LineAnnotationAspect AUTHOR_ASPECT;

    public GitFileAnnotation(@NotNull Project project, @NotNull VirtualFile file, @Nullable VcsRevisionNumber revision, @NotNull List<LineInfo> lines) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/annotate/GitFileAnnotation", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/annotate/GitFileAnnotation", "<init>"));
        }
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "git4idea/annotate/GitFileAnnotation", "<init>"));
        }
        super(project);
        this.DATE_ASPECT = new GitAnnotationAspect(LineAnnotationAspect.DATE, true){

            @Override
            public String doGetValue(LineInfo info) {
                return DateFormatUtil.formatPrettyDate((Date)info.getDate());
            }
        };
        this.REVISION_ASPECT = new GitAnnotationAspect(LineAnnotationAspect.REVISION, false){

            @Override
            protected String doGetValue(LineInfo lineInfo) {
                return String.valueOf(lineInfo.getRevisionNumber().getShortRev());
            }
        };
        this.AUTHOR_ASPECT = new GitAnnotationAspect(LineAnnotationAspect.AUTHOR, true){

            @Override
            protected String doGetValue(LineInfo lineInfo) {
                return lineInfo.getAuthor();
            }
        };
        this.myProject = project;
        this.myFile = file;
        this.myVcs = (GitVcs)((Object)ObjectUtils.assertNotNull((Object)((Object)GitVcs.getInstance(this.myProject))));
        this.myBaseRevision = revision;
        this.myLines = lines;
    }

    public void dispose() {
    }

    public LineAnnotationAspect[] getAspects() {
        return new LineAnnotationAspect[]{this.REVISION_ASPECT, this.DATE_ASPECT, this.AUTHOR_ASPECT};
    }

    @Nullable
    public String getAnnotatedContent() {
        try {
            ContentRevision revision = GitContentRevision.createRevision(this.myFile, this.myBaseRevision, this.myProject);
            return revision.getContent();
        }
        catch (VcsException e) {
            return null;
        }
    }

    public List<VcsFileRevision> getRevisions() {
        return this.myRevisions;
    }

    public void setRevisions(@NotNull List<VcsFileRevision> revisions) {
        if (revisions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisions", "git4idea/annotate/GitFileAnnotation", "setRevisions"));
        }
        this.myRevisions = revisions;
    }

    public int getLineCount() {
        return this.myLines.size();
    }

    @Nullable
    public LineInfo getLineInfo(int lineNumber) {
        if (this.lineNumberCheck(lineNumber)) {
            return null;
        }
        return this.myLines.get(lineNumber);
    }

    @Nullable
    public String getToolTip(int lineNumber) {
        LineInfo lineInfo = this.getLineInfo(lineNumber);
        return lineInfo != null ? lineInfo.getTooltip() : null;
    }

    @Nullable
    public VcsRevisionNumber getLineRevisionNumber(int lineNumber) {
        LineInfo lineInfo = this.getLineInfo(lineNumber);
        return lineInfo != null ? lineInfo.getRevisionNumber() : null;
    }

    @Nullable
    public Date getLineDate(int lineNumber) {
        LineInfo lineInfo = this.getLineInfo(lineNumber);
        return lineInfo != null ? lineInfo.getDate() : null;
    }

    private boolean lineNumberCheck(int lineNumber) {
        return this.myLines.size() <= lineNumber || lineNumber < 0;
    }

    @NotNull
    public List<LineInfo> getLines() {
        List<LineInfo> list = this.myLines;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/annotate/GitFileAnnotation", "getLines"));
        }
        return list;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/annotate/GitFileAnnotation", "getFile"));
        }
        return virtualFile;
    }

    @Nullable
    public VcsRevisionNumber getCurrentRevision() {
        return this.myBaseRevision;
    }

    public VcsKey getVcsKey() {
        return GitVcs.getKey();
    }

    public boolean isBaseRevisionChanged(VcsRevisionNumber number) {
        VcsRevisionNumber currentCurrentRevision = this.myVcs.getDiffProvider().getCurrentRevision(this.myFile);
        return this.myBaseRevision != null && !this.myBaseRevision.equals(currentCurrentRevision);
    }

    @Nullable
    public FileAnnotation.CurrentFileRevisionProvider getCurrentFileRevisionProvider() {
        return lineNumber -> {
            LineInfo lineInfo = this.getLineInfo(lineNumber);
            return lineInfo != null ? lineInfo.getFileRevision() : null;
        };
    }

    @Nullable
    public FileAnnotation.PreviousFileRevisionProvider getPreviousFileRevisionProvider() {
        return new FileAnnotation.PreviousFileRevisionProvider(){

            @Nullable
            public VcsFileRevision getPreviousRevision(int lineNumber) {
                LineInfo lineInfo = GitFileAnnotation.this.getLineInfo(lineNumber);
                return lineInfo != null ? lineInfo.getPreviousFileRevision() : null;
            }

            @Nullable
            public VcsFileRevision getLastRevision() {
                if (GitFileAnnotation.this.myBaseRevision instanceof GitRevisionNumber) {
                    return new GitFileRevision(GitFileAnnotation.this.myProject, VcsUtil.getFilePath((VirtualFile)GitFileAnnotation.this.myFile), (GitRevisionNumber)GitFileAnnotation.this.myBaseRevision);
                }
                return (VcsFileRevision)ContainerUtil.getFirstItem(GitFileAnnotation.this.getRevisions());
            }
        };
    }

    @Nullable
    public FileAnnotation.AuthorsMappingProvider getAuthorsMappingProvider() {
        HashMap authorsMap = new HashMap();
        for (int i = 0; i < this.getLineCount(); ++i) {
            LineInfo lineInfo = this.getLineInfo(i);
            if (lineInfo == null || authorsMap.containsKey(lineInfo.getRevisionNumber())) continue;
            authorsMap.put(lineInfo.getRevisionNumber(), lineInfo.getAuthor());
        }
        return () -> GitFileAnnotation.lambda$getAuthorsMappingProvider$1((Map)authorsMap);
    }

    @Nullable
    public FileAnnotation.RevisionsOrderProvider getRevisionsOrderProvider() {
        ContainerUtil.KeyOrderedMultiMap dates = new ContainerUtil.KeyOrderedMultiMap();
        for (int i = 0; i < this.getLineCount(); ++i) {
            LineInfo lineInfo = this.getLineInfo(i);
            if (lineInfo == null) continue;
            GitRevisionNumber number = lineInfo.getRevisionNumber();
            Date date = lineInfo.getDate();
            dates.putValue((Object)date, (Object)number);
        }
        ArrayList orderedRevisions = new ArrayList();
        NavigableSet orderedDates = dates.navigableKeySet();
        for (Date date : orderedDates.descendingSet()) {
            Collection revisionNumbers = dates.get((Object)date);
            orderedRevisions.add(new ArrayList(revisionNumbers));
        }
        return () -> orderedRevisions;
    }

    private static /* synthetic */ Map lambda$getAuthorsMappingProvider$1(Map authorsMap) {
        return authorsMap;
    }

    static class LineInfo {
        @NotNull
        private final Project myProject;
        @NotNull
        private final GitRevisionNumber myRevision;
        @NotNull
        private final FilePath myFilePath;
        @Nullable
        private final GitRevisionNumber myPreviousRevision;
        @Nullable
        private final FilePath myPreviousFilePath;
        @NotNull
        private final Date myDate;
        @NotNull
        private final VcsUser myAuthor;
        @NotNull
        private final String mySubject;

        public LineInfo(@NotNull Project project, @NotNull GitRevisionNumber revision, @NotNull FilePath path, @NotNull Date date, @NotNull VcsUser author, @NotNull String subject, @Nullable GitRevisionNumber previousRevision, @Nullable FilePath previousPath) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/annotate/GitFileAnnotation$LineInfo", "<init>"));
            }
            if (revision == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "git4idea/annotate/GitFileAnnotation$LineInfo", "<init>"));
            }
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/annotate/GitFileAnnotation$LineInfo", "<init>"));
            }
            if (date == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "date", "git4idea/annotate/GitFileAnnotation$LineInfo", "<init>"));
            }
            if (author == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "author", "git4idea/annotate/GitFileAnnotation$LineInfo", "<init>"));
            }
            if (subject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subject", "git4idea/annotate/GitFileAnnotation$LineInfo", "<init>"));
            }
            this.myProject = project;
            this.myRevision = revision;
            this.myFilePath = path;
            this.myPreviousRevision = previousRevision;
            this.myPreviousFilePath = previousPath;
            this.myDate = date;
            this.myAuthor = author;
            this.mySubject = subject;
        }

        @NotNull
        public GitRevisionNumber getRevisionNumber() {
            GitRevisionNumber gitRevisionNumber = this.myRevision;
            if (gitRevisionNumber == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/annotate/GitFileAnnotation$LineInfo", "getRevisionNumber"));
            }
            return gitRevisionNumber;
        }

        @NotNull
        public FilePath getFilePath() {
            FilePath filePath = this.myFilePath;
            if (filePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/annotate/GitFileAnnotation$LineInfo", "getFilePath"));
            }
            return filePath;
        }

        @NotNull
        public VcsFileRevision getFileRevision() {
            GitFileRevision gitFileRevision = new GitFileRevision(this.myProject, this.myFilePath, this.myRevision);
            if (gitFileRevision == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/annotate/GitFileAnnotation$LineInfo", "getFileRevision"));
            }
            return gitFileRevision;
        }

        @Nullable
        public VcsFileRevision getPreviousFileRevision() {
            if (this.myPreviousRevision == null || this.myPreviousFilePath == null) {
                return null;
            }
            return new GitFileRevision(this.myProject, this.myPreviousFilePath, this.myPreviousRevision);
        }

        @NotNull
        public Date getDate() {
            Date date = this.myDate;
            if (date == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/annotate/GitFileAnnotation$LineInfo", "getDate"));
            }
            return date;
        }

        @NotNull
        public String getAuthor() {
            String string = this.myAuthor.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/annotate/GitFileAnnotation$LineInfo", "getAuthor"));
            }
            return string;
        }

        @NotNull
        public String getTooltip() {
            String string = GitBundle.message("annotation.tool.tip", this.myRevision.asString(), this.myAuthor.getName(), DateFormatUtil.formatDateTime((Date)this.myDate), this.mySubject);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/annotate/GitFileAnnotation$LineInfo", "getTooltip"));
            }
            return string;
        }
    }

    private abstract class GitAnnotationAspect
    extends LineAnnotationAspectAdapter {
        public GitAnnotationAspect(String id, boolean showByDefault) {
            super(id, showByDefault);
        }

        public String getValue(int lineNumber) {
            if (GitFileAnnotation.this.lineNumberCheck(lineNumber)) {
                return "";
            }
            return this.doGetValue((LineInfo)GitFileAnnotation.this.myLines.get(lineNumber));
        }

        protected abstract String doGetValue(LineInfo var1);

        protected void showAffectedPaths(int lineNum) {
            if (lineNum >= 0 && lineNum < GitFileAnnotation.this.myLines.size()) {
                LineInfo info = (LineInfo)GitFileAnnotation.this.myLines.get(lineNum);
                ShowAllAffectedGenericAction.showSubmittedFiles((Project)GitFileAnnotation.this.myProject, (VcsRevisionNumber)info.getRevisionNumber(), (VirtualFile)GitFileAnnotation.this.myFile, (VcsKey)GitVcs.getKey());
            }
        }
    }
}

