/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.CommonBundle;
import com.intellij.dvcs.AmendComponent;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.ui.VcsPushDialog;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.SelectFilePathsDialog;
import com.intellij.openapi.vcs.checkin.CheckinChangeListSpecificComponent;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.FunctionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.textCompletion.DefaultTextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.textCompletion.ValuesCompletionProvider;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUserRegistry;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.checkin.GitCommitAuthorCorrector;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersionSpecialty;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitFileUtils;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCheckinEnvironment
implements CheckinEnvironment {
    private static final Logger LOG = Logger.getInstance(GitCheckinEnvironment.class);
    @NonNls
    private static final String GIT_COMMIT_MSG_FILE_PREFIX = "git-commit-msg-";
    @NonNls
    private static final String GIT_COMMIT_MSG_FILE_EXT = ".txt";
    private final Project myProject;
    public static final SimpleDateFormat COMMIT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final VcsDirtyScopeManager myDirtyScopeManager;
    private final GitVcsSettings mySettings;
    private String myNextCommitAuthor;
    private boolean myNextCommitAmend;
    private Boolean myNextCommitIsPushed;
    private Date myNextCommitAuthorDate;
    private boolean myNextCommitSignOff;

    public GitCheckinEnvironment(@NotNull Project project, @NotNull VcsDirtyScopeManager dirtyScopeManager, GitVcsSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/checkin/GitCheckinEnvironment", "<init>"));
        }
        if (dirtyScopeManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirtyScopeManager", "git4idea/checkin/GitCheckinEnvironment", "<init>"));
        }
        this.myNextCommitAuthor = null;
        this.myNextCommitIsPushed = null;
        this.myProject = project;
        this.myDirtyScopeManager = dirtyScopeManager;
        this.mySettings = settings;
    }

    public boolean keepChangeListAfterCommit(ChangeList changeList) {
        return false;
    }

    public boolean isRefreshAfterCommitNeeded() {
        return true;
    }

    @Nullable
    public RefreshableOnComponent createAdditionalOptionsPanel(CheckinProjectPanel panel, PairConsumer<Object, Object> additionalDataConsumer) {
        return new GitCheckinOptions(this.myProject, panel);
    }

    @Nullable
    public String getDefaultMessageFor(FilePath[] filesToCheckin) {
        LinkedHashSet messages = ContainerUtil.newLinkedHashSet();
        GitRepositoryManager manager = GitUtil.getRepositoryManager(this.myProject);
        for (VirtualFile root : GitUtil.gitRoots(Arrays.asList(filesToCheckin))) {
            GitRepository repository = (GitRepository)manager.getRepositoryForRoot(root);
            if (repository == null) {
                LOG.warn("Unregistered repository: " + root);
                continue;
            }
            File mergeMsg = repository.getRepositoryFiles().getMergeMessageFile();
            File squashMsg = repository.getRepositoryFiles().getSquashMessageFile();
            try {
                if (!mergeMsg.exists() && !squashMsg.exists()) continue;
                String encoding = GitConfigUtil.getCommitEncoding(this.myProject, root);
                if (mergeMsg.exists()) {
                    messages.add(GitCheckinEnvironment.loadMessage(mergeMsg, encoding));
                    continue;
                }
                messages.add(GitCheckinEnvironment.loadMessage(squashMsg, encoding));
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Unable to load merge message", (Throwable)e);
            }
        }
        return DvcsUtil.joinMessagesOrNull((Collection)messages);
    }

    private static String loadMessage(@NotNull File messageFile, @NotNull String encoding) throws IOException {
        if (messageFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageFile", "git4idea/checkin/GitCheckinEnvironment", "loadMessage"));
        }
        if (encoding == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "encoding", "git4idea/checkin/GitCheckinEnvironment", "loadMessage"));
        }
        return FileUtil.loadFile((File)messageFile, (String)encoding);
    }

    public String getHelpId() {
        return null;
    }

    public String getCheckinOperationName() {
        return GitBundle.getString("commit.action.name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VcsException> commit(@NotNull List<Change> changes, @NotNull String message, @NotNull NullableFunction<Object, Object> parametersHolder, Set<String> feedback) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "git4idea/checkin/GitCheckinEnvironment", "commit"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "git4idea/checkin/GitCheckinEnvironment", "commit"));
        }
        if (parametersHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parametersHolder", "git4idea/checkin/GitCheckinEnvironment", "commit"));
        }
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        Map<VirtualFile, Collection<Change>> sortedChanges = GitCheckinEnvironment.sortChangesByGitRoot(changes, exceptions);
        LOG.assertTrue(!sortedChanges.isEmpty(), (Object)("Trying to commit an empty list of changes: " + changes));
        for (Map.Entry<VirtualFile, Collection<Change>> entry : sortedChanges.entrySet()) {
            File messageFile;
            VirtualFile root = entry.getKey();
            try {
                messageFile = this.createMessageFile(root, message);
            }
            catch (IOException ex) {
                exceptions.add(new VcsException("Creation of commit message file failed", (Throwable)ex));
                continue;
            }
            HashSet<FilePath> added = new HashSet<FilePath>();
            HashSet<FilePath> removed = new HashSet<FilePath>();
            HashSet<Change> caseOnlyRenames = new HashSet<Change>();
            block15: for (Change change : entry.getValue()) {
                switch (change.getType()) {
                    case NEW: 
                    case MODIFICATION: {
                        added.add(change.getAfterRevision().getFile());
                        continue block15;
                    }
                    case DELETED: {
                        removed.add(change.getBeforeRevision().getFile());
                        continue block15;
                    }
                    case MOVED: {
                        FilePath afterPath = change.getAfterRevision().getFile();
                        FilePath beforePath = change.getBeforeRevision().getFile();
                        if (!SystemInfo.isFileSystemCaseSensitive && GitUtil.isCaseOnlyChange(beforePath.getPath(), afterPath.getPath())) {
                            caseOnlyRenames.add(change);
                            continue block15;
                        }
                        added.add(afterPath);
                        removed.add(beforePath);
                        continue block15;
                    }
                }
                throw new IllegalStateException("Unknown change type: " + change.getType());
            }
            try {
                if (!caseOnlyRenames.isEmpty()) {
                    List<VcsException> exs = this.commitWithCaseOnlyRename(this.myProject, root, caseOnlyRenames, added, removed, messageFile, this.myNextCommitAuthor);
                    exceptions.addAll(ContainerUtil.map(exs, GitCheckinEnvironment::cleanupExceptionText));
                    continue;
                }
                try {
                    HashSet<FilePath> files = new HashSet<FilePath>();
                    files.addAll(added);
                    files.addAll(removed);
                    this.commit(this.myProject, root, files, messageFile);
                }
                catch (VcsException ex) {
                    PartialOperation partialOperation = GitCheckinEnvironment.isMergeCommit(ex);
                    if (partialOperation == PartialOperation.NONE) {
                        throw ex;
                    }
                    if (this.mergeCommit(this.myProject, root, added, removed, messageFile, this.myNextCommitAuthor, exceptions, partialOperation)) continue;
                    throw ex;
                }
            }
            catch (VcsException e) {
                exceptions.add(GitCheckinEnvironment.cleanupExceptionText(e));
            }
            finally {
                if (messageFile.delete()) continue;
                LOG.warn("Failed to remove temporary file: " + messageFile);
            }
        }
        if (this.myNextCommitIsPushed != null && this.myNextCommitIsPushed.booleanValue() && exceptions.isEmpty()) {
            GitRepositoryManager manager = GitUtil.getRepositoryManager(this.myProject);
            Collection<GitRepository> repositories = GitUtil.getRepositoriesFromRoots(manager, sortedChanges.keySet());
            ArrayList preselectedRepositories = ContainerUtil.newArrayList(repositories);
            GuiUtils.invokeLaterIfNeeded(() -> new VcsPushDialog(this.myProject, preselectedRepositories, (Repository)GitBranchUtil.getCurrentRepository(this.myProject)).show(), (ModalityState)ModalityState.defaultModalityState());
        }
        return exceptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private List<VcsException> commitWithCaseOnlyRename(@NotNull Project project, @NotNull VirtualFile root, @NotNull Set<Change> caseOnlyRenames, @NotNull Set<FilePath> added, @NotNull Set<FilePath> removed, @NotNull File messageFile, @Nullable String author) {
        Collection<Change> stagedChanges;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/checkin/GitCheckinEnvironment", "commitWithCaseOnlyRename"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/checkin/GitCheckinEnvironment", "commitWithCaseOnlyRename"));
        }
        if (caseOnlyRenames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caseOnlyRenames", "git4idea/checkin/GitCheckinEnvironment", "commitWithCaseOnlyRename"));
        }
        if (added == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "added", "git4idea/checkin/GitCheckinEnvironment", "commitWithCaseOnlyRename"));
        }
        if (removed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "removed", "git4idea/checkin/GitCheckinEnvironment", "commitWithCaseOnlyRename"));
        }
        if (messageFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageFile", "git4idea/checkin/GitCheckinEnvironment", "commitWithCaseOnlyRename"));
        }
        String rootPath = root.getPath();
        LOG.info("Committing case only rename: " + GitUtil.getLogString(rootPath, caseOnlyRenames) + " in " + DvcsUtil.getShortRepositoryName((Project)project, (VirtualFile)root));
        try {
            stagedChanges = GitChangeUtils.getStagedChanges(project, root);
            LOG.debug("Found staged changes: " + GitUtil.getLogString(rootPath, stagedChanges));
        }
        catch (VcsException e) {
            List<VcsException> list = Collections.singletonList(e);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkin/GitCheckinEnvironment", "commitWithCaseOnlyRename"));
            }
            return list;
        }
        List excludedStagedChanges = ContainerUtil.filter(stagedChanges, change -> {
            if (caseOnlyRenames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caseOnlyRenames", "git4idea/checkin/GitCheckinEnvironment", "lambda$commitWithCaseOnlyRename$1"));
            }
            if (added == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "added", "git4idea/checkin/GitCheckinEnvironment", "lambda$commitWithCaseOnlyRename$1"));
            }
            if (removed == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "removed", "git4idea/checkin/GitCheckinEnvironment", "lambda$commitWithCaseOnlyRename$1"));
            }
            return !caseOnlyRenames.contains(change) && !added.contains(ChangesUtil.getAfterPath((Change)change)) && !removed.contains(ChangesUtil.getBeforePath((Change)change));
        });
        if (!excludedStagedChanges.isEmpty()) {
            LOG.info("Staged changes excluded for commit: " + GitUtil.getLogString(rootPath, excludedStagedChanges));
            try {
                GitCheckinEnvironment.reset(project, root, excludedStagedChanges);
            }
            catch (VcsException e) {
                List<VcsException> list = Collections.singletonList(e);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkin/GitCheckinEnvironment", "commitWithCaseOnlyRename"));
                }
                return list;
            }
        }
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        try {
            List newPathsOfCaseRenames = ContainerUtil.map(caseOnlyRenames, ChangesUtil::getAfterPath);
            LOG.debug("Updating index for added:" + added + "\n, removed: " + removed + "\n, and case-renames: " + newPathsOfCaseRenames);
            HashSet<FilePath> toAdd = new HashSet<FilePath>(added);
            toAdd.addAll(newPathsOfCaseRenames);
            GitCheckinEnvironment.updateIndex(project, root, toAdd, removed, exceptions);
            if (!exceptions.isEmpty()) {
                ArrayList<VcsException> arrayList = exceptions;
                ArrayList<VcsException> arrayList2 = arrayList;
                if (arrayList2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkin/GitCheckinEnvironment", "commitWithCaseOnlyRename"));
                }
                return arrayList2;
            }
            LOG.debug("Performing commit...");
            try {
                this.commitWithoutPaths(project, root, messageFile, author);
            }
            catch (VcsException e) {
                List<VcsException> list = Collections.singletonList(e);
                if (!excludedStagedChanges.isEmpty()) {
                    LOG.debug("Restoring changes which were unstaged before commit: " + GitUtil.getLogString(rootPath, excludedStagedChanges));
                    Set toAdd2 = ContainerUtil.map2SetNotNull((Collection)excludedStagedChanges, ChangesUtil::getAfterPath);
                    Condition isMovedOrDeleted = change -> change.getType() == Change.Type.MOVED || change.getType() == Change.Type.DELETED;
                    Set toRemove = ContainerUtil.map2SetNotNull((Collection)ContainerUtil.filter((Collection)excludedStagedChanges, (Condition)isMovedOrDeleted), ChangesUtil::getBeforePath);
                    GitCheckinEnvironment.updateIndex(project, root, toAdd2, toRemove, exceptions);
                }
                List<VcsException> list2 = list;
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkin/GitCheckinEnvironment", "commitWithCaseOnlyRename"));
                }
                return list2;
            }
        }
        finally {
            if (!excludedStagedChanges.isEmpty()) {
                LOG.debug("Restoring changes which were unstaged before commit: " + GitUtil.getLogString(rootPath, excludedStagedChanges));
                Set toAdd = ContainerUtil.map2SetNotNull((Collection)excludedStagedChanges, ChangesUtil::getAfterPath);
                Condition isMovedOrDeleted = change -> change.getType() == Change.Type.MOVED || change.getType() == Change.Type.DELETED;
                Set toRemove = ContainerUtil.map2SetNotNull((Collection)ContainerUtil.filter((Collection)excludedStagedChanges, (Condition)isMovedOrDeleted), ChangesUtil::getBeforePath);
                GitCheckinEnvironment.updateIndex(project, root, toAdd, toRemove, exceptions);
            }
        }
        ArrayList<VcsException> arrayList = exceptions;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkin/GitCheckinEnvironment", "commitWithCaseOnlyRename"));
        }
        return arrayList;
    }

    private static void reset(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<Change> changes) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/checkin/GitCheckinEnvironment", "reset"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/checkin/GitCheckinEnvironment", "reset"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "git4idea/checkin/GitCheckinEnvironment", "reset"));
        }
        HashSet<FilePath> paths = new HashSet<FilePath>();
        paths.addAll(ContainerUtil.mapNotNull(changes, ChangesUtil::getAfterPath));
        paths.addAll(ContainerUtil.mapNotNull(changes, ChangesUtil::getBeforePath));
        GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.RESET);
        handler.endOptions();
        handler.addRelativePaths(paths);
        handler.run();
    }

    @NotNull
    private static VcsException cleanupExceptionText(VcsException original) {
        String msg = original.getMessage();
        msg = GitUtil.cleanupErrorPrefixes(msg);
        String DURING_EXECUTING_SUFFIX = "during executing";
        int suffix = msg.indexOf("during executing");
        if (suffix > 0) {
            msg = msg.substring(0, suffix);
        }
        VcsException vcsException = new VcsException(msg.trim(), original.getCause());
        if (vcsException == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkin/GitCheckinEnvironment", "cleanupExceptionText"));
        }
        return vcsException;
    }

    public List<VcsException> commit(List<Change> changes, String preparedComment) {
        return this.commit(changes, preparedComment, (NullableFunction<Object, Object>)FunctionUtil.nullConstant(), null);
    }

    private boolean mergeCommit(final Project project, VirtualFile root, Set<FilePath> added, Set<FilePath> removed, File messageFile, String author, List<VcsException> exceptions, final @NotNull PartialOperation partialOperation) {
        String output;
        if (partialOperation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partialOperation", "git4idea/checkin/GitCheckinEnvironment", "mergeCommit"));
        }
        HashSet<FilePath> realAdded = new HashSet<FilePath>();
        HashSet<FilePath> realRemoved = new HashSet<FilePath>();
        GitSimpleHandler diff = new GitSimpleHandler(project, root, GitCommand.DIFF);
        diff.setSilent(true);
        diff.setStdoutSuppressed(true);
        diff.addParameters("--diff-filter=ADMRUX", "--name-status", "--no-renames", "HEAD");
        diff.endOptions();
        try {
            output = diff.run();
        }
        catch (VcsException ex) {
            exceptions.add(ex);
            return false;
        }
        String rootPath = root.getPath();
        StringTokenizer lines = new StringTokenizer(output, "\n", false);
        block11: while (lines.hasMoreTokens()) {
            String line = lines.nextToken().trim();
            if (line.length() == 0) continue;
            String[] tk = line.split("\t");
            switch (tk[0].charAt(0)) {
                case 'A': 
                case 'M': {
                    realAdded.add(VcsUtil.getFilePath((String)(rootPath + "/" + tk[1])));
                    continue block11;
                }
                case 'D': {
                    realRemoved.add(VcsUtil.getFilePathForDeletedFile((String)(rootPath + "/" + tk[1]), (boolean)false));
                    continue block11;
                }
            }
            throw new IllegalStateException("Unexpected status: " + line);
        }
        realAdded.removeAll(added);
        realRemoved.removeAll(removed);
        if (realAdded.size() != 0 || realRemoved.size() != 0) {
            final ArrayList<FilePath> files = new ArrayList<FilePath>();
            files.addAll(realAdded);
            files.addAll(realRemoved);
            final Ref mergeAll = new Ref();
            try {
                GuiUtils.runOrInvokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        String message = GitBundle.message("commit.partial.merge.message", partialOperation.getName());
                        SelectFilePathsDialog dialog = new SelectFilePathsDialog(project, files, message, null, "Commit All Files", CommonBundle.getCancelButtonText(), false);
                        dialog.setTitle(GitBundle.getString("commit.partial.merge.title"));
                        dialog.show();
                        mergeAll.set((Object)dialog.isOK());
                    }
                });
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to invoke a message box on AWT thread", ex);
            }
            if (!((Boolean)mergeAll.get()).booleanValue()) {
                return false;
            }
            if (!GitCheckinEnvironment.updateIndex(project, root, realAdded, realRemoved, exceptions)) {
                return false;
            }
            for (FilePath f : realAdded) {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(f);
            }
            for (FilePath f : realRemoved) {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(f);
            }
        }
        try {
            this.commitWithoutPaths(project, root, messageFile, author);
            GitRepositoryManager manager = GitUtil.getRepositoryManager(project);
            manager.updateRepository(root);
        }
        catch (VcsException ex) {
            exceptions.add(ex);
            return false;
        }
        return true;
    }

    private void commitWithoutPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull File messageFile, @Nullable String author) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/checkin/GitCheckinEnvironment", "commitWithoutPaths"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/checkin/GitCheckinEnvironment", "commitWithoutPaths"));
        }
        if (messageFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageFile", "git4idea/checkin/GitCheckinEnvironment", "commitWithoutPaths"));
        }
        GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.COMMIT);
        handler.setStdoutSuppressed(false);
        handler.addParameters("-F", messageFile.getAbsolutePath());
        if (author != null) {
            handler.addParameters("--author=" + author);
        }
        if (this.myNextCommitSignOff) {
            handler.addParameters("--signoff");
        }
        handler.endOptions();
        handler.run();
    }

    private static PartialOperation isMergeCommit(VcsException ex) {
        String message = ex.getMessage();
        if (message.contains("fatal: cannot do a partial commit during a merge")) {
            return PartialOperation.MERGE;
        }
        if (message.contains("fatal: cannot do a partial commit during a cherry-pick")) {
            return PartialOperation.CHERRY_PICK;
        }
        return PartialOperation.NONE;
    }

    private static boolean updateIndex(Project project, VirtualFile root, Collection<FilePath> added, Collection<FilePath> removed, List<VcsException> exceptions) {
        boolean rc = true;
        if (!added.isEmpty()) {
            try {
                GitFileUtils.addPaths(project, root, added);
            }
            catch (VcsException ex) {
                exceptions.add(ex);
                rc = false;
            }
        }
        if (!removed.isEmpty()) {
            try {
                GitFileUtils.delete(project, root, removed, "--ignore-unmatch");
            }
            catch (VcsException ex) {
                exceptions.add(ex);
                rc = false;
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createMessageFile(VirtualFile root, String message) throws IOException {
        File file = FileUtil.createTempFile((String)GIT_COMMIT_MSG_FILE_PREFIX, (String)GIT_COMMIT_MSG_FILE_EXT);
        file.deleteOnExit();
        String encoding = GitConfigUtil.getCommitEncoding(this.myProject, root);
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);){
            out.write(message);
        }
        return file;
    }

    public List<VcsException> scheduleMissingFileForDeletion(List<FilePath> files) {
        Map<VirtualFile, List<FilePath>> sortedFiles;
        ArrayList<VcsException> rc = new ArrayList<VcsException>();
        try {
            sortedFiles = GitUtil.sortFilePathsByGitRoot(files);
        }
        catch (VcsException e) {
            rc.add(e);
            return rc;
        }
        for (Map.Entry<VirtualFile, List<FilePath>> e : sortedFiles.entrySet()) {
            try {
                VirtualFile root = e.getKey();
                GitFileUtils.delete(this.myProject, root, (Collection<FilePath>)e.getValue(), new String[0]);
                this.markRootDirty(root);
            }
            catch (VcsException ex) {
                rc.add(ex);
            }
        }
        return rc;
    }

    private void commit(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<FilePath> files, @NotNull File message) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/checkin/GitCheckinEnvironment", "commit"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/checkin/GitCheckinEnvironment", "commit"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "git4idea/checkin/GitCheckinEnvironment", "commit"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "git4idea/checkin/GitCheckinEnvironment", "commit"));
        }
        boolean amend = this.myNextCommitAmend;
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.COMMIT);
            handler.setStdoutSuppressed(false);
            if (this.myNextCommitSignOff) {
                handler.addParameters("--signoff");
            }
            if (amend) {
                handler.addParameters("--amend");
            } else {
                amend = true;
            }
            handler.addParameters("--only", "-F", message.getAbsolutePath());
            if (this.myNextCommitAuthor != null) {
                handler.addParameters("--author=" + this.myNextCommitAuthor);
            }
            if (this.myNextCommitAuthorDate != null) {
                handler.addParameters("--date", COMMIT_DATE_FORMAT.format(this.myNextCommitAuthorDate));
            }
            handler.endOptions();
            handler.addParameters(paths);
            handler.run();
        }
        if (!project.isDisposed()) {
            GitRepositoryManager manager = GitUtil.getRepositoryManager(project);
            manager.updateRepository(root);
        }
    }

    public List<VcsException> scheduleUnversionedFilesForAddition(List<VirtualFile> files) {
        Map<VirtualFile, List<VirtualFile>> sortedFiles;
        ArrayList<VcsException> rc = new ArrayList<VcsException>();
        try {
            sortedFiles = GitUtil.sortFilesByGitRoot(files);
        }
        catch (VcsException e) {
            rc.add(e);
            return rc;
        }
        for (Map.Entry<VirtualFile, List<VirtualFile>> e : sortedFiles.entrySet()) {
            try {
                VirtualFile root = e.getKey();
                GitFileUtils.addFiles(this.myProject, root, (Collection<VirtualFile>)e.getValue());
                this.markRootDirty(root);
            }
            catch (VcsException ex) {
                rc.add(ex);
            }
        }
        return rc;
    }

    private static Map<VirtualFile, Collection<Change>> sortChangesByGitRoot(@NotNull List<Change> changes, List<VcsException> exceptions) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "git4idea/checkin/GitCheckinEnvironment", "sortChangesByGitRoot"));
        }
        HashMap<VirtualFile, Collection<Change>> result = new HashMap<VirtualFile, Collection<Change>>();
        for (Change change : changes) {
            VirtualFile vcsRoot;
            ContentRevision afterRevision = change.getAfterRevision();
            ContentRevision beforeRevision = change.getBeforeRevision();
            assert (beforeRevision != null || afterRevision != null);
            FilePath filePath = afterRevision != null ? afterRevision.getFile() : beforeRevision.getFile();
            try {
                vcsRoot = GitUtil.getGitRoot(filePath.getParentPath());
            }
            catch (VcsException e) {
                exceptions.add(e);
                continue;
            }
            ArrayList<Change> changeList = (ArrayList<Change>)result.get(vcsRoot);
            if (changeList == null) {
                changeList = new ArrayList<Change>();
                result.put(vcsRoot, changeList);
            }
            changeList.add(change);
        }
        return result;
    }

    private void markRootDirty(VirtualFile root) {
        this.myDirtyScopeManager.dirDirtyRecursively(root);
    }

    public void reset() {
        this.myNextCommitAmend = false;
        this.myNextCommitAuthor = null;
        this.myNextCommitIsPushed = null;
        this.myNextCommitAuthorDate = null;
    }

    public void setNextCommitIsPushed(Boolean nextCommitIsPushed) {
        this.myNextCommitIsPushed = nextCommitIsPushed;
    }

    private class GitCheckinOptions
    implements CheckinChangeListSpecificComponent,
    RefreshableOnComponent {
        @NotNull
        private final GitVcs myVcs;
        @NotNull
        private JPanel myPanel;
        @NotNull
        private final EditorTextField myAuthorField;
        @Nullable
        private Date myAuthorDate;
        @NotNull
        private AmendComponent myAmendComponent;
        @NotNull
        private final JCheckBox mySignOffCheckbox;

        GitCheckinOptions(@NotNull Project project, CheckinProjectPanel panel) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions", "<init>"));
            }
            if (panel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions", "<init>"));
            }
            this.myVcs = (GitVcs)((Object)ObjectUtils.assertNotNull((Object)((Object)GitVcs.getInstance(project))));
            this.myAuthorField = this.createTextField(project, this.getAuthors(project));
            this.myAuthorField.setToolTipText(GitBundle.getString("commit.author.tooltip"));
            JBLabel authorLabel = new JBLabel(GitBundle.message("commit.author", new Object[0]));
            authorLabel.setLabelFor((Component)this.myAuthorField);
            this.myAmendComponent = new MyAmendComponent(project, GitUtil.getRepositoryManager(project), panel);
            this.mySignOffCheckbox = new JBCheckBox("Sign-off commit", GitCheckinEnvironment.this.mySettings.shouldSignOffCommit());
            this.mySignOffCheckbox.setMnemonic(71);
            this.mySignOffCheckbox.setToolTipText(this.getToolTip(project, panel));
            GridBag gb = new GridBag().setDefaultAnchor(17).setDefaultInsets((Insets)JBUI.insets((int)2));
            this.myPanel = new JPanel(new GridBagLayout());
            this.myPanel.add((Component)authorLabel, gb.nextLine().next());
            this.myPanel.add((Component)this.myAuthorField, gb.next().fillCellHorizontally().weightx(1.0));
            this.myPanel.add(this.myAmendComponent.getComponent(), gb.nextLine().next().coverLine());
            this.myPanel.add((Component)this.mySignOffCheckbox, gb.nextLine().next().coverLine());
        }

        @NotNull
        private String getToolTip(@NotNull Project project, @NotNull CheckinProjectPanel panel) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions", "getToolTip"));
            }
            if (panel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions", "getToolTip"));
            }
            VcsUser user = (VcsUser)ContainerUtil.getFirstItem((List)ContainerUtil.mapNotNull((Collection)panel.getRoots(), it -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions", "lambda$getToolTip$0"));
                }
                return GitUserRegistry.getInstance(project).getUser((VirtualFile)it);
            }));
            String signature = user != null ? StringUtil.escapeXml((String)VcsUserUtil.toExactString((VcsUser)user)) : "";
            String string = "<html>Adds the following line at the end of the commit message:<br/>Signed-off by: " + signature + "</html>";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions", "getToolTip"));
            }
            return string;
        }

        @NotNull
        private List<String> getAuthors(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions", "getAuthors"));
            }
            HashSet<String> authors = new HashSet<String>(this.getUsersList(project));
            ContainerUtil.addAll(authors, (Object[])GitCheckinEnvironment.this.mySettings.getCommitAuthors());
            ArrayList<String> list = new ArrayList<String>(authors);
            Collections.sort(list);
            ArrayList<String> arrayList = list;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions", "getAuthors"));
            }
            return arrayList;
        }

        @NotNull
        private EditorTextField createTextField(@NotNull Project project, @NotNull List<String> list) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions", "createTextField"));
            }
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions", "createTextField"));
            }
            ValuesCompletionProvider.ValuesCompletionProviderDumbAware completionProvider = new ValuesCompletionProvider.ValuesCompletionProviderDumbAware((TextCompletionValueDescriptor)new DefaultTextCompletionValueDescriptor.StringValueDescriptor(), list);
            TextFieldWithCompletion textFieldWithCompletion = new TextFieldWithCompletion(project, (TextCompletionProvider)completionProvider, "", true, true, true);
            if (textFieldWithCompletion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions", "createTextField"));
            }
            return textFieldWithCompletion;
        }

        @NotNull
        private List<String> getUsersList(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions", "getUsersList"));
            }
            VcsUserRegistry userRegistry = (VcsUserRegistry)ServiceManager.getService((Project)project, VcsUserRegistry.class);
            List list = ContainerUtil.map((Collection)userRegistry.getUsers(), VcsUserUtil::toExactString);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions", "getUsersList"));
            }
            return list;
        }

        public void refresh() {
            this.myAmendComponent.refresh();
            this.myAuthorField.setText(null);
            this.myAuthorDate = null;
            GitCheckinEnvironment.this.reset();
        }

        public void saveState() {
            String author = this.myAuthorField.getText();
            if (StringUtil.isEmptyOrSpaces((String)author)) {
                GitCheckinEnvironment.this.myNextCommitAuthor = null;
            } else {
                GitCheckinEnvironment.this.myNextCommitAuthor = GitCommitAuthorCorrector.correct(author);
                GitCheckinEnvironment.this.mySettings.saveCommitAuthor(GitCheckinEnvironment.this.myNextCommitAuthor);
            }
            GitCheckinEnvironment.this.myNextCommitAmend = this.myAmendComponent.isAmend();
            GitCheckinEnvironment.this.myNextCommitAuthorDate = this.myAuthorDate;
            GitCheckinEnvironment.this.mySettings.setSignOffCommit(this.mySignOffCheckbox.isSelected());
            GitCheckinEnvironment.this.myNextCommitSignOff = this.mySignOffCheckbox.isSelected();
        }

        public void restoreState() {
            this.refresh();
        }

        public void onChangeListSelected(LocalChangeList list) {
            Object data = list.getData();
            if (data instanceof VcsFullCommitDetails) {
                VcsFullCommitDetails commit = (VcsFullCommitDetails)data;
                String author = VcsUserUtil.toExactString((VcsUser)commit.getAuthor());
                this.myAuthorField.setText(author);
                this.myAuthorDate = new Date(commit.getAuthorTime());
            } else {
                this.myAuthorField.setText(null);
                this.myAuthorDate = null;
            }
        }

        public JComponent getComponent() {
            return this.myPanel;
        }

        private class MyAmendComponent
        extends AmendComponent {
            public MyAmendComponent(@NotNull Project project, @NotNull GitRepositoryManager manager, CheckinProjectPanel panel) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions$MyAmendComponent", "<init>"));
                }
                if (manager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions$MyAmendComponent", "<init>"));
                }
                if (panel == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions$MyAmendComponent", "<init>"));
                }
                super(project, (RepositoryManager)manager, panel);
            }

            @NotNull
            protected Set<VirtualFile> getVcsRoots(@NotNull Collection<FilePath> files) {
                if (files == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions$MyAmendComponent", "getVcsRoots"));
                }
                Set<VirtualFile> set = GitUtil.gitRoots(files);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions$MyAmendComponent", "getVcsRoots"));
                }
                return set;
            }

            @Nullable
            protected String getLastCommitMessage(@NotNull VirtualFile root) throws VcsException {
                if (root == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions$MyAmendComponent", "getLastCommitMessage"));
                }
                GitSimpleHandler h = new GitSimpleHandler(GitCheckinEnvironment.this.myProject, root, GitCommand.LOG);
                h.addParameters("--max-count=1");
                String formatPattern = GitVersionSpecialty.STARTED_USING_RAW_BODY_IN_FORMAT.existsIn(GitCheckinOptions.this.myVcs.getVersion()) ? "%B" : "%s%n%n%-b";
                h.addParameters("--pretty=format:" + formatPattern);
                return h.run();
            }
        }
    }

    private static enum PartialOperation {
        NONE("none"),
        MERGE("merge"),
        CHERRY_PICK("cherry-pick");

        private final String myName;

        private PartialOperation(String name) {
            this.myName = name;
        }

        String getName() {
            return this.myName;
        }
    }
}

