/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.config;

import com.intellij.javaee.oss.jboss.config.JBossConfigProcessor;
import com.intellij.javaee.oss.jboss.server.JBossServerModel;
import com.intellij.javaee.oss.jboss.version.JBossVersion7Handler;
import com.intellij.javaee.oss.util.CachedConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.jetbrains.annotations.NotNull;

public class Jboss7ServerGroupsConfig
extends CachedConfig<JBossServerModel> {
    private static final Map<CachedConfig.Key, Jboss7ServerGroupsConfig> ourCache = new HashMap<CachedConfig.Key, Jboss7ServerGroupsConfig>();
    private static final CachedConfig.Factory<JBossServerModel, Jboss7ServerGroupsConfig> ourFactory = new CachedConfig.Factory<JBossServerModel, Jboss7ServerGroupsConfig>(){

        @NotNull
        public CachedConfig.Key createKey(JBossServerModel data) {
            CachedConfig.Key key = new CachedConfig.Key(new String[]{data.getHome()});
            if (key == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/jboss/config/Jboss7ServerGroupsConfig$1", "createKey"));
            }
            return key;
        }

        @NotNull
        public Jboss7ServerGroupsConfig createConfig(JBossServerModel data) {
            Jboss7ServerGroupsConfig jboss7ServerGroupsConfig = new Jboss7ServerGroupsConfig();
            if (jboss7ServerGroupsConfig == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/jboss/config/Jboss7ServerGroupsConfig$1", "createConfig"));
            }
            return jboss7ServerGroupsConfig;
        }
    };
    private List<String> myServerGroups = Collections.emptyList();

    private static File getConfigFile(JBossServerModel data) {
        return JBossVersion7Handler.getDomainConfigFile(data);
    }

    public static List<String> getServerGroups(JBossServerModel model) {
        Jboss7ServerGroupsConfig instance = (Jboss7ServerGroupsConfig)Jboss7ServerGroupsConfig.get(ourCache, ourFactory, (Object)((Object)model));
        return instance == null ? Collections.emptyList() : instance.myServerGroups;
    }

    protected long getStamp(JBossServerModel data) {
        return Jboss7ServerGroupsConfig.getStamp((File)Jboss7ServerGroupsConfig.getConfigFile(data));
    }

    protected void update(JBossServerModel data) {
        String xPath = "ns:domain/ns:server-groups/ns:server-group/@name";
        this.myServerGroups = (List)new JBossConfigProcessor<List<String>>(xPath, Collections.emptyList()){

            @Override
            protected List<String> process(XPath xpath, Document doc) throws JDOMException, IOException {
                ArrayList<String> result = new ArrayList<String>();
                for (Object serverGroupNameAttr : xpath.selectNodes((Object)doc)) {
                    result.add(((Attribute)serverGroupNameAttr).getValue());
                }
                return result;
            }
        }.get(Jboss7ServerGroupsConfig.getConfigFile(data));
    }
}

