/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.highlighting;

import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.intellij.plugins.markdown.highlighting.MarkdownHighlighterColors;
import org.intellij.plugins.markdown.highlighting.MarkdownSyntaxHighlighter;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.jetbrains.annotations.NotNull;

public class MarkdownHighlightingAnnotator
implements Annotator,
DumbAware {
    private static final SyntaxHighlighter SYNTAX_HIGHLIGHTER = new MarkdownSyntaxHighlighter();

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/plugins/markdown/highlighting/MarkdownHighlightingAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/plugins/markdown/highlighting/MarkdownHighlightingAnnotator", "annotate"));
        }
        IElementType type = element.getNode().getElementType();
        if (type == MarkdownTokenTypes.EMPH) {
            PsiElement parent = element.getParent();
            if (parent == null) {
                return;
            }
            IElementType parentType = parent.getNode().getElementType();
            if (parentType == MarkdownElementTypes.EMPH || parentType == MarkdownElementTypes.STRONG) {
                Annotation annotation = holder.createInfoAnnotation(element, null);
                annotation.setTextAttributes(parentType == MarkdownElementTypes.EMPH ? MarkdownHighlighterColors.ITALIC_MARKER_ATTR_KEY : MarkdownHighlighterColors.BOLD_MARKER_ATTR_KEY);
            }
            return;
        }
        TextAttributesKey[] tokenHighlights = SYNTAX_HIGHLIGHTER.getTokenHighlights(type);
        if (tokenHighlights.length > 0 && !MarkdownHighlighterColors.TEXT_ATTR_KEY.equals((Object)tokenHighlights[0])) {
            Annotation annotation = holder.createInfoAnnotation(element, null);
            annotation.setTextAttributes(tokenHighlights[0]);
        }
    }
}

