/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.WeighedFileEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.intellij.plugins.markdown.lang.MarkdownFileType;
import org.intellij.plugins.markdown.ui.preview.MarkdownPreviewFileEditor;
import org.jetbrains.annotations.NotNull;

public class MarkdownPreviewFileEditorProvider
extends WeighedFileEditorProvider {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditorProvider", "accept"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditorProvider", "accept"));
        }
        return file.getFileType() == MarkdownFileType.INSTANCE;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditorProvider", "createEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditorProvider", "createEditor"));
        }
        MarkdownPreviewFileEditor markdownPreviewFileEditor = new MarkdownPreviewFileEditor(file);
        if (markdownPreviewFileEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditorProvider", "createEditor"));
        }
        return markdownPreviewFileEditor;
    }

    @NotNull
    public String getEditorTypeId() {
        if ("markdown-preview-editor" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditorProvider", "getEditorTypeId"));
        }
        return "markdown-preview-editor";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditorProvider", "getPolicy"));
        }
        return fileEditorPolicy;
    }
}

