/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.plugins.drools.lang.psi.DroolsField;
import com.intellij.plugins.drools.lang.psi.DroolsFieldName;
import com.intellij.plugins.drools.lang.psi.DroolsFieldType;
import com.intellij.plugins.drools.lang.psi.DroolsPrimitiveType;
import com.intellij.plugins.drools.lang.psi.DroolsPsiClass;
import com.intellij.plugins.drools.lang.psi.DroolsPsiField;
import com.intellij.plugins.drools.lang.psi.DroolsType;
import com.intellij.plugins.drools.lang.psi.impl.DroolsPsiCompositeElementImpl;
import com.intellij.plugins.drools.lang.psi.util.DroolsElementsFactory;
import com.intellij.plugins.drools.lang.psi.util.DroolsResolveUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.light.JavaIdentifier;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DroolsPsiFieldImpl
extends DroolsPsiCompositeElementImpl
implements DroolsPsiField,
DroolsField {
    private Computable<PsiType> myType;

    public DroolsPsiFieldImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiFieldImpl", "<init>"));
        }
        super(node);
    }

    public String getName() {
        return this.getFieldName().getText();
    }

    public void setInitializer(@Nullable PsiExpression initializer) throws IncorrectOperationException {
    }

    @NotNull
    public PsiIdentifier getNameIdentifier() {
        JavaIdentifier javaIdentifier = new JavaIdentifier((PsiManager)this.getManager(), (PsiElement)this.getFieldName());
        if (javaIdentifier == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiFieldImpl", "getNameIdentifier"));
        }
        return javaIdentifier;
    }

    @Nullable
    public PsiDocComment getDocComment() {
        return null;
    }

    public boolean isDeprecated() {
        return false;
    }

    @Nullable
    public PsiClass getContainingClass() {
        return (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this, DroolsPsiClass.class);
    }

    @NotNull
    public PsiType getType() {
        DroolsFieldType droolsFieldType = this.getFieldType();
        if (droolsFieldType != null) {
            PsiType psiType;
            DroolsType type = droolsFieldType.getType();
            if (type != null && (psiType = DroolsResolveUtil.resolveType(type)) != null) {
                PsiType psiType2 = psiType;
                if (psiType2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiFieldImpl", "getType"));
                }
                return psiType2;
            }
            DroolsPrimitiveType primitiveType = droolsFieldType.getPrimitiveType();
            if (primitiveType != null) {
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)primitiveType.getProject());
                PsiType psiType3 = elementFactory.createTypeFromText(primitiveType.getText(), (PsiElement)primitiveType);
                if (psiType3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiFieldImpl", "getType"));
                }
                return psiType3;
            }
        }
        PsiClassType psiClassType = PsiType.getJavaLangObject((PsiManager)this.getManager(), (GlobalSearchScope)this.getResolveScope());
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiFieldImpl", "getType"));
        }
        return psiClassType;
    }

    @Nullable
    public PsiTypeElement getTypeElement() {
        return null;
    }

    @Nullable
    public PsiExpression getInitializer() {
        return null;
    }

    public boolean hasInitializer() {
        return false;
    }

    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    @Nullable
    public Object computeConstantValue() {
        return null;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiFieldImpl", "setName"));
        }
        DroolsFieldName oldIdentifier = this.getFieldName();
        DroolsFieldName nameIdentifier = DroolsElementsFactory.createFieldNameIdentifier(name, this.getProject());
        if (nameIdentifier != null) {
            oldIdentifier.replace((PsiElement)nameIdentifier);
        }
        return this;
    }

    @Nullable
    public PsiModifierList getModifierList() {
        return null;
    }

    public boolean hasModifierProperty(@PsiModifier.ModifierConstant @NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiFieldImpl", "hasModifierProperty"));
        }
        return false;
    }
}

