/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.extras.UmlNodeHighlighter;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class JavaUmlNodeHighlighter
implements UmlNodeHighlighter<PsiElement> {
    public List<DiagramNode<PsiElement>> onNodeSelected(List<DiagramNode<PsiElement>> selectedNodes, DiagramDataModel<PsiElement> psiElementUmlDataModel) {
        String name;
        DiagramNode<PsiElement> selected;
        PsiElement element;
        if (selectedNodes.size() == 1 && (element = (PsiElement)(selected = selectedNodes.get(0)).getIdentifyingElement()) instanceof PsiClass && (name = JavaUmlNodeHighlighter.getPackageName((PsiClass)element)) != null) {
            Collection nodes = psiElementUmlDataModel.getNodes();
            ArrayList<DiagramNode<PsiElement>> result = new ArrayList<DiagramNode<PsiElement>>();
            for (DiagramNode node : nodes) {
                PsiElement cls = (PsiElement)node.getIdentifyingElement();
                if (cls instanceof PsiClass && name.equals(JavaUmlNodeHighlighter.getPackageName((PsiClass)cls))) {
                    result.add((DiagramNode<PsiElement>)node);
                }
                if (!(node.getIdentifyingElement() instanceof PsiPackage)) continue;
                result.add((DiagramNode<PsiElement>)node);
            }
            if (nodes.size() != result.size() && result.size() > 1) {
                return result;
            }
        }
        return null;
    }

    public void selectionChanged(DiagramBuilder builder) {
    }

    @Nullable
    private static String getPackageName(PsiClass aClass) {
        PsiFile file = aClass.getContainingFile();
        if (file instanceof PsiJavaFile) {
            return ((PsiJavaFile)file).getPackageName();
        }
        return null;
    }
}

