/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.descriptor;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.junit.experimental.categories.Category;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.FunctionUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.descriptor.JavaClassSource;
import org.junit.platform.engine.support.descriptor.JavaMethodSource;
import org.junit.platform.engine.support.descriptor.JavaSource;
import org.junit.runner.Description;

@API(value=API.Usage.Internal)
public class VintageTestDescriptor
extends AbstractTestDescriptor {
    public static final String ENGINE_ID = "junit-vintage";
    public static final String SEGMENT_TYPE_RUNNER = "runner";
    public static final String SEGMENT_TYPE_TEST = "test";
    private final Description description;

    public VintageTestDescriptor(TestDescriptor parent, String segmentType, String segmentValue, Description description) {
        this(parent, segmentType, segmentValue, description, VintageTestDescriptor.toJavaSource(description));
    }

    VintageTestDescriptor(TestDescriptor parent, String segmentType, String segmentValue, Description description, Optional<? extends TestSource> source) {
        this(parent, segmentType, segmentValue, description, VintageTestDescriptor.generateDisplayName(description), source);
    }

    VintageTestDescriptor(TestDescriptor parent, String segmentType, String segmentValue, Description description, String displayName, Optional<? extends TestSource> source) {
        super(parent.getUniqueId().append(segmentType, segmentValue), displayName);
        this.description = description;
        source.ifPresent(arg_0 -> ((VintageTestDescriptor)this).setSource(arg_0));
    }

    private static String generateDisplayName(Description description) {
        return description.getMethodName() != null ? description.getMethodName() : description.getDisplayName();
    }

    public Description getDescription() {
        return this.description;
    }

    public boolean isTest() {
        return this.description.isTest();
    }

    public boolean isContainer() {
        return this.description.isSuite();
    }

    public Set<TestTag> getTags() {
        LinkedHashSet<TestTag> result = new LinkedHashSet<TestTag>();
        this.getParent().ifPresent(parent -> result.addAll(parent.getTags()));
        this.getDeclaredCategories().ifPresent(categoryClasses -> Arrays.stream(categoryClasses).map(ReflectionUtils::getAllAssignmentCompatibleClasses).flatMap(Collection::stream).distinct().map(Class::getName).map(TestTag::create).forEachOrdered(result::add));
        return result;
    }

    private Optional<Class<?>[]> getDeclaredCategories() {
        Category annotation = (Category)this.description.getAnnotation(Category.class);
        return Optional.ofNullable(annotation).map(Category::value);
    }

    private static Optional<JavaSource> toJavaSource(Description description) {
        Class testClass = description.getTestClass();
        if (testClass != null) {
            JavaMethodSource javaMethodSource;
            String methodName = description.getMethodName();
            if (methodName != null && (javaMethodSource = VintageTestDescriptor.toJavaMethodSource(testClass, methodName)) != null) {
                return Optional.of(javaMethodSource);
            }
            return Optional.of(new JavaClassSource(testClass));
        }
        return Optional.empty();
    }

    private static JavaMethodSource toJavaMethodSource(Class<?> testClass, String methodName) {
        if (methodName.contains("[") && methodName.endsWith("]")) {
            return VintageTestDescriptor.toJavaMethodSource(testClass, methodName.substring(0, methodName.indexOf("[")));
        }
        List methods = ReflectionUtils.findMethods(testClass, (Predicate)FunctionUtils.where(Method::getName, Predicate.isEqual(methodName)));
        return methods.size() == 1 ? new JavaMethodSource((Method)CollectionUtils.getOnlyElement((Collection)methods)) : null;
    }
}

