/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.ws.WSBundle;
import com.intellij.ws.WebServicesPlugin;
import com.intellij.ws.WebServicesPluginSettings;
import com.intellij.ws.actions.WebServicePlatformUtils;
import com.intellij.ws.engines.cxf.CXFWSEngine;
import com.intellij.ws.engines.jwsdp.JWSDPWSEngine;
import com.intellij.ws.engines.wsengine.DeployWebServiceOptions;
import com.intellij.ws.engines.wsengine.DialogWithWebServicePlatform;
import com.intellij.ws.engines.wsengine.WSEngine;
import com.intellij.ws.engines.wsengine.WSEngineManager;
import com.intellij.ws.utils.CommonWsUtils;
import com.intellij.ws.utils.DeployUtils;
import com.intellij.ws.utils.WsPsiUtil;
import com.intellij.ws.utils.ui.GenerateFromJavaCodeDialogBase;
import com.intellij.ws.utils.ui.MyDialogWrapper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeployWebServiceDialog
extends GenerateFromJavaCodeDialogBase
implements DialogWithWebServicePlatform,
DeployWebServiceOptions {
    private ComboBox webServicePlatform;
    private JLabel webServicePlatformText;
    private JPanel myPanel;
    private WSEngine currentEngine;
    private boolean myDoUpdateFromSetClass;
    private boolean myDoUpdateFromClassTextChange;
    private boolean myDoUpdateFromConfiguringWebServices;
    private TextFieldWithBrowseButton myClassName;
    private JLabel myClassNameText;
    private JLabel myWSNameText;
    private ComboBox myWSName;
    private JTextField myWSNamespace;
    private JLabel myWsNamespaceText;
    private ComboBox myTargetModule;
    private JLabel myTargetModuleText;
    private boolean myWSNamespaceChanged;
    private boolean myWSNameChanged;
    private JLabel myWsServiceStyleText;
    private ComboBox myWsServiceStyle;
    private JLabel myWsUseOfItemsText;
    private ComboBox myWsUseOfItems;
    private JTable myMethodsTable;
    private JScrollPane myMethodsPane;
    private JCheckBox myAddRequiredLibraries;

    public DeployWebServiceDialog(final Project project, @Nullable PsiClass clazz, @Nullable DeployWebServiceDialog previousDialog) {
        super(project, previousDialog != null ? previousDialog.getCurrentClass() : clazz);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(WSBundle.message("expose.class.as.web.service.dialog.title", objectArray));
        final JTextField classNameTextField = this.myClassName.getTextField();
        this.doInitFor(this.myClassNameText, classNameTextField, 'C');
        classNameTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (!DeployWebServiceDialog.this.myDoUpdateFromSetClass) {
                    DeployWebServiceDialog.this.myDoUpdateFromClassTextChange = true;
                    DeployWebServiceDialog.this.setCurrentClass(WsPsiUtil.findClass((String)classNameTextField.getText(), (Project)DeployWebServiceDialog.this.myProject, (GlobalSearchScope)GlobalSearchScope.moduleScope((Module)DeployWebServiceDialog.this.getSelectedModule())));
                    DeployWebServiceDialog.this.myDoUpdateFromClassTextChange = false;
                }
            }
        });
        this.myClassName.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)project).createProjectScopeChooser("Choose Class", DeployWebServiceDialog.this.getCurrentClass());
                chooser.showDialog();
                PsiClass selectedClass = chooser.getSelected();
                if (selectedClass != null) {
                    DeployWebServiceDialog.this.setCurrentClass(selectedClass);
                }
            }
        });
        this.doInitFor(this.myWSNameText, (JComponent)this.myWSName, 'W');
        this.myWSName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] servicesOperations;
                String webServiceName = (String)DeployWebServiceDialog.this.myWSName.getSelectedItem();
                Module selectedModule = DeployWebServiceDialog.this.getSelectedModule();
                String[] stringArray = servicesOperations = selectedModule != null ? DeployWebServiceDialog.this.currentEngine.getWebServicesOperations(webServiceName, selectedModule) : ArrayUtil.EMPTY_STRING_ARRAY;
                if (servicesOperations.length != 0) {
                    DeployWebServiceDialog.this.myMethodsTable.setModel(new DefaultTableModel(new Object[][]{servicesOperations}, new Object[]{"name"}));
                }
            }
        });
        ((JTextField)this.myWSName.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!DeployWebServiceDialog.this.myDoUpdateFromSetClass && !DeployWebServiceDialog.this.myDoUpdateFromConfiguringWebServices) {
                    DeployWebServiceDialog.this.myWSNameChanged = true;
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!DeployWebServiceDialog.this.myDoUpdateFromSetClass && !DeployWebServiceDialog.this.myDoUpdateFromConfiguringWebServices) {
                    DeployWebServiceDialog.this.myWSNameChanged = true;
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!DeployWebServiceDialog.this.myDoUpdateFromSetClass && !DeployWebServiceDialog.this.myDoUpdateFromConfiguringWebServices) {
                    DeployWebServiceDialog.this.myWSNameChanged = true;
                }
            }
        });
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Module[] modules = moduleManager.getModules();
        this.myTargetModule.setModel(new DefaultComboBoxModel<Module>(modules));
        if (clazz != null) {
            Module moduleForFile = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(clazz.getContainingFile().getVirtualFile());
            if (moduleForFile != null) {
                this.myTargetModule.setSelectedItem((Object)moduleForFile);
            }
        } else if (modules.length != 0) {
            this.myTargetModule.setSelectedIndex(0);
        }
        this.doInitFor(this.myWsNamespaceText, this.myWSNamespace, 'N');
        this.doInitFor(this.myTargetModuleText, (JComponent)this.myTargetModule, 'M');
        this.configureComboBox((JComboBox)this.myWsUseOfItems, Arrays.asList("LITERAL", "ENCODED"));
        this.myWsUseOfItemsText.setLabelFor((Component)this.myWsUseOfItems);
        this.myWsUseOfItemsText.setDisplayedMnemonic('e');
        this.configureComboBox((JComboBox)this.myWsServiceStyle, Arrays.asList("DOCUMENT", "WRAPPED", "RPC", "MESSAGE"));
        this.myWsServiceStyleText.setLabelFor((Component)this.myWsServiceStyle);
        this.myWsServiceStyleText.setDisplayedMnemonic('y');
        this.myWSNamespace.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!DeployWebServiceDialog.this.myDoUpdateFromSetClass) {
                    DeployWebServiceDialog.this.myWSNamespaceChanged = true;
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!DeployWebServiceDialog.this.myDoUpdateFromSetClass) {
                    DeployWebServiceDialog.this.myWSNamespaceChanged = true;
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!DeployWebServiceDialog.this.myDoUpdateFromSetClass) {
                    DeployWebServiceDialog.this.myWSNamespaceChanged = true;
                }
            }
        });
        this.myTargetModule.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DeployWebServiceDialog.this.setupAvailableServices();
            }
        });
        this.myAddRequiredLibraries.setMnemonic('r');
        this.myAddRequiredLibraries.setSelected(WebServicesPlugin.getInstance(project).isToAddRequiredLibraries());
        this.myAddRequiredLibraries.setVisible(false);
        WebServicePlatformUtils.initWSPlatforms(this);
        this.setupWSPlatformSpecificFields();
        this.init();
        if (clazz == null && previousDialog != null) {
            this.myTargetModule.setSelectedItem(previousDialog.myTargetModule.getSelectedItem());
            this.myWSName.setSelectedItem(previousDialog.myWSName.getSelectedItem());
            this.myWSNamespace.setText(previousDialog.myWSNamespace.getText());
            this.myWsServiceStyle.setSelectedItem(previousDialog.myWsServiceStyle.getSelectedItem());
            this.myWsUseOfItems.setSelectedItem(previousDialog.myWsUseOfItems.getSelectedItem());
        }
    }

    private void setupAvailableServices() {
        this.myDoUpdateFromConfiguringWebServices = true;
        try {
            Module selectedModule = (Module)this.myTargetModule.getSelectedItem();
            this.myWSName.setModel(new DefaultComboBoxModel<Object>(selectedModule != null ? this.currentEngine.getAvailableWebServices(selectedModule) : ArrayUtil.EMPTY_OBJECT_ARRAY));
            this.setGuessedClassNameAndNamespace(this.getCurrentClass());
        }
        finally {
            this.myDoUpdateFromConfiguringWebServices = false;
        }
    }

    @Override
    protected void doSetClassNameText(JComponent className, String text) {
        if (!this.myDoUpdateFromClassTextChange) {
            super.doSetClassNameText(className, text);
        }
    }

    @Override
    protected ValidationInfo doValidate(MyDialogWrapper.ValidationData _data) {
        String uptoDateCheck;
        final PsiClass clazz = this.getCurrentClass();
        Object validationResult = clazz != null && clazz.isInterface() ? ((uptoDateCheck = DeployUtils.checkIfClassIsUpToDate(this.myProject, clazz)) != null ? new ValidationInfo(uptoDateCheck, null) : null) : super.doValidate(_data);
        if (validationResult != null) {
            return validationResult;
        }
        ValidationInfo result = WebServicePlatformUtils.checkIfPlatformIsSetUpCorrectly(this, this.currentEngine);
        if (result != null) {
            return result;
        }
        String notAcceptableClazzMessage = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return DeployWebServiceDialog.this.currentEngine.checkNotAcceptableClassForGenerateWsdl(clazz);
            }
        });
        if (notAcceptableClazzMessage != null) {
            return new ValidationInfo(notAcceptableClazzMessage, null);
        }
        MyValidationData data = (MyValidationData)_data;
        return this.doValidationWithData(data);
    }

    private ValidationInfo doValidationWithData(MyValidationData data) {
        if (data.module == null) {
            return new ValidationInfo(WSBundle.message("invalid.web.module.selected.validation.message", new Object[0]), (JComponent)this.myTargetModule);
        }
        try {
            URL uRL = new URL(data.wsNamespace);
        }
        catch (MalformedURLException e) {
            return new ValidationInfo(WSBundle.message("invalid.url.validation.message", new Object[0]), (JComponent)this.myWSNamespace);
        }
        try {
            PsiUtil.checkIsIdentifier((PsiManager)PsiManager.getInstance((Project)this.myProject), (String)data.wsName);
        }
        catch (IncorrectOperationException e) {
            return new ValidationInfo(WSBundle.message("invalid.web.service.name.validation.message", new Object[0]), (JComponent)this.myWSName);
        }
        final PsiClass clazz = this.getCurrentClass();
        if (clazz != null) {
            String notAcceptableMessage;
            Module moduleForFile = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(clazz.getContainingFile().getVirtualFile());
            if (moduleForFile != data.module) {
                Module[] dependencies = ModuleRootManager.getInstance((Module)moduleForFile).getDependencies();
                boolean notAcceptableModule = true;
                for (Module module : dependencies) {
                    if (module != data.module) continue;
                    notAcceptableModule = false;
                    break;
                }
                if (notAcceptableModule) {
                    return new ValidationInfo("Selected class is not in module", (JComponent)this.myTargetModule);
                }
            }
            if ((notAcceptableMessage = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    return DeployWebServiceDialog.this.currentEngine.checkNotAcceptableClassForDeployment(clazz);
                }
            })) != null) {
                return new ValidationInfo(notAcceptableMessage, (JComponent)this.myClassName);
            }
        } else {
            return new ValidationInfo("Class does not exist", (JComponent)this.myClassName.getTextField());
        }
        if (!data.wsClassName.matches("(?:\\w+\\.)*\\w+")) {
            return new ValidationInfo(WSBundle.message("invalid.web.service.class.name.validation.message", new Object[0]), (JComponent)this.myClassName.getTextField());
        }
        return null;
    }

    @Override
    protected MyValidationData createValidationData() {
        return new MyValidationData();
    }

    @Override
    protected JComponent getClassName() {
        return this.myClassName != null ? this.myClassName.getTextField() : null;
    }

    @Override
    protected String getClassNameTextToSet(PsiClass aClass) {
        return aClass.getQualifiedName();
    }

    @Override
    protected JTable getMethodsTable() {
        return this.myMethodsTable;
    }

    @Override
    public void setCurrentClass(PsiClass aClass) {
        try {
            Module moduleForFile;
            this.myDoUpdateFromSetClass = true;
            super.setCurrentClass(aClass);
            if (this.myClassName == null) {
                return;
            }
            this.setGuessedClassNameAndNamespace(aClass);
            if (aClass != null && (moduleForFile = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(aClass.getContainingFile().getVirtualFile())) != null && CommonWsUtils.isWebModule((Module)moduleForFile)) {
                this.myTargetModule.setSelectedItem((Object)moduleForFile);
            }
        }
        finally {
            this.myDoUpdateFromSetClass = false;
        }
    }

    private void setGuessedClassNameAndNamespace(PsiClass aClass) {
        String classNameText = this.myClassName.getTextField().getText();
        int lastDotInClassName = classNameText.lastIndexOf(46);
        if (!this.myWSNamespaceChanged) {
            String qualifiedName = aClass != null ? DeployWebServiceDialog.buildNSNameFromClass(aClass, this.currentEngine) : (lastDotInClassName != -1 ? DeployWebServiceDialog.buildNSNameFromPackageText(classNameText.substring(0, lastDotInClassName), this.currentEngine) : "somewhere");
            this.myWSNamespace.setText("http://" + qualifiedName);
        }
        if (!this.myWSNameChanged) {
            String candidateName;
            PsiAnnotationMemberValue annotationMemberValue;
            PsiAnnotation annotation;
            String wsName;
            String string = aClass != null ? aClass.getName() : (wsName = lastDotInClassName + 1 < classNameText.length() ? classNameText.substring(lastDotInClassName + 1) : "*UNDEFINED*");
            if (aClass != null && (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aClass, JWSDPWSEngine.wsClassesSet)) != null && (annotationMemberValue = annotation.findAttributeValue("name")) instanceof PsiLiteralExpression && (candidateName = StringUtil.stripQuotesAroundValue((String)annotationMemberValue.getText())).length() > 0) {
                wsName = candidateName;
            }
            this.myWSName.setSelectedItem((Object)wsName);
        }
    }

    public static String buildNSNameFromClass(PsiClass aClass, WSEngine engine) {
        String s;
        PsiDirectory directory = aClass.getContainingFile().getParent();
        PsiPackage aPackage = directory != null ? JavaDirectoryService.getInstance().getPackage(directory) : null;
        String string = s = aPackage == null ? "" : DeployWebServiceDialog.buildNSNameFromPackage(aPackage);
        if (engine instanceof CXFWSEngine) {
            s = s + "/";
        }
        return s;
    }

    public static String buildNSNameFromPackageText(String packageText, WSEngine engine) {
        StringBuffer result = new StringBuffer();
        int i = packageText.lastIndexOf(46);
        int prev = packageText.length();
        while (i != -1) {
            if (result.length() != 0) {
                result.append('.');
            }
            if (i + 1 != prev) {
                result.append(packageText.substring(i + 1, prev));
            }
            prev = i;
            i = packageText.lastIndexOf(46, prev - 1);
        }
        if (result.length() != 0) {
            result.append('.');
        }
        result.append(packageText.substring(0, prev));
        if (engine instanceof CXFWSEngine) {
            result.append("/");
        }
        return result.toString();
    }

    private static String buildNSNameFromPackage(PsiPackage _package) {
        String s;
        PsiPackage parentPackage = _package.getParentPackage();
        if (parentPackage != null && (s = DeployWebServiceDialog.buildNSNameFromPackage(parentPackage)) != null) {
            return _package.getName() + "." + s;
        }
        return _package.getName();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Override
    public JComboBox getWebServicePlatformCombo() {
        return this.webServicePlatform;
    }

    @Override
    public JLabel getWebServicePlaformText() {
        return this.webServicePlatformText;
    }

    @Override
    public void setupWSPlatformSpecificFields() {
        String currentPlatform = (String)this.webServicePlatform.getSelectedItem();
        this.currentEngine = WebServicesPluginSettings.getInstance().getEngineManager().getWSEngineByName(currentPlatform);
        boolean setWsConfig = !(this.currentEngine instanceof JWSDPWSEngine);
        this.myWsNamespaceText.setVisible(setWsConfig);
        this.myWSNamespace.setVisible(setWsConfig);
        this.myWSName.setVisible(setWsConfig);
        this.myWSNameText.setVisible(setWsConfig);
        this.myWsUseOfItems.setVisible(setWsConfig);
        this.myWsUseOfItemsText.setVisible(setWsConfig);
        this.myWsServiceStyle.setVisible(setWsConfig);
        this.myWsServiceStyleText.setVisible(setWsConfig);
        if (!setWsConfig) {
            this.myWSNameChanged = false;
            this.myWSNamespaceChanged = false;
        }
        this.setupAvailableServices();
        this.myMethodsPane.setVisible(false);
        this.pack();
    }

    @Override
    public Module getSelectedModule() {
        return (Module)this.myTargetModule.getSelectedItem();
    }

    @Override
    public JComboBox getModuleChooser() {
        return this.myTargetModule;
    }

    @Override
    public String[] getAvailableEngineNames() {
        WebServicesPluginSettings instance = WebServicesPluginSettings.getInstance();
        WSEngineManager engineManager = instance.getEngineManager();
        return engineManager.getAvailableWSEngineNamesWithSupportedDeployment();
    }

    public WSEngine getCurrentEngine() {
        return this.currentEngine;
    }

    protected void dispose() {
        this.setGuessedClassNameAndNamespace(this.getCurrentClass());
        super.dispose();
    }

    protected void doOKAction() {
        WebServicesPluginSettings instance = WebServicesPluginSettings.getInstance();
        instance.setLastPlatform(this.getWebServicePlatformCombo().getSelectedItem().toString());
        WebServicesPlugin.getInstance(this.myProject).setToAddRequiredLibraries(this.myAddRequiredLibraries.isSelected());
        super.doOKAction();
    }

    @Override
    public String getWsName() {
        Object selectedItem = this.myWSName.getSelectedItem();
        return selectedItem != null ? selectedItem.toString() : "";
    }

    @Override
    public String getWsClassName() {
        return this.myClassName.getTextField().getText();
    }

    @Override
    public String getWsNamespace() {
        return this.myWSNamespace.getText();
    }

    @Override
    public String getUseOfItems() {
        return this.myWsUseOfItems.getSelectedItem().toString();
    }

    @Override
    public String getBindingStyle() {
        return this.myWsServiceStyle.getSelectedItem().toString();
    }

    @Override
    public PsiClass getWsClass() {
        return this.getCurrentClass();
    }

    public boolean isToAddLibs() {
        return this.myAddRequiredLibraries.isSelected();
    }

    @Override
    @NotNull
    protected String getHelpId() {
        if ("DeployWebServices.html" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/actions/DeployWebServiceDialog", "getHelpId"));
        }
        return "DeployWebServices.html";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        ComboBox comboBox;
        JLabel jLabel;
        JLabel jLabel2;
        ComboBox comboBox2;
        JLabel jLabel3;
        JLabel jLabel4;
        JLabel jLabel5;
        JTextField jTextField;
        ComboBox comboBox3;
        ComboBox comboBox4;
        JLabel jLabel6;
        JLabel jLabel7;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        ComboBox comboBox5;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.webServicePlatform = comboBox5 = new ComboBox();
        comboBox5.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.wstoolkit.tooltip"));
        jPanel.add((Component)comboBox5, new GridConstraints(7, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myClassName = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.classname.tooltip"));
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myClassNameText = jLabel7 = new JLabel();
        jLabel7.setInheritsPopupMenu(true);
        jLabel7.setText("Sevice Class Name:");
        jLabel7.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.classname.tooltip"));
        jPanel.add((Component)jLabel7, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWSNameText = jLabel6 = new JLabel();
        jLabel6.setInheritsPopupMenu(true);
        jLabel6.setText("Service Name:");
        jLabel6.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.name.tooltip"));
        jPanel.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWSName = comboBox4 = new ComboBox();
        comboBox4.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.name.tooltip"));
        comboBox4.setEditable(true);
        jPanel.add((Component)comboBox4, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myTargetModule = comboBox3 = new ComboBox();
        comboBox3.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.name.of.module.tooltip"));
        jPanel.add((Component)comboBox3, new GridConstraints(6, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myWSNamespace = jTextField = new JTextField();
        jTextField.setText("");
        jTextField.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.namespace.tooltip"));
        jPanel.add((Component)jTextField, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.webServicePlatformText = jLabel5 = new JLabel();
        jLabel5.setText("Service Platform:");
        jLabel5.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.wstoolkit.tooltip"));
        jPanel.add((Component)jLabel5, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWsNamespaceText = jLabel4 = new JLabel();
        jLabel4.setText("Service Namespace:");
        jLabel4.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.namespace.tooltip"));
        jPanel.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTargetModuleText = jLabel3 = new JLabel();
        jLabel3.setText("Target Module:");
        jLabel3.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.name.of.module.tooltip"));
        jPanel.add((Component)jLabel3, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWsServiceStyle = comboBox2 = new ComboBox();
        comboBox2.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.deployment.style.tooltip"));
        jPanel.add((Component)comboBox2, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myWsServiceStyleText = jLabel2 = new JLabel();
        jLabel2.setText("Service style:");
        jLabel2.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.deployment.style.tooltip"));
        jPanel.add((Component)jLabel2, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWsUseOfItemsText = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("use.of.items.deploy.dialog.text"));
        jLabel.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.use.items.binding.tooltip"));
        jPanel.add((Component)jLabel, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWsUseOfItems = comboBox = new ComboBox();
        comboBox.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.use.items.binding.tooltip"));
        jPanel.add((Component)comboBox, new GridConstraints(5, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        this.myMethodsPane = jBScrollPane;
        jPanel.add((Component)jBScrollPane, new GridConstraints(2, 0, 1, 2, 0, 3, 7, 7, null, null, null));
        JBTable jBTable = new JBTable();
        this.myMethodsTable = jBTable;
        jBTable.setPreferredScrollableViewportSize(new Dimension(450, 100));
        jBTable.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.methodsforoperations.tooltip"));
        jBScrollPane.setViewportView((Component)jBTable);
        this.myAddRequiredLibraries = jCheckBox = new JCheckBox();
        jCheckBox.setText("Add required web service engine libraries to classpath");
        jPanel.add((Component)jCheckBox, new GridConstraints(8, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        jLabel7.setLabelFor((Component)jBScrollPane);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    class MyValidationData
    extends GenerateFromJavaCodeDialogBase.MyValidationData {
        String wsNamespace;
        String wsName;
        String wsClassName;
        Module module;

        MyValidationData() {
            super(DeployWebServiceDialog.this);
        }

        @Override
        protected void doAcquire() {
            this.wsClassName = DeployWebServiceDialog.this.getWsClassName();
            this.wsName = DeployWebServiceDialog.this.myWSName.getEditor().getItem().toString();
            this.wsNamespace = DeployWebServiceDialog.this.getWsNamespace();
            this.module = (Module)DeployWebServiceDialog.this.myTargetModule.getSelectedItem();
            super.doAcquire();
        }
    }
}

