/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class BaseRangedReference
implements PsiReference {
    private final PsiElement myElement;
    private final TextRange myRange;

    public BaseRangedReference(PsiElement psiElement, int index, int endIndex) {
        this.myElement = psiElement;
        this.myRange = new TextRange(index, endIndex);
    }

    protected BaseRangedReference(PsiElement element, TextRange range) {
        this.myElement = element;
        this.myRange = range;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public TextRange getRangeInElement() {
        return this.myRange;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myRange.substring(this.myElement.getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/BaseRangedReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String string) throws IncorrectOperationException {
        return ElementManipulators.getManipulator((PsiElement)this.myElement).handleContentChange(this.myElement, this.myRange, string);
    }

    public PsiElement bindToElement(@NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/ws/references/BaseRangedReference", "bindToElement"));
        }
        throw new IncorrectOperationException();
    }

    public boolean isReferenceTo(PsiElement psiElement) {
        return this.myElement.getManager().areElementsEquivalent(this.resolve(), psiElement);
    }
}

