/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.references;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.util.ProcessingContext;
import com.intellij.ws.references.Axis2ServicesXmlReferenceProvider;
import com.intellij.ws.references.CxfXmlReferenceProvider;
import com.intellij.ws.references.EndpointReferenceProvider;
import com.intellij.ws.references.JAXBJavaReferenceProvider;
import com.intellij.ws.references.JAXBSchemaReferenceProvider;
import com.intellij.ws.references.JBossWSXmlReferenceProvider;
import com.intellij.ws.references.JaxRPCMappingReferenceProvider;
import com.intellij.ws.references.JaxRPCRiXmlReferenceProvider;
import com.intellij.ws.references.JaxWSXmlReferenceProvider;
import com.intellij.ws.references.MyReferenceProvider;
import com.intellij.ws.references.WADLXmlReferenceProvider;
import com.intellij.ws.references.WSDDReferenceProvider;
import com.intellij.ws.references.WSDLReferenceProvider;
import com.intellij.ws.references.WSReferenceProvider;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WSReferenceContributor
extends PsiReferenceContributor {
    public static final List<WSReferenceProvider> PROVIDERS = new ArrayList<WSReferenceProvider>();

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/ws/references/WSReferenceContributor", "registerReferenceProviders"));
        }
        for (WSReferenceProvider provider : PROVIDERS) {
            provider.register(registrar);
        }
        WSReferenceContributor.registerXmlAttributeValueReferenceProvider(new WSDLReferenceProvider(), registrar);
        WSReferenceContributor.registerXmlAttributeValueReferenceProvider(new WSDDReferenceProvider(), registrar);
        WSReferenceContributor.registerXmlAttributeValueReferenceProvider(new JAXBSchemaReferenceProvider(), registrar);
        WSReferenceContributor.registerXmlAttributeValueReferenceProvider(new CxfXmlReferenceProvider(), registrar);
        WSReferenceContributor.registerXmlAttributeValueReferenceProvider(new JaxWSXmlReferenceProvider(), registrar);
        Axis2ServicesXmlReferenceProvider axis2ServicesXmlProvider = new Axis2ServicesXmlReferenceProvider();
        WSReferenceContributor.registerXmlAttributeValueReferenceProvider(axis2ServicesXmlProvider, registrar);
        WSReferenceContributor.registerXmlTagReferenceProvider(axis2ServicesXmlProvider, registrar);
        WSReferenceContributor.registerXmlTagReferenceProvider(new JaxRPCMappingReferenceProvider(), registrar);
        WSReferenceContributor.registerXmlAttributeValueReferenceProvider(new WADLXmlReferenceProvider(), registrar);
        WSReferenceContributor.registerXmlAttributeValueReferenceProvider(new JaxRPCRiXmlReferenceProvider(), registrar);
        WSReferenceContributor.registerXmlAttributeValueReferenceProvider(new JBossWSXmlReferenceProvider(), registrar);
    }

    private static void registerXmlTagReferenceProvider(MyReferenceProvider provider, PsiReferenceRegistrar registrar) {
        XmlUtil.registerXmlTagReferenceProvider((PsiReferenceRegistrar)registrar, (String[])provider.getTagCandidateNames(), (ElementFilter)provider.getTagFilter(), (boolean)true, (PsiReferenceProvider)new MyReferenceProviderWrapper(provider));
    }

    private static void registerXmlAttributeValueReferenceProvider(MyReferenceProvider provider, PsiReferenceRegistrar registrar) {
        XmlUtil.registerXmlAttributeValueReferenceProvider((PsiReferenceRegistrar)registrar, (String[])provider.getAttributeNames(), (ElementFilter)provider.getAttributeFilter(), (PsiReferenceProvider)new MyReferenceProviderWrapper(provider));
    }

    static {
        PROVIDERS.add(new JAXBJavaReferenceProvider());
        PROVIDERS.add(new EndpointReferenceProvider());
    }

    static class MyReferenceProviderWrapper
    extends PsiReferenceProvider {
        private final MyReferenceProvider provider;

        MyReferenceProviderWrapper(MyReferenceProvider javaProvider) {
            this.provider = javaProvider;
        }

        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ws/references/WSReferenceContributor$MyReferenceProviderWrapper", "getReferencesByElement"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/ws/references/WSReferenceContributor$MyReferenceProviderWrapper", "getReferencesByElement"));
            }
            PsiReference[] psiReferenceArray = this.provider.getReferencesByElement(element);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSReferenceContributor$MyReferenceProviderWrapper", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
    }
}

