/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.initialization;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.intention.initialization.TypeScriptVariablePredicate;
import org.jetbrains.annotations.NotNull;

public class TypeScriptRemoveTypeDeclaration
extends JSIntention {
    private static final JSElementPredicate PREDICATE = new TypeScriptVariablePredicate(){

        @Override
        protected boolean checkVariable(TypeScriptVariable variable) {
            return TypeScriptRemoveTypeDeclaration.checkVariable(variable);
        }
    };

    private static boolean checkVariable(TypeScriptVariable variable) {
        return variable.hasInitializer() && variable.getTypeElement() != null;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/initialization/TypeScriptRemoveTypeDeclaration", "processIntention"));
        }
        if (!(element instanceof TypeScriptVariable)) {
            return;
        }
        TypeScriptVariable variable = (TypeScriptVariable)element;
        if (!TypeScriptRemoveTypeDeclaration.checkVariable(variable)) {
            return;
        }
        ASTNode variableNode = variable.getNode();
        ASTNode colonNode = variableNode.findChildByType(JSTokenTypes.COLON);
        if (colonNode == null) {
            return;
        }
        variableNode.removeChild(colonNode);
        PsiElement typeElement = variable.getTypeElement();
        if (typeElement == null) {
            return;
        }
        JSElementFactory.removeElement((PsiElement)typeElement);
        JSElementFactory.reformat((PsiElement)variable);
    }

    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        JSElementPredicate jSElementPredicate = PREDICATE;
        if (jSElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/initialization/TypeScriptRemoveTypeDeclaration", "getElementPredicate"));
        }
        return jSElementPredicate;
    }
}

