/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.css;

import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexStyleIndexInfo {
    private final String myClassOrFileName;
    private final String myAttributeName;
    private final String myInherit;
    private final String myType;
    private final String myArrayType;
    private final String myFormat;
    private final String myEnumeration;
    private final boolean myInClass;

    public FlexStyleIndexInfo(@NotNull String classOrFileName, @NotNull String attributeName, @NotNull String inherit, @Nullable String type, @Nullable String arrayType, @Nullable String format, @Nullable String enumeration, boolean inClass) {
        if (classOrFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrFileName", "com/intellij/javascript/flex/css/FlexStyleIndexInfo", "<init>"));
        }
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/intellij/javascript/flex/css/FlexStyleIndexInfo", "<init>"));
        }
        if (inherit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inherit", "com/intellij/javascript/flex/css/FlexStyleIndexInfo", "<init>"));
        }
        this.myClassOrFileName = classOrFileName;
        this.myAttributeName = attributeName;
        this.myInherit = inherit;
        this.myType = type;
        this.myArrayType = arrayType;
        this.myFormat = format;
        this.myEnumeration = enumeration;
        this.myInClass = inClass;
    }

    @NotNull
    public String getInherit() {
        String string = this.myInherit;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexStyleIndexInfo", "getInherit"));
        }
        return string;
    }

    @Nullable
    public String getType() {
        return this.myType;
    }

    @Nullable
    public String getArrayType() {
        return this.myArrayType;
    }

    public boolean isInClass() {
        return this.myInClass;
    }

    @Nullable
    private static String getValue(JSAttribute attribute, String name) {
        JSAttributeNameValuePair pair = attribute.getValueByName(name);
        return pair != null ? pair.getSimpleValue() : null;
    }

    @Nullable
    public static FlexStyleIndexInfo create(@NotNull String className, @NotNull String name, @NotNull JSAttribute attribute, boolean inClass) {
        String type;
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/javascript/flex/css/FlexStyleIndexInfo", "create"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/flex/css/FlexStyleIndexInfo", "create"));
        }
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/javascript/flex/css/FlexStyleIndexInfo", "create"));
        }
        String inherit = FlexStyleIndexInfo.getValue(attribute, "inherit");
        if (inherit == null) {
            inherit = "no";
        }
        String arrayType = "Array".equals(type = FlexStyleIndexInfo.getValue(attribute, "type")) ? FlexStyleIndexInfo.getValue(attribute, "arrayType") : null;
        String format = FlexStyleIndexInfo.getValue(attribute, "format");
        String enumeration = FlexStyleIndexInfo.getValue(attribute, "enumeration");
        return new FlexStyleIndexInfo(className, name, inherit, type, arrayType, format, enumeration, inClass);
    }

    public String getEnumeration() {
        return this.myEnumeration;
    }

    @Nullable
    public String getFormat() {
        return this.myFormat;
    }

    @NotNull
    public String getClassOrFileName() {
        String string = this.myClassOrFileName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexStyleIndexInfo", "getClassOrFileName"));
        }
        return string;
    }

    @NotNull
    public String getAttributeName() {
        String string = this.myAttributeName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexStyleIndexInfo", "getAttributeName"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlexStyleIndexInfo that = (FlexStyleIndexInfo)o;
        if (this.myInClass != that.myInClass) {
            return false;
        }
        if (this.myAttributeName != null ? !this.myAttributeName.equals(that.myAttributeName) : that.myAttributeName != null) {
            return false;
        }
        if (this.myClassOrFileName != null ? !this.myClassOrFileName.equals(that.myClassOrFileName) : that.myClassOrFileName != null) {
            return false;
        }
        if (this.myEnumeration != null ? !this.myEnumeration.equals(that.myEnumeration) : that.myEnumeration != null) {
            return false;
        }
        if (this.myFormat != null ? !this.myFormat.equals(that.myFormat) : that.myFormat != null) {
            return false;
        }
        if (this.myInherit != null ? !this.myInherit.equals(that.myInherit) : that.myInherit != null) {
            return false;
        }
        return !(this.myType != null ? !this.myType.equals(that.myType) : that.myType != null);
    }

    public int hashCode() {
        int result = this.myClassOrFileName != null ? this.myClassOrFileName.hashCode() : 0;
        result = 31 * result + (this.myAttributeName != null ? this.myAttributeName.hashCode() : 0);
        result = 31 * result + (this.myInherit != null ? this.myInherit.hashCode() : 0);
        result = 31 * result + (this.myType != null ? this.myType.hashCode() : 0);
        result = 31 * result + (this.myFormat != null ? this.myFormat.hashCode() : 0);
        result = 31 * result + (this.myEnumeration != null ? this.myEnumeration.hashCode() : 0);
        result = 31 * result + (this.myInClass ? 1 : 0);
        return result;
    }
}

