/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.resolve;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.JSResolveHelper;
import com.intellij.lang.javascript.index.JSIndexedRootProvider;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedElementIndex;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.indexing.AdditionalIndexedRootsScope;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionScriptClassResolver
extends JSClassResolver {
    private static ActionScriptClassResolver INSTANCE = null;

    protected ActionScriptClassResolver() {
    }

    public static ActionScriptClassResolver getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ActionScriptClassResolver();
        }
        return INSTANCE;
    }

    public PsiElement findClassByQName(@NotNull String link, @NotNull PsiElement context) {
        if (link == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "link", "com/intellij/javascript/flex/resolve/ActionScriptClassResolver", "findClassByQName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/flex/resolve/ActionScriptClassResolver", "findClassByQName"));
        }
        return ActionScriptClassResolver.findClassByQNameStatic(link, context);
    }

    public static PsiElement findClassByQNameStatic(@NotNull String link, @NotNull PsiElement context) {
        if (link == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "link", "com/intellij/javascript/flex/resolve/ActionScriptClassResolver", "findClassByQNameStatic"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/flex/resolve/ActionScriptClassResolver", "findClassByQNameStatic"));
        }
        return ActionScriptClassResolver.getInstance().findClassByQName(link, JavaScriptIndex.getInstance((Project)context.getProject()), JSResolveUtil.getResolveScope((PsiElement)context), DialectOptionHolder.ECMA_4);
    }

    public static PsiElement findClassByQName(@NotNull String link, JavaScriptIndex index, Module module) {
        if (link == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "link", "com/intellij/javascript/flex/resolve/ActionScriptClassResolver", "findClassByQName"));
        }
        GlobalSearchScope searchScope = JSInheritanceUtil.getEnforcedScope();
        if (searchScope == null) {
            searchScope = module != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module) : GlobalSearchScope.allScope((Project)index.getProject());
        }
        return ActionScriptClassResolver.getInstance().findClassByQName(link, index, searchScope, DialectOptionHolder.ECMA_4);
    }

    @Nullable
    public PsiElement findClassByQName(@NotNull String link, @NotNull GlobalSearchScope scope) {
        if (link == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "link", "com/intellij/javascript/flex/resolve/ActionScriptClassResolver", "findClassByQName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/javascript/flex/resolve/ActionScriptClassResolver", "findClassByQName"));
        }
        return ActionScriptClassResolver.findClassByQNameStatic(link, scope);
    }

    public static PsiElement findClassByQNameStatic(@NotNull String link, @NotNull GlobalSearchScope scope) {
        if (link == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "link", "com/intellij/javascript/flex/resolve/ActionScriptClassResolver", "findClassByQNameStatic"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/javascript/flex/resolve/ActionScriptClassResolver", "findClassByQNameStatic"));
        }
        return ActionScriptClassResolver.getInstance().findClassByQName(link, JavaScriptIndex.getInstance((Project)scope.getProject()), scope, DialectOptionHolder.ECMA_4);
    }

    public static boolean isParentClass(JSClass clazz, String className) {
        return ActionScriptClassResolver.isParentClass(clazz, className, true);
    }

    public static boolean isParentClass(JSClass clazz, String className, boolean strict) {
        PsiElement parentClass = JSResolveUtil.unwrapProxy((PsiElement)ActionScriptClassResolver.findClassByQNameStatic(className, clazz.getResolveScope()));
        if (!(parentClass instanceof JSClass)) {
            return false;
        }
        return JSInheritanceUtil.isParentClass((JSClass)clazz, (JSClass)((JSClass)parentClass), (boolean)strict);
    }

    protected PsiElement doFindClassByQName(@NotNull String link, JavaScriptIndex index, GlobalSearchScope searchScope, boolean allowFileLocalSymbols, @NotNull DialectOptionHolder dialect) {
        String className;
        PsiElement result;
        boolean clazzShouldBeTakenFromOurLibrary;
        if (link == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "link", "com/intellij/javascript/flex/resolve/ActionScriptClassResolver", "doFindClassByQName"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/javascript/flex/resolve/ActionScriptClassResolver", "doFindClassByQName"));
        }
        Project project = index.getProject();
        boolean bl = clazzShouldBeTakenFromOurLibrary = "Object".equals(link) || "Arguments".equals(link);
        if (clazzShouldBeTakenFromOurLibrary && !(searchScope instanceof AdditionalIndexedRootsScope)) {
            searchScope = new AdditionalIndexedRootsScope(searchScope, JSIndexedRootProvider.class);
        }
        Collection candidates = StubIndex.getElements((StubIndexKey)JSQualifiedElementIndex.KEY, (Object)link.hashCode(), (Project)project, (GlobalSearchScope)searchScope, JSQualifiedNamedElement.class);
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        PsiElement resultFromSourceContent = null;
        PsiElement resultFromLibraries = null;
        long resultFromLibrariesTimestamp = 0L;
        for (Object _clazz : candidates) {
            long classTimestamp;
            PsiFile file;
            JSQualifiedNamedElement clazz;
            if (!(_clazz instanceof JSQualifiedNamedElement) || _clazz instanceof JSFunction && ((JSFunction)_clazz).isConstructor() || !link.equals((clazz = (JSQualifiedNamedElement)_clazz).getQualifiedName()) || !(file = clazz.getContainingFile()).getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)) continue;
            VirtualFile vFile = file.getVirtualFile();
            if (clazzShouldBeTakenFromOurLibrary && !"ECMAScript.js2".equals(vFile.getName()) || !allowFileLocalSymbols && JSResolveUtil.isFileLocalSymbol((PsiElement)clazz)) continue;
            if (projectFileIndex.isInSourceContent(vFile)) {
                resultFromSourceContent = clazz;
                continue;
            }
            if (resultFromLibraries == null) {
                resultFromLibraries = clazz;
                continue;
            }
            if ("Vector".equals(link)) {
                if (!(clazz instanceof JSClass) || !(resultFromLibraries instanceof JSClass) || ((JSClass)clazz).getFunctions().length <= ((JSClass)resultFromLibraries).getFunctions().length) continue;
                resultFromLibraries = clazz;
                continue;
            }
            if (resultFromLibrariesTimestamp == 0L) {
                resultFromLibrariesTimestamp = ActionScriptClassResolver.getResolveResultTimestamp((PsiElement)resultFromLibraries);
            }
            if ((classTimestamp = ActionScriptClassResolver.getResolveResultTimestamp((PsiElement)clazz)) <= resultFromLibrariesTimestamp) continue;
            resultFromLibraries = clazz;
            resultFromLibrariesTimestamp = classTimestamp;
        }
        PsiElement psiElement = result = resultFromSourceContent != null ? resultFromSourceContent : resultFromLibraries;
        if (result == null && (className = link.substring(link.lastIndexOf(46) + 1)).length() > 0 && !ActionScriptClassResolver.isBuiltInClassName(className) && (Character.isLetter(className.charAt(0)) || '_' == className.charAt(0))) {
            result = ActionScriptClassResolver.findClassByQNameViaHelper(link, project, className, searchScope);
        }
        return result;
    }

    private static boolean isBuiltInClassName(String className) {
        return "Object".equals(className) || "Boolean".equals(className) || "Function".equals(className) || "String".equals(className);
    }

    @Nullable
    private static PsiElement findClassByQNameViaHelper(String link, Project project, String className, GlobalSearchScope scope) {
        for (JSResolveHelper helper : (JSResolveHelper[])Extensions.getExtensions((ExtensionPointName)JSResolveHelper.EP_NAME)) {
            PsiElement result = helper.findClassByQName(link, project, className, scope);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

