/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.build;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.flex.FlexCommonBundle;
import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.build.FlexCompilerConfigFileUtilBase;
import com.intellij.flex.model.bc.BuildConfigurationNature;
import com.intellij.flex.model.bc.CompilerOptionInfo;
import com.intellij.flex.model.bc.ComponentSet;
import com.intellij.flex.model.bc.LinkageType;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.flex.model.bc.ValueSource;
import com.intellij.flex.model.sdk.RslUtil;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.build.FlexCompilationManager;
import com.intellij.lang.javascript.flex.build.FlexCompilerConfigFileUtil;
import com.intellij.lang.javascript.flex.build.FlexCompilerHandler;
import com.intellij.lang.javascript.flex.build.InfoFromConfigFile;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitPrecompileTask;
import com.intellij.lang.javascript.flex.projectStructure.FlexProjectLevelCompilerOptionsHolder;
import com.intellij.lang.javascript.flex.projectStructure.model.AirDesktopPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.AndroidPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.BuildConfigurationEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.CompilerOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.DependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.lang.javascript.flex.projectStructure.model.IosPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.ModuleLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.SharedLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.lang.javascript.flex.projectStructure.options.FlexProjectRootsUtil;
import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.lang.javascript.flex.sdk.FlexmojosSdkType;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedElementIndex;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SystemProperties;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerConfigGenerator {
    private static final String[] LIB_ORDER = new String[]{"framework", "textLayout", "osmf", "spark", "sparkskins", "rpc", "charts", "spark_dmv", "mx", "advancedgrids"};
    private final Module myModule;
    private final FlexBuildConfiguration myBC;
    private final boolean myFlexUnit;
    private final boolean myCSS;
    private final Sdk mySdk;
    private final boolean myFlexmojos;
    private final CompilerOptions myModuleLevelCompilerOptions;
    private final CompilerOptions myProjectLevelCompilerOptions;

    private CompilerConfigGenerator(@NotNull Module module, @NotNull FlexBuildConfiguration bc, @NotNull CompilerOptions moduleLevelCompilerOptions, @NotNull CompilerOptions projectLevelCompilerOptions) throws IOException {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/flex/build/CompilerConfigGenerator", "<init>"));
        }
        if (bc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bc", "com/intellij/lang/javascript/flex/build/CompilerConfigGenerator", "<init>"));
        }
        if (moduleLevelCompilerOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleLevelCompilerOptions", "com/intellij/lang/javascript/flex/build/CompilerConfigGenerator", "<init>"));
        }
        if (projectLevelCompilerOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectLevelCompilerOptions", "com/intellij/lang/javascript/flex/build/CompilerConfigGenerator", "<init>"));
        }
        this.myModule = module;
        this.myBC = bc;
        this.myFlexUnit = BCUtils.isFlexUnitBC(this.myBC);
        this.myCSS = BCUtils.isRuntimeStyleSheetBC(bc);
        this.mySdk = bc.getSdk();
        if (this.mySdk == null) {
            throw new IOException(FlexCommonBundle.message((String)"sdk.not.set.for.bc.0.of.module.1", (Object[])new Object[]{bc.getName(), module.getName()}));
        }
        this.myFlexmojos = this.mySdk.getSdkType() == FlexmojosSdkType.getInstance();
        this.myModuleLevelCompilerOptions = moduleLevelCompilerOptions;
        this.myProjectLevelCompilerOptions = projectLevelCompilerOptions;
    }

    public static VirtualFile getOrCreateConfigFile(Module module, FlexBuildConfiguration bc) throws IOException {
        CompilerConfigGenerator generator = new CompilerConfigGenerator(module, bc, FlexBuildConfigurationManager.getInstance(module).getModuleLevelCompilerOptions(), FlexProjectLevelCompilerOptionsHolder.getInstance(module.getProject()).getProjectLevelCompilerOptions());
        String text = generator.generateConfigFileText();
        if (bc.isTempBCForCompilation()) {
            FlexBuildConfiguration originalBC = FlexBuildConfigurationManager.getInstance(module).findConfigurationByName(bc.getName());
            boolean makeExternalLibsMerged = BCUtils.isFlexUnitBC(bc) || originalBC != null && originalBC.getOutputType() == OutputType.Library;
            boolean makeIncludedLibsMerged = BCUtils.isRuntimeStyleSheetBC(bc);
            text = FlexCompilerConfigFileUtilBase.mergeWithCustomConfigFile((String)text, (String)bc.getCompilerOptions().getAdditionalConfigFilePath(), (boolean)makeExternalLibsMerged, (boolean)makeIncludedLibsMerged);
        }
        String name = CompilerConfigGenerator.getConfigFileName(module, bc.getName(), PlatformUtils.getPlatformPrefix().toLowerCase(), BCUtils.getBCSpecifier(bc));
        return CompilerConfigGenerator.getOrCreateConfigFile(name, text);
    }

    private String generateConfigFileText() throws IOException {
        Element rootElement = new Element("flex-config", "http://www.adobe.com/2006/flex-config");
        this.addMandatoryOptions(rootElement);
        this.addSourcePaths(rootElement);
        if (!this.myFlexmojos) {
            this.handleOptionsWithSpecialValues(rootElement);
            this.addNamespaces(rootElement);
            this.addRootsFromSdk(rootElement);
        }
        this.addLibs(rootElement);
        this.addOtherOptions(rootElement);
        this.addInputOutputPaths(rootElement);
        return JDOMUtil.writeElement((Element)rootElement, (String)"\n");
    }

    private void addMandatoryOptions(Element rootElement) {
        if (!BCUtils.isRLMTemporaryBC(this.myBC) && !BCUtils.isRuntimeStyleSheetBC(this.myBC) && BCUtils.canHaveRLMsAndRuntimeStylesheets(this.myBC) && this.myBC.getRLMs().size() > 0) {
            this.addOption(rootElement, CompilerOptionInfo.LINK_REPORT_INFO, CompilerConfigGenerator.getLinkReportFilePath(this.myModule, this.myBC.getName()));
        }
        if (BCUtils.isRLMTemporaryBC(this.myBC) && !this.myBC.getOptimizeFor().isEmpty()) {
            String customLinkReportPath = CompilerConfigGenerator.getCustomLinkReportPath(this.myModule, this.myBC);
            String linkReportPath = StringUtil.notNullize((String)customLinkReportPath, (String)CompilerConfigGenerator.getLinkReportFilePath(this.myModule, this.myBC.getName()));
            this.addOption(rootElement, CompilerOptionInfo.LOAD_EXTERNS_INFO, linkReportPath);
        }
        this.addOption(rootElement, CompilerOptionInfo.WARN_NO_CONSTRUCTOR_INFO, "false");
        if (this.myFlexmojos) {
            return;
        }
        BuildConfigurationNature nature = this.myBC.getNature();
        String targetPlayer = nature.isWebPlatform() ? this.myBC.getDependencies().getTargetPlayer() : FlexCommonUtils.getMaximumTargetPlayer((String)this.mySdk.getHomePath());
        this.addOption(rootElement, CompilerOptionInfo.TARGET_PLAYER_INFO, targetPlayer);
        if (FlexSdkUtils.isAirSdkWithoutFlex(this.mySdk) || StringUtil.compareVersionNumbers((String)this.mySdk.getVersionString(), (String)"4.5") >= 0) {
            String swfVersion;
            if (nature.isWebPlatform()) {
                swfVersion = FlexCommonUtils.getSwfVersionForTargetPlayer((String)targetPlayer);
            } else {
                String airVersion = CompilerConfigGenerator.getAirVersionIfCustomDescriptor(this.myBC);
                if (airVersion == null) {
                    airVersion = FlexCommonUtils.getAirVersion((String)this.mySdk.getHomePath(), (String)this.mySdk.getVersionString());
                }
                swfVersion = airVersion != null ? FlexCommonUtils.getSwfVersionForAirVersion((String)airVersion) : FlexCommonUtils.getSwfVersionForSdk_THE_WORST_WAY((String)this.mySdk.getVersionString());
            }
            this.addOption(rootElement, CompilerOptionInfo.SWF_VERSION_INFO, swfVersion);
        }
        if (nature.isMobilePlatform()) {
            this.addOption(rootElement, CompilerOptionInfo.MOBILE_INFO, "true");
            this.addOption(rootElement, CompilerOptionInfo.PRELOADER_INFO, "spark.preloaders.SplashScreen");
        }
        if (!FlexSdkUtils.isAirSdkWithoutFlex(this.mySdk)) {
            String accessible = nature.isMobilePlatform() ? "false" : (StringUtil.compareVersionNumbers((String)this.mySdk.getVersionString(), (String)"4") >= 0 ? "true" : "false");
            this.addOption(rootElement, CompilerOptionInfo.ACCESSIBLE_INFO, accessible);
            String fontManagers = StringUtil.compareVersionNumbers((String)this.mySdk.getVersionString(), (String)"4") >= 0 ? "flash.fonts.JREFontManager\nflash.fonts.BatikFontManager\nflash.fonts.AFEFontManager\nflash.fonts.CFFFontManager" : "flash.fonts.JREFontManager\nflash.fonts.AFEFontManager\nflash.fonts.BatikFontManager";
            this.addOption(rootElement, CompilerOptionInfo.FONT_MANAGERS_INFO, fontManagers);
            this.addOption(rootElement, CompilerOptionInfo.STATIC_RSLS_INFO, "false");
        }
    }

    @Nullable
    private static String getAirVersionIfCustomDescriptor(FlexBuildConfiguration bc) {
        if (bc.getTargetPlatform() == TargetPlatform.Desktop) {
            AirDesktopPackagingOptions packagingOptions = bc.getAirDesktopPackagingOptions();
            if (!packagingOptions.isUseGeneratedDescriptor()) {
                return FlexCommonUtils.parseAirVersionFromDescriptorFile((String)packagingOptions.getCustomDescriptorPath());
            }
        } else if (bc.getTargetPlatform() == TargetPlatform.Mobile) {
            AndroidPackagingOptions androidOptions = bc.getAndroidPackagingOptions();
            IosPackagingOptions iosPackagingOptions = bc.getIosPackagingOptions();
            if (androidOptions.isEnabled() && androidOptions.isUseGeneratedDescriptor() || iosPackagingOptions.isEnabled() && iosPackagingOptions.isUseGeneratedDescriptor()) {
                return null;
            }
            String androidAirVersion = null;
            String iosAirVersion = null;
            if (androidOptions.isEnabled() && !androidOptions.isUseGeneratedDescriptor()) {
                androidAirVersion = FlexCommonUtils.parseAirVersionFromDescriptorFile((String)androidOptions.getCustomDescriptorPath());
            }
            if (iosPackagingOptions.isEnabled() && !iosPackagingOptions.isUseGeneratedDescriptor()) {
                iosAirVersion = FlexCommonUtils.parseAirVersionFromDescriptorFile((String)iosPackagingOptions.getCustomDescriptorPath());
            }
            if (androidAirVersion == null) {
                return iosAirVersion;
            }
            if (iosAirVersion == null) {
                return androidAirVersion;
            }
            return StringUtil.compareVersionNumbers((String)androidAirVersion, (String)iosAirVersion) > 0 ? iosAirVersion : androidAirVersion;
        }
        return null;
    }

    @Nullable
    private static String getCustomLinkReportPath(Module module, FlexBuildConfiguration rlmBC) {
        FlexBuildConfiguration appBC = FlexBuildConfigurationManager.getInstance(module).findConfigurationByName(rlmBC.getName());
        if (appBC != null) {
            List linkReports = FlexCommonUtils.getOptionValues((String)appBC.getCompilerOptions().getAdditionalOptions(), (String[])new String[]{"link-report"});
            if (!linkReports.isEmpty()) {
                String path = (String)linkReports.get(0);
                if (new File(path).isFile()) {
                    return path;
                }
                String absPath = FlexUtils.getFlexCompilerWorkDirPath(module.getProject(), null) + "/" + path;
                if (new File(absPath).isFile()) {
                    return absPath;
                }
            } else {
                VirtualFile configFile;
                String configFilePath = appBC.getCompilerOptions().getAdditionalConfigFilePath();
                if (!configFilePath.isEmpty() && (configFile = LocalFileSystem.getInstance().findFileByPath(configFilePath)) != null) {
                    try {
                        String path = FlexUtils.findXMLElement(configFile.getInputStream(), "<flex-config><link-report>");
                        if (path != null) {
                            if (new File(path = path.trim()).isFile()) {
                                return path;
                            }
                            for (VirtualFile srcRoot : ModuleRootManager.getInstance((Module)module).getSourceRoots()) {
                                String absPath = srcRoot.getPath() + "/" + path;
                                if (!new File(absPath).isFile()) continue;
                                return absPath;
                            }
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    private void handleOptionsWithSpecialValues(Element rootElement) {
        for (CompilerOptionInfo info : CompilerOptionInfo.getOptionsWithSpecialValues()) {
            boolean themeForPureAS;
            Pair<String, ValueSource> valueAndSource = this.getValueAndSource(info);
            boolean bl = themeForPureAS = this.myBC.isPureAs() && "compiler.theme".equals(info.ID);
            if (valueAndSource.second != ValueSource.GlobalDefault || ((String)valueAndSource.first).isEmpty() && !themeForPureAS) continue;
            this.addOption(rootElement, info, (String)valueAndSource.first);
        }
    }

    private void addNamespaces(Element rootElement) {
        StringBuilder namespaceBuilder = new StringBuilder();
        FlexSdkUtils.processStandardNamespaces(this.myBC, (PairConsumer<String, String>)((PairConsumer)(namespace, relativePath) -> {
            if (namespaceBuilder.length() > 0) {
                namespaceBuilder.append("\n");
            }
            namespaceBuilder.append((String)namespace).append("\t").append("${FLEX_SDK}/").append((String)relativePath);
        }));
        if (namespaceBuilder.length() == 0) {
            return;
        }
        CompilerOptionInfo info = CompilerOptionInfo.getOptionInfo((String)"compiler.namespaces.namespace");
        this.addOption(rootElement, info, namespaceBuilder.toString());
    }

    private void addRootsFromSdk(Element rootElement) {
        String theme;
        CompilerOptionInfo localeInfo = CompilerOptionInfo.getOptionInfo((String)"compiler.locale");
        if (!((String)this.getValueAndSource((CompilerOptionInfo)localeInfo).first).isEmpty()) {
            this.addOption(rootElement, CompilerOptionInfo.LIBRARY_PATH_INFO, this.mySdk.getHomePath() + "/frameworks/locale/{locale}");
        }
        THashMap libNameToRslInfo = new THashMap();
        for (String swcUrl : this.mySdk.getRootProvider().getUrls(OrderRootType.CLASSES)) {
            List rslUrls;
            CompilerOptionInfo info;
            String swcPath = VirtualFileManager.extractPath((String)StringUtil.trimEnd((String)swcUrl, (String)"!/"));
            if (!swcPath.toLowerCase().endsWith(".swc")) {
                Logger.getInstance((String)CompilerConfigGenerator.class.getName()).warn("Unexpected URL in Flex SDK classes: " + swcUrl);
                continue;
            }
            LinkageType linkageType = BCUtils.getSdkEntryLinkageType(swcPath, this.myBC);
            if (linkageType == null) continue;
            if (linkageType == LinkageType.Default) {
                linkageType = this.myBC.getDependencies().getFrameworkLinkage();
            }
            if (linkageType == LinkageType.Default) {
                linkageType = FlexCommonUtils.getDefaultFrameworkLinkage((String)this.mySdk.getVersionString(), (BuildConfigurationNature)this.myBC.getNature());
            }
            if (this.myCSS && linkageType == LinkageType.Include) {
                linkageType = LinkageType.Merged;
            }
            Object object = linkageType == LinkageType.Merged ? CompilerOptionInfo.LIBRARY_PATH_INFO : (linkageType == LinkageType.RSL ? CompilerOptionInfo.LIBRARY_PATH_INFO : (linkageType == LinkageType.External ? CompilerOptionInfo.EXTERNAL_LIBRARY_INFO : (info = linkageType == LinkageType.Include ? CompilerOptionInfo.INCLUDE_LIBRARY_INFO : null)));
            assert (info != null) : swcPath + ": " + linkageType.getShortText();
            this.addOption(rootElement, info, swcPath);
            if (linkageType != LinkageType.RSL || (rslUrls = RslUtil.getRslUrls((String)this.mySdk.getHomePath(), (String)swcPath)).isEmpty()) continue;
            StringBuilder rslBuilder = new StringBuilder();
            String firstUrl = (String)rslUrls.get(0);
            rslBuilder.append(swcPath).append("\t").append(firstUrl).append("\t");
            if (firstUrl.startsWith("http://")) {
                rslBuilder.append("http://fpdownload.adobe.com/pub/swz/crossdomain.xml");
            }
            if (rslUrls.size() > 1) {
                String secondUrl = (String)rslUrls.get(1);
                rslBuilder.append("\t").append(secondUrl).append("\t");
                if (secondUrl.startsWith("http://")) {
                    rslBuilder.append("http://fpdownload.adobe.com/pub/swz/crossdomain.xml");
                }
            }
            String swcName = PathUtil.getFileName((String)swcPath);
            String libName = swcName.substring(0, swcName.length() - ".swc".length());
            libNameToRslInfo.put(libName, rslBuilder.toString());
        }
        if (this.myBC.getNature().isLib() && (theme = (String)this.getValueAndSource((CompilerOptionInfo)CompilerOptionInfo.getOptionInfo((String)"compiler.theme")).first) != null && theme.toLowerCase().endsWith(".swc")) {
            this.addOption(rootElement, CompilerOptionInfo.LIBRARY_PATH_INFO, theme);
        }
        this.addRslInfo(rootElement, (Map<String, String>)libNameToRslInfo);
    }

    private void addRslInfo(Element rootElement, Map<String, String> libNameToRslInfo) {
        if (libNameToRslInfo.isEmpty()) {
            return;
        }
        for (String libName : LIB_ORDER) {
            String rslInfo = libNameToRslInfo.remove(libName);
            if (rslInfo == null) continue;
            CompilerOptionInfo option = StringUtil.split((String)rslInfo, (String)"\t", (boolean)true, (boolean)false).size() == 3 ? CompilerOptionInfo.RSL_ONE_URL_PATH_INFO : CompilerOptionInfo.RSL_TWO_URLS_PATH_INFO;
            this.addOption(rootElement, option, rslInfo);
        }
        for (String rslInfo : libNameToRslInfo.values()) {
            CompilerOptionInfo option = StringUtil.split((String)rslInfo, (String)"\t", (boolean)true, (boolean)false).size() == 3 ? CompilerOptionInfo.RSL_ONE_URL_PATH_INFO : CompilerOptionInfo.RSL_TWO_URLS_PATH_INFO;
            this.addOption(rootElement, option, rslInfo);
        }
    }

    private void addLibs(Element rootElement) {
        for (DependencyEntry entry : this.myBC.getDependencies().getEntries()) {
            Library library;
            LinkageType linkageType = entry.getDependencyType().getLinkageType();
            if (linkageType == LinkageType.Test) {
                if (!this.myFlexUnit) continue;
                linkageType = LinkageType.Merged;
            }
            if (this.myCSS && linkageType == LinkageType.Include) {
                linkageType = LinkageType.Merged;
            }
            if (entry instanceof BuildConfigurationEntry) {
                FlexBuildConfiguration dependencyBC;
                if (linkageType == LinkageType.LoadInRuntime || (dependencyBC = ((BuildConfigurationEntry)entry).findBuildConfiguration()) == null || !FlexCommonUtils.checkDependencyType((OutputType)this.myBC.getOutputType(), (OutputType)dependencyBC.getOutputType(), (LinkageType)linkageType)) continue;
                this.addLib(rootElement, dependencyBC.getActualOutputFilePath(), linkageType);
                continue;
            }
            if (entry instanceof ModuleLibraryEntry) {
                LibraryOrderEntry orderEntry = FlexProjectRootsUtil.findOrderEntry((ModuleLibraryEntry)entry, (ModuleRootModel)ModuleRootManager.getInstance((Module)this.myModule));
                if (orderEntry == null) continue;
                this.addLibraryRoots(rootElement, orderEntry.getRootFiles(OrderRootType.CLASSES), linkageType);
                continue;
            }
            if (!(entry instanceof SharedLibraryEntry) || (library = FlexProjectRootsUtil.findOrderEntry(this.myModule.getProject(), (SharedLibraryEntry)entry)) == null) continue;
            this.addLibraryRoots(rootElement, library.getFiles(OrderRootType.CLASSES), linkageType);
        }
        if (this.myFlexUnit) {
            Collection flexUnitLibNames = FlexCommonUtils.getFlexUnitSupportLibNames((BuildConfigurationNature)this.myBC.getNature(), (ComponentSet)this.myBC.getDependencies().getComponentSet(), (String)CompilerConfigGenerator.getPathToFlexUnitMainClass(this.myModule.getProject(), this.myBC.getNature(), this.myBC.getMainClass()));
            for (String libName : flexUnitLibNames) {
                String libPath = FlexCommonUtils.getPathToBundledJar((String)libName);
                VirtualFile file = LocalFileSystem.getInstance().findFileByPath(libPath);
                assert (file != null);
                this.addLibraryRoots(rootElement, new VirtualFile[]{file}, LinkageType.Merged);
            }
        }
    }

    private void addLibraryRoots(Element rootElement, VirtualFile[] libClassRoots, LinkageType linkageType) {
        for (VirtualFile libFile : libClassRoots) {
            String libFileName;
            if ((libFile = FlexCompilerHandler.getRealFile(libFile)) == null) continue;
            if (libFile.isDirectory()) {
                this.addOption(rootElement, CompilerOptionInfo.SOURCE_PATH_INFO, libFile.getPath());
                continue;
            }
            if ("ane".equalsIgnoreCase(libFile.getExtension())) {
                this.addLib(rootElement, libFile.getPath(), LinkageType.External);
                continue;
            }
            if (!"swc".equalsIgnoreCase(libFile.getExtension()) || (libFileName = libFile.getName().toLowerCase()).startsWith("airglobal") && !libFileName.equals("airglobal.swc") || libFileName.startsWith("playerglobal") && !libFileName.equals("playerglobal.swc")) continue;
            this.addLib(rootElement, libFile.getPath(), linkageType);
        }
    }

    private void addLib(Element rootElement, String swcPath, LinkageType linkageType) {
        CompilerOptionInfo info;
        Object object = linkageType == LinkageType.Merged || linkageType == LinkageType.RSL ? CompilerOptionInfo.LIBRARY_PATH_INFO : (linkageType == LinkageType.External ? CompilerOptionInfo.EXTERNAL_LIBRARY_INFO : (info = linkageType == LinkageType.Include ? CompilerOptionInfo.INCLUDE_LIBRARY_INFO : null));
        assert (info != null) : swcPath + ": " + linkageType;
        this.addOption(rootElement, info, swcPath);
        if (linkageType == LinkageType.RSL) {
            // empty if block
        }
    }

    private void addSourcePaths(Element rootElement) {
        String cssFolderPath;
        String localeValue = (String)this.getValueAndSource((CompilerOptionInfo)CompilerOptionInfo.getOptionInfo((String)"compiler.locale")).first;
        List locales = StringUtil.split((String)localeValue, (String)"\n");
        locales.addAll(FlexCommonUtils.getOptionValues((String)this.myProjectLevelCompilerOptions.getAdditionalOptions(), (String[])new String[]{"locale", "compiler.locale"}));
        locales.addAll(FlexCommonUtils.getOptionValues((String)this.myModuleLevelCompilerOptions.getAdditionalOptions(), (String[])new String[]{"locale", "compiler.locale"}));
        locales.addAll(FlexCommonUtils.getOptionValues((String)this.myBC.getCompilerOptions().getAdditionalOptions(), (String[])new String[]{"locale", "compiler.locale"}));
        THashSet sourcePathsWithLocaleToken = new THashSet();
        LinkedList<String> sourcePathsWithoutLocaleToken = new LinkedList<String>();
        for (VirtualFile sourceRoot : ModuleRootManager.getInstance((Module)this.myModule).getSourceRoots(this.includeTestRoots())) {
            if (locales.contains(sourceRoot.getName())) {
                sourcePathsWithLocaleToken.add(sourceRoot.getParent().getPath() + "/" + "{locale}");
                continue;
            }
            sourcePathsWithoutLocaleToken.add(sourceRoot.getPath());
        }
        StringBuilder sourcePathBuilder = new StringBuilder();
        if (this.myCSS && !sourcePathsWithoutLocaleToken.contains(cssFolderPath = PathUtil.getParentPath((String)this.myBC.getMainClass()))) {
            sourcePathBuilder.append(cssFolderPath);
        }
        for (String sourcePath : sourcePathsWithLocaleToken) {
            if (sourcePathBuilder.length() > 0) {
                sourcePathBuilder.append("\n");
            }
            sourcePathBuilder.append(sourcePath);
        }
        for (String sourcePath : sourcePathsWithoutLocaleToken) {
            if (sourcePathBuilder.length() > 0) {
                sourcePathBuilder.append("\n");
            }
            sourcePathBuilder.append(sourcePath);
        }
        this.addOption(rootElement, CompilerOptionInfo.SOURCE_PATH_INFO, sourcePathBuilder.toString());
    }

    private boolean includeTestRoots() {
        if (this.myFlexUnit) {
            return true;
        }
        if (this.myCSS) {
            return false;
        }
        if (this.myBC.getOutputType() != OutputType.Application) {
            return false;
        }
        String path = FlexUtils.getPathToMainClassFile(this.myBC.getMainClass(), this.myModule);
        VirtualFile file = path.isEmpty() ? null : LocalFileSystem.getInstance().findFileByPath(path);
        return file != null && ModuleRootManager.getInstance((Module)this.myModule).getFileIndex().isInTestSourceContent(file);
    }

    private void addOtherOptions(Element rootElement) {
        THashMap options = new THashMap(this.myProjectLevelCompilerOptions.getAllOptions());
        options.putAll(this.myModuleLevelCompilerOptions.getAllOptions());
        options.putAll(this.myBC.getCompilerOptions().getAllOptions());
        String addOptions = this.myProjectLevelCompilerOptions.getAdditionalOptions() + " " + this.myModuleLevelCompilerOptions.getAdditionalOptions() + " " + this.myBC.getCompilerOptions().getAdditionalOptions();
        List contextRootInAddOptions = FlexCommonUtils.getOptionValues((String)addOptions, (String[])new String[]{"context-root", "compiler.context-root"});
        if (options.get("compiler.context-root") == null && contextRootInAddOptions.isEmpty()) {
            List servicesInAddOptions = FlexCommonUtils.getOptionValues((String)addOptions, (String[])new String[]{"services", "compiler.services"});
            if (options.get("compiler.services") != null || !servicesInAddOptions.isEmpty()) {
                options.put("compiler.context-root", "");
            }
        }
        for (Map.Entry entry : options.entrySet()) {
            this.addOption(rootElement, CompilerOptionInfo.getOptionInfo((String)((String)entry.getKey())), (String)entry.getValue());
        }
        String namespacesRaw = (String)options.get("compiler.namespaces.namespace");
        if (namespacesRaw != null && this.myBC.getOutputType() == OutputType.Library) {
            String namespaces = FlexUtils.replacePathMacros(namespacesRaw, this.myModule, this.myFlexmojos ? "" : this.mySdk.getHomePath());
            StringBuilder buf = new StringBuilder();
            for (String listEntry : StringUtil.split((String)namespaces, (String)"\n")) {
                int tabIndex = listEntry.indexOf("\t");
                assert (tabIndex != -1) : namespaces;
                String namespace = listEntry.substring(0, tabIndex);
                if (buf.length() > 0) {
                    buf.append("\n");
                }
                buf.append(namespace);
            }
            if (buf.length() > 0) {
                this.addOption(rootElement, CompilerOptionInfo.INCLUDE_NAMESPACES_INFO, buf.toString());
            }
        }
    }

    private void addInputOutputPaths(Element rootElement) throws IOException {
        if (this.myBC.getOutputType() == OutputType.Library) {
            this.addFilesIncludedInSwc(rootElement);
            if (!this.myFlexmojos) {
                this.addLibClasses(rootElement);
            }
        } else {
            String pathToMainClassFile;
            InfoFromConfigFile info = FlexCompilerConfigFileUtil.getInfoFromConfigFile(this.myBC.getCompilerOptions().getAdditionalConfigFilePath());
            String string = this.myCSS ? this.myBC.getMainClass() : (pathToMainClassFile = this.myFlexUnit ? CompilerConfigGenerator.getPathToFlexUnitMainClass(this.myModule.getProject(), this.myBC.getNature(), this.myBC.getMainClass()) : FlexUtils.getPathToMainClassFile(this.myBC.getMainClass(), this.myModule));
            if (pathToMainClassFile.isEmpty() && info.getMainClass(this.myModule) == null && !ApplicationManager.getApplication().isUnitTestMode()) {
                throw new IOException(FlexCommonBundle.message((String)"bc.incorrect.main.class", (Object[])new Object[]{this.myBC.getMainClass(), this.myBC.getName(), this.myModule.getName()}));
            }
            if (!pathToMainClassFile.isEmpty()) {
                this.addOption(rootElement, CompilerOptionInfo.MAIN_CLASS_INFO, FileUtil.toSystemIndependentName((String)pathToMainClassFile));
            }
        }
        this.addOption(rootElement, CompilerOptionInfo.OUTPUT_PATH_INFO, this.myBC.getActualOutputFilePath());
    }

    private void addFilesIncludedInSwc(Element rootElement) {
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myModule.getProject()).getFileIndex();
        final CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)this.myModule.getProject());
        THashMap filePathToPathInSwc = new THashMap();
        for (String string : this.myBC.getCompilerOptions().getFilesToIncludeInSWC()) {
            VirtualFile srcRoot;
            final VirtualFile fileOrDir = LocalFileSystem.getInstance().findFileByPath(string);
            if (fileOrDir == null || compilerConfiguration.isExcludedFromCompilation(fileOrDir) || FileTypeManager.getInstance().isFileIgnored(fileOrDir)) continue;
            if (fileOrDir.isDirectory()) {
                String baseRelativePath;
                srcRoot = fileIndex.getModuleForFile(fileOrDir) == this.myModule ? fileIndex.getSourceRootForFile(fileOrDir) : null;
                String string2 = baseRelativePath = srcRoot == null ? fileOrDir.getName() : VfsUtilCore.getRelativePath((VirtualFile)fileOrDir, (VirtualFile)srcRoot, (char)'/');
                assert (baseRelativePath != null);
                VfsUtilCore.visitChildrenRecursively((VirtualFile)fileOrDir, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0], (Map)filePathToPathInSwc){
                    final /* synthetic */ Map val$filePathToPathInSwc;
                    {
                        this.val$filePathToPathInSwc = map;
                        super(arg0);
                    }

                    public boolean visitFile(@NotNull VirtualFile file) {
                        if (file == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flex/build/CompilerConfigGenerator$1", "visitFile"));
                        }
                        if (FileTypeManager.getInstance().isFileIgnored(file)) {
                            return false;
                        }
                        if (!(file.isDirectory() || FlexCommonUtils.isSourceFile((String)file.getName()) || compilerConfiguration.isExcludedFromCompilation(file))) {
                            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)fileOrDir, (char)'/');
                            String pathInSwc = baseRelativePath.isEmpty() ? relativePath : baseRelativePath + "/" + relativePath;
                            this.val$filePathToPathInSwc.put(file.getPath(), pathInSwc);
                        }
                        return true;
                    }
                });
                continue;
            }
            srcRoot = fileIndex.getSourceRootForFile(fileOrDir);
            String relativePath = srcRoot == null ? null : VfsUtilCore.getRelativePath((VirtualFile)fileOrDir, (VirtualFile)srcRoot, (char)'/');
            String pathInSwc = StringUtil.notNullize((String)relativePath, (String)fileOrDir.getName());
            filePathToPathInSwc.put(fileOrDir.getPath(), pathInSwc);
        }
        for (Map.Entry entry : filePathToPathInSwc.entrySet()) {
            String value = (String)entry.getValue() + "\t" + (String)entry.getKey();
            this.addOption(rootElement, CompilerOptionInfo.INCLUDE_FILE_INFO, value);
        }
    }

    private void addLibClasses(final Element rootElement) throws IOException {
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myModule.getProject()).getFileIndex();
        final CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)this.myModule.getProject());
        final Ref noClasses = new Ref((Object)true);
        for (final VirtualFile sourceRoot : ModuleRootManager.getInstance((Module)this.myModule).getSourceRoots(false)) {
            fileIndex.iterateContentUnderDirectory(sourceRoot, new ContentIterator(){

                public boolean processFile(VirtualFile file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    if (!FlexCommonUtils.isSourceFile((String)file.getName())) {
                        return true;
                    }
                    if (compilerConfiguration.isExcludedFromCompilation(file)) {
                        return true;
                    }
                    String packageText = VfsUtilCore.getRelativePath((VirtualFile)file.getParent(), (VirtualFile)sourceRoot, (char)'.');
                    assert (packageText != null) : sourceRoot.getPath() + ": " + file.getPath();
                    String qName = (packageText.length() > 0 ? packageText + "." : "") + file.getNameWithoutExtension();
                    if (CompilerConfigGenerator.isSourceFileWithPublicDeclaration(CompilerConfigGenerator.this.myModule, file, qName)) {
                        CompilerConfigGenerator.this.addOption(rootElement, CompilerOptionInfo.INCLUDE_CLASSES_INFO, qName);
                        noClasses.set((Object)false);
                    }
                    return true;
                }
            });
        }
        if (((Boolean)noClasses.get()).booleanValue() && this.myBC.getCompilerOptions().getFilesToIncludeInSWC().isEmpty() && !ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IOException(FlexCommonBundle.message((String)"nothing.to.compile.in.library", (Object[])new Object[]{this.myModule.getName(), this.myBC.getName()}));
        }
    }

    private void addOption(Element rootElement, CompilerOptionInfo info, String rawValue) {
        if (!info.isApplicable(this.mySdk.getVersionString(), this.myBC.getNature())) {
            return;
        }
        String value = FlexUtils.replacePathMacros(rawValue, this.myModule, this.myFlexmojos ? "" : this.mySdk.getHomePath());
        String pathInFlexConfig = info.ID.startsWith("compiler.debug") ? "compiler.debug" : info.ID;
        List elementNames = StringUtil.split((String)pathInFlexConfig, (String)".");
        Element parentElement = rootElement;
        for (int i1 = 0; i1 < elementNames.size() - 1; ++i1) {
            parentElement = CompilerConfigGenerator.getOrCreateElement(parentElement, (String)elementNames.get(i1));
        }
        String elementName = (String)elementNames.get(elementNames.size() - 1);
        switch (info.TYPE) {
            case Boolean: 
            case String: 
            case Int: 
            case File: {
                Element simpleElement = new Element(elementName, parentElement.getNamespace());
                simpleElement.setText(value);
                parentElement.addContent(simpleElement);
                break;
            }
            case List: {
                if (info.LIST_ELEMENTS.length == 1) {
                    Element listHolderElement = CompilerConfigGenerator.getOrCreateElement(parentElement, elementName);
                    for (String listElementValue : StringUtil.split((String)value, (String)"\n")) {
                        Element child = new Element(info.LIST_ELEMENTS[0].NAME, listHolderElement.getNamespace());
                        child.setText(listElementValue);
                        listHolderElement.addContent(child);
                    }
                } else {
                    for (String listEntry : StringUtil.split((String)value, (String)String.valueOf("\n"))) {
                        Element repeatableListHolderElement = new Element(elementName, parentElement.getNamespace());
                        List values = StringUtil.split((String)listEntry, (String)"\t", (boolean)true, (boolean)false);
                        assert (info.LIST_ELEMENTS.length == values.size()) : info.ID + "=" + value;
                        for (int i = 0; i < info.LIST_ELEMENTS.length; ++i) {
                            Element child = new Element(info.LIST_ELEMENTS[i].NAME, repeatableListHolderElement.getNamespace());
                            child.setText((String)values.get(i));
                            repeatableListHolderElement.addContent(child);
                        }
                        parentElement.addContent(repeatableListHolderElement);
                    }
                }
                break;
            }
            default: {
                assert (false) : info.DISPLAY_NAME;
                break;
            }
        }
    }

    private static Element getOrCreateElement(Element parentElement, String elementName) {
        Element child = parentElement.getChild(elementName, parentElement.getNamespace());
        if (child == null) {
            child = new Element(elementName, parentElement.getNamespace());
            parentElement.addContent(child);
        }
        return child;
    }

    private Pair<String, ValueSource> getValueAndSource(CompilerOptionInfo info) {
        assert (!info.isGroup()) : info.DISPLAY_NAME;
        String bcLevelValue = this.myBC.getCompilerOptions().getOption(info.ID);
        if (bcLevelValue != null) {
            return Pair.create((Object)bcLevelValue, (Object)ValueSource.BC);
        }
        String moduleLevelValue = this.myModuleLevelCompilerOptions.getOption(info.ID);
        if (moduleLevelValue != null) {
            return Pair.create((Object)moduleLevelValue, (Object)ValueSource.ModuleDefault);
        }
        String projectLevelValue = this.myProjectLevelCompilerOptions.getOption(info.ID);
        if (projectLevelValue != null) {
            return Pair.create((Object)projectLevelValue, (Object)ValueSource.ProjectDefault);
        }
        return Pair.create((Object)info.getDefaultValue(this.mySdk.getVersionString(), this.myBC.getNature(), this.myBC.getDependencies().getComponentSet()), (Object)ValueSource.GlobalDefault);
    }

    private static VirtualFile getOrCreateConfigFile(final String fileName, final String text) throws IOException {
        VirtualFile existingConfigFile = FlexCompilationManager.refreshAndFindFileInWriteAction(FlexCommonUtils.getTempFlexConfigsDirPath() + "/" + fileName, new String[0]);
        if (existingConfigFile != null && existingConfigFile.isValid() && Arrays.equals(text.getBytes(), existingConfigFile.contentsToByteArray())) {
            return existingConfigFile;
        }
        final Ref fileRef = new Ref();
        final Ref error = new Ref();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                fileRef.set(ApplicationManager.getApplication().runWriteAction((Computable)new NullableComputable<VirtualFile>(){

                    public VirtualFile compute() {
                        try {
                            String baseDirPath = FlexCommonUtils.getTempFlexConfigsDirPath();
                            VirtualFile baseDir = VfsUtil.createDirectories((String)baseDirPath);
                            VirtualFile configFile = baseDir.findChild(fileName);
                            if (configFile == null) {
                                configFile = baseDir.createChildData((Object)this, fileName);
                            }
                            VfsUtil.saveText((VirtualFile)configFile, (String)text);
                            return configFile;
                        }
                        catch (IOException ex) {
                            error.set((Object)ex);
                            return null;
                        }
                    }
                }));
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().invokeAndWait(runnable);
        }
        if (!error.isNull()) {
            throw (IOException)error.get();
        }
        return (VirtualFile)fileRef.get();
    }

    private static String getConfigFileName(Module module, @Nullable String bcName, String prefix, @Nullable String postfix) {
        String hash1 = Integer.toHexString((SystemProperties.getUserName() + module.getProject().getName()).hashCode()).toUpperCase();
        String hash2 = Integer.toHexString((module.getName() + StringUtil.notNullize((String)bcName)).hashCode()).toUpperCase();
        return prefix + "-" + hash1 + "-" + hash2 + (postfix == null ? ".xml" : "-" + StringUtil.replaceChar((String)postfix, (char)' ', (char)'-') + ".xml");
    }

    private static String getLinkReportFilePath(Module module, String bcName) {
        String fileName = CompilerConfigGenerator.getConfigFileName(module, bcName, PlatformUtils.getPlatformPrefix().toLowerCase(), "link-report");
        return FlexCommonUtils.getTempFlexConfigsDirPath() + "/" + fileName;
    }

    private static boolean isSourceFileWithPublicDeclaration(final Module module, final VirtualFile file, final String qName) {
        return JavaScriptSupportLoader.isMxmlOrFxgFile((VirtualFile)file) || (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                StubIndex.getInstance();
                Collection elements = StubIndex.getElements((StubIndexKey)JSQualifiedElementIndex.KEY, (Object)qName.hashCode(), (Project)module.getProject(), (GlobalSearchScope)GlobalSearchScope.moduleScope((Module)module), JSQualifiedNamedElement.class);
                if (elements.isEmpty()) {
                    PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(file);
                    return psiFile != null && PsiTreeUtil.getChildOfType((PsiElement)psiFile, JSPackageStatement.class) != null;
                }
                return true;
            }
        }) != false;
    }

    private static String getPathToFlexUnitMainClass(Project project, BuildConfigurationNature nature, String mainClass) {
        return FlexUnitPrecompileTask.getPathToFlexUnitTempDirectory(project) + "/" + mainClass + FlexCommonUtils.getFlexUnitLauncherExtension((BuildConfigurationNature)nature);
    }
}

