/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flashbuilder;

import com.intellij.flex.model.bc.OutputType;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.flashbuilder.FlashBuilderProject;
import com.intellij.lang.javascript.flex.flashbuilder.FlashBuilderSdkFinder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlashBuilderProjectLoadUtil {
    private static final String PROJECT_NAME_TAG = "<projectDescription><name>";
    private static final String ACTION_SCRIPT_PROPERTIES_TAG = "actionScriptProperties";
    private static final String FXP_PROPERTIES_TAG = "fxpProperties";
    private static final String COMPILER_TAG = "compiler";
    private static final String SWC_TAG = "swc";
    private static final String SOURCE_FOLDER_PATH_ATTR = "sourceFolderPath";
    private static final String COMPILER_SOURCE_PATH_TAG = "compilerSourcePath";
    private static final String LINKED_TAG = "linked";
    private static final String COMPILER_SOURCE_PATH_ENTRY_TAG = "compilerSourcePathEntry";
    private static final String PATH_ATTR = "path";
    private static final String PATH_ENTRY_ELEMENT = "pathEntry";
    private static final String LOCATION_ATTR = "location";
    private static final String OUTPUT_FOLDER_LOCATION_ATTR = "outputFolderLocation";
    private static final String OUTPUT_FOLDER_PATH_ATTR = "outputFolderPath";
    private static final String MAIN_APP_PATH_ATTR = "mainApplicationPath";
    private static final String TARGET_PLAYER_VERSION_ATTR = "targetPlayerVersion";
    private static final String ADDITIONAL_COMPILER_ARGUMENTS_ATTR = "additionalCompilerArguments";
    private static final String HTML_GENERATE_ATTR = "htmlGenerate";
    private static final String LIBRARY_PATH_TAG = "libraryPath";
    private static final String LIBRARY_PATH_ENTRY_TAG = "libraryPathEntry";
    private static final String LIBRARY_KIND_ATTR = "kind";
    private static final String SWC_FOLDER_KIND = "1";
    private static final String SWC_FILE_KIND = "3";
    private static final String USE_SDK_KIND = "4";
    private static final String ANE_KIND = "5";
    private static final String FLEX_SDK_ATTR = "flexSDK";
    private static final String USE_APOLLO_CONFIG_ATTR = "useApolloConfig";
    private static final String PROJECT_DESCRIPTION_TAG = "projectDescription";
    private static final String NAME_TAG = "name";
    private static final String LINKED_RESOURCES_TAG = "linkedResources";
    private static final String LINK_TAG = "link";
    private static final String LOCATION_TAG = "location";
    private static final String FLEX_LIB_PROPERTIES_TAG = "flexLibProperties";
    private static final String NAMESPACE_MANIFESTS_TAG = "namespaceManifests";
    private static final String NAMESPACE_MANIFEST_ENTRY_TAG = "namespaceManifestEntry";
    private static final String MANIFEST_ATTR = "manifest";
    private static final String NAMESPACE_ATTR = "namespace";
    private static final String APPLICATIONS_ELEMENT = "applications";
    private static final String APPLICATION_ELEMENT = "application";
    private static final String MODULES_ELEMENT = "modules";
    private static final String MODULE_ELEMENT = "module";
    private static final String DEST_PATH_ATTR = "destPath";
    private static final String OPTIMIZE_ATTR = "optimize";
    private static final String APPLICATION_ATTR = "application";
    private static final String SOURCE_PATH_ATTR = "sourcePath";
    private static final String BUILD_CSS_FILES_ELEMENT = "buildCSSFiles";
    private static final String BUILD_CSS_FILE_ENTRY_ELEMENT = "buildCSSFileEntry";
    private static final String BUILD_TARGETS_ELEMENT = "buildTargets";
    private static final String BUILD_TARGET_ELEMENT = "buildTarget";
    private static final String BUILD_TARGET_NAME_ATTR = "buildTargetName";
    private static final String MULTI_PLATFORM_SETTINGS_ELEMENT = "multiPlatformSettings";
    private static final String ENABLED_ATTR = "enabled";
    private static final String ANDROID_PLATFORM_ATTR_VALUE = "com.adobe.flexide.multiplatform.android.platform";
    private static final String IOS_PLATFORM_ATTR_VALUE = "com.adobe.flexide.multiplatform.ios.platform";
    private static final String BLACKBERRY_PLATFORM_ATTR_VALUE = "com.qnx.flexide.multiplatform.qnx.platform";
    private static final String USE_MULTIPLATFORM_CONFIG_ATTR = "useMultiPlatformConfig";
    private static final String PROVISIONING_FILE_ATTR = "provisioningFile";
    private static final String AIR_SETTINGS_ELEMENT = "airSettings";
    private static final String AIR_EXCLUDES_ELEMENT = "airExcludes";
    private static final String AIR_CERTIFICATE_ATTR = "airCertificatePath";
    private static final String INCLUDE_RESOURCES_ELEMENT = "includeResources";
    private static final String RESOURCE_ENTRY_ELEMENT = "resourceEntry";
    private static final String DEFAULT_VALUE = "default";
    private static final String PLATFORM_ID_1 = "platformId";
    private static final String PLATFORM_ID_2 = "platformID";
    private static final String USE_FLASH_SDK = "useFlashSDK";
    private static final String FLEXUNIT_LIB_MACRO = "${FLEXUNIT_LIB_LOCATION}";
    private static final String FLEXUNIT_LOCALE_MACRO = "${FLEXUNIT_LOCALE_LOCATION}";
    private static final String THEME_ELEMENT = "theme";
    public static final String DEFAULT_THEME_ATTR = "themeIsDefault";
    private static final String THEME_LOCATION_ATTR = "themeLocation";

    private FlashBuilderProjectLoadUtil() {
    }

    public static FlashBuilderProject getDummyFBProject(String name) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        FlashBuilderProject fbProject = new FlashBuilderProject();
        fbProject.setName(name);
        fbProject.setOutputType(OutputType.Library);
        return fbProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static String readProjectName(String dotProjectFilePath) {
        block15: {
            String string;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(dotProjectFilePath);
                String name = FlexUtils.findXMLElement(fis, PROJECT_NAME_TAG);
                if (StringUtil.isEmptyOrSpaces((String)name)) break block15;
                String string2 = name;
                string = string2;
            }
            catch (IOException iOException) {
                break block15;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flashbuilder/FlashBuilderProjectLoadUtil", "readProjectName"));
            }
            return string;
        }
        String string = PathUtil.getFileName((String)PathUtil.getParentPath((String)dotProjectFilePath));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flashbuilder/FlashBuilderProjectLoadUtil", "readProjectName"));
        }
        return string;
    }

    public static List<FlashBuilderProject> loadProjects(Collection<String> dotProjectFilePaths, boolean isArchive) {
        ArrayList<FlashBuilderProject> flashBuilderProjects = new ArrayList<FlashBuilderProject>(dotProjectFilePaths.size());
        for (String dotProjectFilePath : dotProjectFilePaths) {
            VirtualFile dotProjectFile = LocalFileSystem.getInstance().findFileByPath(dotProjectFilePath);
            if (dotProjectFile == null) continue;
            flashBuilderProjects.add(FlashBuilderProjectLoadUtil.loadProject(dotProjectFile, isArchive));
        }
        return flashBuilderProjects;
    }

    public static FlashBuilderProject loadProject(VirtualFile dotProjectFile, boolean isArchive) {
        FlashBuilderProject project = new FlashBuilderProject();
        FlashBuilderProjectLoadUtil.loadProjectNameAndLinkedResources(project, dotProjectFile);
        FlashBuilderProjectLoadUtil.loadOutputType(project, dotProjectFile);
        FlashBuilderProjectLoadUtil.loadProjectRoot(project, dotProjectFile);
        Map<String, String> pathReplacementMap = isArchive ? FlashBuilderProjectLoadUtil.loadMapFromDotFxpPropertiesFile(dotProjectFile) : Collections.emptyMap();
        FlashBuilderProjectLoadUtil.loadInfoFromDotActionScriptPropertiesFile(project, dotProjectFile, pathReplacementMap);
        FlashBuilderProjectLoadUtil.loadInfoFromDotFlexLibPropertiesFile(project, dotProjectFile);
        return project;
    }

    private static void loadProjectNameAndLinkedResources(FlashBuilderProject project, VirtualFile dotProjectFile) {
        try {
            Element projectDescription = JDOMUtil.load((InputStream)dotProjectFile.getInputStream());
            if (!PROJECT_DESCRIPTION_TAG.equals(projectDescription.getName())) {
                return;
            }
            String projectName = projectDescription.getChildText(NAME_TAG, projectDescription.getNamespace());
            project.setName(StringUtil.notNullize((String)projectName, (String)FlexBundle.message("unnamed", new Object[0])));
            for (Element linkedResourcesElement : projectDescription.getChildren(LINKED_RESOURCES_TAG, projectDescription.getNamespace())) {
                for (Element linkElement : linkedResourcesElement.getChildren(LINK_TAG, linkedResourcesElement.getNamespace())) {
                    String linkName = linkElement.getChildText(NAME_TAG, linkElement.getNamespace());
                    String linkLocation = linkElement.getChildText("location", linkElement.getNamespace());
                    if (StringUtil.isEmptyOrSpaces((String)linkName) || StringUtil.isEmptyOrSpaces((String)linkLocation)) continue;
                    project.addLinkedResource(linkName, FileUtil.toSystemIndependentName((String)linkLocation));
                }
            }
        }
        catch (JDOMException jDOMException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Map<String, String> loadMapFromDotFxpPropertiesFile(VirtualFile dotProjectFile) {
        THashMap result = new THashMap();
        VirtualFile dir = dotProjectFile.getParent();
        assert (dir != null);
        VirtualFile dotFxpPropertiesFile = dir.findChild(".fxpProperties");
        if (dotFxpPropertiesFile != null) {
            try {
                Element fxpPropertiesElement = JDOMUtil.load((InputStream)dotFxpPropertiesFile.getInputStream());
                if (!FXP_PROPERTIES_TAG.equals(fxpPropertiesElement.getName())) {
                    return Collections.emptyMap();
                }
                Element swcElement = fxpPropertiesElement.getChild(SWC_TAG);
                if (swcElement != null) {
                    for (Element linkedElement : swcElement.getChildren(LINKED_TAG)) {
                        String location = linkedElement.getAttributeValue("location");
                        String path = linkedElement.getAttributeValue(PATH_ATTR);
                        if (StringUtil.isEmptyOrSpaces((String)location) || StringUtil.isEmptyOrSpaces((String)path)) continue;
                        result.put(location, path);
                    }
                }
            }
            catch (JDOMException jDOMException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    private static void loadInfoFromDotActionScriptPropertiesFile(FlashBuilderProject project, VirtualFile dotProjectFile, Map<String, String> pathReplacementMap) {
        VirtualFile dir = dotProjectFile.getParent();
        assert (dir != null);
        VirtualFile dotActionScriptPropertiesFile = dir.findChild(".actionScriptProperties");
        if (dotActionScriptPropertiesFile != null) {
            try {
                Element actionScriptPropertiesElement = JDOMUtil.load((InputStream)dotActionScriptPropertiesFile.getInputStream());
                if (!ACTION_SCRIPT_PROPERTIES_TAG.equals(actionScriptPropertiesElement.getName())) {
                    return;
                }
                FlashBuilderProjectLoadUtil.loadMainClassName(project, actionScriptPropertiesElement);
                Element compilerElement = actionScriptPropertiesElement.getChild(COMPILER_TAG);
                if (compilerElement != null) {
                    FlashBuilderProjectLoadUtil.loadProjectType(project, dotProjectFile, compilerElement);
                    FlashBuilderProjectLoadUtil.loadSourcePaths(project, compilerElement);
                    FlashBuilderProjectLoadUtil.loadOutputFolderPath(project, compilerElement);
                    FlashBuilderProjectLoadUtil.loadTargetPlayerVersion(project, compilerElement);
                    FlashBuilderProjectLoadUtil.loadAdditionalCompilerArguments(project, compilerElement);
                    project.setUseHtmlWrapper("true".equals(compilerElement.getAttributeValue(HTML_GENERATE_ATTR)));
                    FlashBuilderProjectLoadUtil.loadDependenciesAndCheckIfSdkUsed(project, compilerElement, pathReplacementMap);
                    if (project.isSdkUsed()) {
                        FlashBuilderProjectLoadUtil.loadSdkName(project, compilerElement);
                    }
                }
                if (project.getOutputType() == OutputType.Application) {
                    FlashBuilderProjectLoadUtil.loadApplications(project, actionScriptPropertiesElement);
                    FlashBuilderProjectLoadUtil.loadModules(project, actionScriptPropertiesElement);
                    FlashBuilderProjectLoadUtil.loadCssFilesToCompile(project, actionScriptPropertiesElement);
                    if (!project.isPureActionScript()) {
                        FlashBuilderProjectLoadUtil.loadTheme(project, actionScriptPropertiesElement);
                    }
                }
            }
            catch (JDOMException jDOMException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void loadInfoFromDotFlexLibPropertiesFile(FlashBuilderProject project, VirtualFile dotProjectFile) {
        VirtualFile dotFlexLibPropertiesFile = dotProjectFile.getParent().findChild(".flexLibProperties");
        if (dotFlexLibPropertiesFile != null) {
            try {
                Element flexLibPropertiesElement = JDOMUtil.load((InputStream)dotFlexLibPropertiesFile.getInputStream());
                if (!FLEX_LIB_PROPERTIES_TAG.equals(flexLibPropertiesElement.getName())) {
                    return;
                }
                if (project.getTargetPlatform() == TargetPlatform.Desktop && "true".equals(flexLibPropertiesElement.getAttributeValue(USE_MULTIPLATFORM_CONFIG_ATTR))) {
                    project.setTargetPlatform(TargetPlatform.Mobile);
                }
                for (Element namespaceManifestsElement : flexLibPropertiesElement.getChildren(NAMESPACE_MANIFESTS_TAG, flexLibPropertiesElement.getNamespace())) {
                    for (Element namespaceManifestEntryElement : namespaceManifestsElement.getChildren(NAMESPACE_MANIFEST_ENTRY_TAG, namespaceManifestsElement.getNamespace())) {
                        String namespace = namespaceManifestEntryElement.getAttributeValue(NAMESPACE_ATTR);
                        String manifestPath = namespaceManifestEntryElement.getAttributeValue(MANIFEST_ATTR);
                        if (StringUtil.isEmpty((String)manifestPath) || StringUtil.isEmpty((String)namespace)) continue;
                        project.addNamespaceAndManifestPath(namespace, FileUtil.toSystemIndependentName((String)manifestPath));
                    }
                }
                for (Element includeResourcesElement : flexLibPropertiesElement.getChildren(INCLUDE_RESOURCES_ELEMENT, flexLibPropertiesElement.getNamespace())) {
                    for (Element resourceEntryElement : includeResourcesElement.getChildren(RESOURCE_ENTRY_ELEMENT, includeResourcesElement.getNamespace())) {
                        String sourcePath = resourceEntryElement.getAttributeValue(SOURCE_PATH_ATTR);
                        if (StringUtil.isEmpty((String)sourcePath)) continue;
                        project.addFileIncludedInSwc(FileUtil.toSystemIndependentName((String)sourcePath));
                    }
                }
            }
            catch (JDOMException jDOMException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void loadProjectType(FlashBuilderProject flashBuilderProject, VirtualFile dotProjectFile, Element compilerElement) {
        VirtualFile dir = dotProjectFile.getParent();
        assert (dir != null);
        VirtualFile flexLibPropertiesFile = dir.findChild(".flexLibProperties");
        boolean airSdk = "true".equals(compilerElement.getAttributeValue(USE_FLASH_SDK));
        flashBuilderProject.setAirSdk(airSdk);
        flashBuilderProject.setPureActionScript(airSdk || dir.findChild(".flexProperties") == null && flexLibPropertiesFile == null);
        if (flexLibPropertiesFile == null) {
            Element parentElement = compilerElement.getParentElement();
            for (Element buildTargetsElement : parentElement.getChildren(BUILD_TARGETS_ELEMENT, parentElement.getNamespace())) {
                for (Element buildTargetElement : buildTargetsElement.getChildren(BUILD_TARGET_ELEMENT, parentElement.getNamespace())) {
                    String buildTarget = buildTargetElement.getAttributeValue(BUILD_TARGET_NAME_ATTR);
                    String platformId1 = buildTargetElement.getAttributeValue(PLATFORM_ID_1);
                    String platformId2 = FlashBuilderProjectLoadUtil.getMultiPlatformId(buildTargetElement);
                    if (ANDROID_PLATFORM_ATTR_VALUE.equals(buildTarget) || ANDROID_PLATFORM_ATTR_VALUE.equals(platformId1) || ANDROID_PLATFORM_ATTR_VALUE.equals(platformId2)) {
                        flashBuilderProject.setTargetPlatform(TargetPlatform.Mobile);
                        flashBuilderProject.setAndroidSupported(FlashBuilderProjectLoadUtil.isPlatformEnabled(buildTargetElement));
                        FlashBuilderProjectLoadUtil.loadSigningOptions(flashBuilderProject, buildTargetElement, TargetPlatform.Mobile, false);
                        FlashBuilderProjectLoadUtil.loadFilesExcludedFromPackage(flashBuilderProject, buildTargetElement, TargetPlatform.Mobile, false);
                        continue;
                    }
                    if (IOS_PLATFORM_ATTR_VALUE.equals(buildTarget) || IOS_PLATFORM_ATTR_VALUE.equals(platformId1) || IOS_PLATFORM_ATTR_VALUE.equals(platformId2)) {
                        flashBuilderProject.setTargetPlatform(TargetPlatform.Mobile);
                        flashBuilderProject.setIosSupported(FlashBuilderProjectLoadUtil.isPlatformEnabled(buildTargetElement));
                        FlashBuilderProjectLoadUtil.loadSigningOptions(flashBuilderProject, buildTargetElement, TargetPlatform.Mobile, true);
                        FlashBuilderProjectLoadUtil.loadFilesExcludedFromPackage(flashBuilderProject, buildTargetElement, TargetPlatform.Mobile, true);
                        continue;
                    }
                    if (BLACKBERRY_PLATFORM_ATTR_VALUE.equals(buildTarget) || BLACKBERRY_PLATFORM_ATTR_VALUE.equals(platformId1) || BLACKBERRY_PLATFORM_ATTR_VALUE.equals(platformId2)) {
                        flashBuilderProject.setTargetPlatform(TargetPlatform.Mobile);
                        continue;
                    }
                    FlashBuilderProjectLoadUtil.loadSigningOptions(flashBuilderProject, buildTargetElement, TargetPlatform.Desktop, false);
                    FlashBuilderProjectLoadUtil.loadFilesExcludedFromPackage(flashBuilderProject, buildTargetElement, TargetPlatform.Desktop, false);
                }
            }
        }
        if (flashBuilderProject.getTargetPlatform() == TargetPlatform.Mobile) {
            return;
        }
        if ("true".equals(compilerElement.getAttributeValue(USE_APOLLO_CONFIG_ATTR))) {
            flashBuilderProject.setTargetPlatform(TargetPlatform.Desktop);
        } else {
            flashBuilderProject.setTargetPlatform(TargetPlatform.Web);
        }
    }

    private static boolean isPlatformEnabled(Element buildTargetElement) {
        Element multiPlatformSettings = buildTargetElement.getChild(MULTI_PLATFORM_SETTINGS_ELEMENT, buildTargetElement.getNamespace());
        return multiPlatformSettings != null && "true".equals(multiPlatformSettings.getAttributeValue(ENABLED_ATTR));
    }

    @Nullable
    private static String getMultiPlatformId(Element buildTargetElement) {
        Element multiPlatformSettings = buildTargetElement.getChild(MULTI_PLATFORM_SETTINGS_ELEMENT, buildTargetElement.getNamespace());
        return multiPlatformSettings == null ? null : multiPlatformSettings.getAttributeValue(PLATFORM_ID_2);
    }

    private static void loadSigningOptions(FlashBuilderProject fbProject, Element buildTargetElement, TargetPlatform targetPlatform, boolean iOS) {
        String provisioningPath;
        Element airSettingsElement = buildTargetElement.getChild(AIR_SETTINGS_ELEMENT, buildTargetElement.getNamespace());
        if (airSettingsElement == null) {
            return;
        }
        String certPath = airSettingsElement.getAttributeValue(AIR_CERTIFICATE_ATTR);
        if (certPath != null) {
            if (targetPlatform == TargetPlatform.Desktop) {
                fbProject.setDesktopCertPath(FileUtil.toSystemIndependentName((String)certPath));
            } else if (iOS) {
                fbProject.setIOSCertPath(FileUtil.toSystemIndependentName((String)certPath));
            } else {
                fbProject.setAndroidCertPath(FileUtil.toSystemIndependentName((String)certPath));
            }
        }
        if (targetPlatform == TargetPlatform.Mobile && iOS && (provisioningPath = buildTargetElement.getAttributeValue(PROVISIONING_FILE_ATTR)) != null) {
            fbProject.setIOSProvisioningPath(provisioningPath);
        }
    }

    private static void loadFilesExcludedFromPackage(FlashBuilderProject fbProject, Element buildTargetElement, TargetPlatform targetPlatform, boolean iOS) {
        Element airExcludesElement;
        Element airSettingsElement = buildTargetElement.getChild(AIR_SETTINGS_ELEMENT, buildTargetElement.getNamespace());
        Element element = airExcludesElement = airSettingsElement == null ? null : airSettingsElement.getChild(AIR_EXCLUDES_ELEMENT, airSettingsElement.getNamespace());
        if (airExcludesElement == null) {
            return;
        }
        for (Element pathEntryElement : airExcludesElement.getChildren(PATH_ENTRY_ELEMENT, airExcludesElement.getNamespace())) {
            String path = pathEntryElement.getAttributeValue(PATH_ATTR);
            if (StringUtil.isEmptyOrSpaces((String)path)) continue;
            if (targetPlatform == TargetPlatform.Mobile) {
                if (iOS) {
                    fbProject.addPathExcludedFromIOSPackaging(path);
                    continue;
                }
                fbProject.addPathExcludedFromAndroidPackaging(path);
                continue;
            }
            if (targetPlatform != TargetPlatform.Desktop) continue;
            fbProject.addPathExcludedFromDesktopPackaging(path);
        }
    }

    private static void loadOutputType(FlashBuilderProject project, VirtualFile dotProjectFile) {
        VirtualFile dir = dotProjectFile.getParent();
        assert (dir != null);
        project.setOutputType(dir.findChild(".flexLibProperties") == null ? OutputType.Application : OutputType.Library);
    }

    private static void loadProjectRoot(FlashBuilderProject project, VirtualFile dotProjectFile) {
        VirtualFile dir = dotProjectFile.getParent();
        assert (dir != null);
        project.setProjectRootPath(dir.getPath());
    }

    private static void loadSourcePaths(FlashBuilderProject project, Element compilerElement) {
        String sourceFolderPath = compilerElement.getAttributeValue(SOURCE_FOLDER_PATH_ATTR);
        if (!StringUtil.isEmptyOrSpaces((String)sourceFolderPath)) {
            project.addSourcePath(FileUtil.toSystemIndependentName((String)sourceFolderPath));
        }
        for (Element compilerSourcePathElement : compilerElement.getChildren(COMPILER_SOURCE_PATH_TAG)) {
            for (Element compilerSourcePathEntryElement : compilerSourcePathElement.getChildren(COMPILER_SOURCE_PATH_ENTRY_TAG)) {
                String sourcePath = compilerSourcePathEntryElement.getAttributeValue(PATH_ATTR);
                if (StringUtil.isEmptyOrSpaces((String)sourcePath)) continue;
                project.addSourcePath(FileUtil.toSystemIndependentName((String)sourcePath));
            }
        }
    }

    private static void loadOutputFolderPath(FlashBuilderProject project, Element compilerElement) {
        String outputFolderLocation = compilerElement.getAttributeValue(OUTPUT_FOLDER_LOCATION_ATTR);
        if (!StringUtil.isEmptyOrSpaces((String)outputFolderLocation)) {
            project.setOutputFolderPath(FileUtil.toSystemIndependentName((String)outputFolderLocation));
        } else {
            String outputFolderPath = compilerElement.getAttributeValue(OUTPUT_FOLDER_PATH_ATTR);
            if (!StringUtil.isEmptyOrSpaces((String)outputFolderPath)) {
                project.setOutputFolderPath(FileUtil.toSystemIndependentName((String)outputFolderPath));
            }
        }
    }

    private static void loadMainClassName(FlashBuilderProject project, Element actionScriptPropertiesElement) {
        String mainAppPath = actionScriptPropertiesElement.getAttributeValue(MAIN_APP_PATH_ATTR);
        if (mainAppPath != null) {
            project.setMainAppClassName(FlashBuilderProjectLoadUtil.getClassName(mainAppPath));
        }
    }

    public static String getClassName(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", PATH_ATTR, "com/intellij/lang/javascript/flex/flashbuilder/FlashBuilderProjectLoadUtil", "getClassName"));
        }
        String fqn = path.replace('/', '.').trim();
        int lastDotIndex = fqn.lastIndexOf(46);
        String lowercased = fqn.toLowerCase();
        return lastDotIndex >= 0 && (lowercased.endsWith(".mxml") || lowercased.endsWith(".as")) ? fqn.substring(0, lastDotIndex) : fqn;
    }

    private static void loadTargetPlayerVersion(FlashBuilderProject project, Element compilerElement) {
        String version = compilerElement.getAttributeValue(TARGET_PLAYER_VERSION_ATTR);
        if (version != null && !version.startsWith("0")) {
            project.setTargetPlayerVersion(version);
        }
    }

    private static void loadAdditionalCompilerArguments(FlashBuilderProject project, Element compilerElement) {
        String arguments = compilerElement.getAttributeValue(ADDITIONAL_COMPILER_ARGUMENTS_ATTR);
        if (!StringUtil.isEmptyOrSpaces((String)arguments)) {
            project.setAdditionalCompilerOptions(arguments.replace('\n', ' ').replace('\r', ' ').replace('\t', ' '));
        }
    }

    private static void loadDependenciesAndCheckIfSdkUsed(FlashBuilderProject project, Element compilerElement, Map<String, String> pathReplacementMap) {
        for (Element libraryPathElement : compilerElement.getChildren(LIBRARY_PATH_TAG)) {
            for (Element libraryPathEntryElement : libraryPathElement.getChildren(LIBRARY_PATH_ENTRY_TAG)) {
                String flexUnitFrameworkPath;
                String path;
                String libraryKind = StringUtil.notNullize((String)libraryPathEntryElement.getAttributeValue(LIBRARY_KIND_ATTR), (String)SWC_FILE_KIND);
                if (libraryKind.equals(USE_SDK_KIND)) {
                    project.setSdkUsed(true);
                    continue;
                }
                String libraryPath = libraryPathEntryElement.getAttributeValue(PATH_ATTR);
                if (StringUtil.isEmptyOrSpaces((String)libraryPath) || !SWC_FILE_KIND.equals(libraryKind) && !SWC_FOLDER_KIND.equals(libraryKind) && !ANE_KIND.equals(libraryKind)) continue;
                ArrayList<String> librarySourcePaths = new ArrayList<String>();
                String replacedPath = pathReplacementMap.get(libraryPath);
                String string = path = replacedPath != null ? replacedPath : libraryPath;
                if (path.startsWith(FLEXUNIT_LIB_MACRO)) {
                    flexUnitFrameworkPath = FlashBuilderProjectLoadUtil.guessFlexUnitFrameworkPath();
                    if (flexUnitFrameworkPath != null) {
                        path = flexUnitFrameworkPath + "/libs" + path.substring(FLEXUNIT_LIB_MACRO.length());
                    }
                } else if (path.equals(FLEXUNIT_LOCALE_MACRO) && (flexUnitFrameworkPath = FlashBuilderProjectLoadUtil.guessFlexUnitFrameworkPath()) != null) {
                    path = flexUnitFrameworkPath + "/locale/version4locale/FlexUnitTestRunner_rb.swc";
                }
                project.addLibraryPathAndSources(FileUtil.toSystemIndependentName((String)path), librarySourcePaths);
            }
        }
    }

    private static String guessFlexUnitFrameworkPath() {
        File[] flexUnitDirs;
        String fbPath = FlashBuilderSdkFinder.findFBInstallationPath();
        if (fbPath == null) {
            return null;
        }
        File pluginsDir = new File(fbPath + "/eclipse/plugins");
        if (!pluginsDir.isDirectory()) {
            return null;
        }
        for (File flexUnitDir : flexUnitDirs = pluginsDir.listFiles((dir, name) -> name.startsWith("com.adobe.flexbuilder.flexunit_"))) {
            String flexUnitLibPath = flexUnitDir.getPath() + "/flexunitframework";
            if (!new File(flexUnitLibPath).isDirectory()) continue;
            return flexUnitLibPath;
        }
        return null;
    }

    private static void loadSdkName(FlashBuilderProject project, Element compilerElement) {
        String sdkName = compilerElement.getAttributeValue(FLEX_SDK_ATTR);
        if (!StringUtil.isEmptyOrSpaces((String)sdkName)) {
            project.setSdkName(sdkName);
        }
    }

    private static void loadApplications(FlashBuilderProject project, Element actionScriptPropertiesElement) {
        for (Element applicationsElement : actionScriptPropertiesElement.getChildren(APPLICATIONS_ELEMENT)) {
            for (Element applicationElement : applicationsElement.getChildren("application")) {
                String path = applicationElement.getAttributeValue(PATH_ATTR);
                String className = path == null ? null : FlashBuilderProjectLoadUtil.getClassName(path);
                if (className == null || "FlexUnitApplication".equals(className) || "FlexUnitCompilerApplication".equals(className)) continue;
                project.addApplicationClassName(className);
            }
        }
    }

    private static void loadModules(FlashBuilderProject project, Element actionScriptPropertiesElement) {
        for (Element modulesElement : actionScriptPropertiesElement.getChildren(MODULES_ELEMENT)) {
            for (Element moduleElement : modulesElement.getChildren(MODULE_ELEMENT)) {
                String mainClassPath = moduleElement.getAttributeValue(SOURCE_PATH_ATTR);
                String outputPath = moduleElement.getAttributeValue(DEST_PATH_ATTR);
                String optimize = moduleElement.getAttributeValue(OPTIMIZE_ATTR);
                String optimizeFor = moduleElement.getAttributeValue("application");
                if (StringUtil.isEmpty((String)mainClassPath) || StringUtil.isEmpty((String)DEST_PATH_ATTR) || StringUtil.isEmpty((String)optimizeFor)) continue;
                project.addModule(new FlashBuilderProject.FBRLMInfo(mainClassPath, outputPath, "true".equalsIgnoreCase(optimize), optimizeFor));
            }
        }
    }

    private static void loadCssFilesToCompile(FlashBuilderProject project, Element actionScriptPropertiesElement) {
        for (Element buildSccFilesElement : actionScriptPropertiesElement.getChildren(BUILD_CSS_FILES_ELEMENT)) {
            for (Element buildCssFileEntryElement : buildSccFilesElement.getChildren(BUILD_CSS_FILE_ENTRY_ELEMENT)) {
                String sourcePath = buildCssFileEntryElement.getAttributeValue(SOURCE_PATH_ATTR);
                if (StringUtil.isEmpty((String)sourcePath)) continue;
                project.addCssFileToCompile(FileUtil.toSystemIndependentName((String)sourcePath));
            }
        }
    }

    private static void loadTheme(FlashBuilderProject project, Element actionScriptPropertiesElement) {
        String themeDirPathRaw;
        String defaultThemeAttr;
        Element themeElement = actionScriptPropertiesElement.getChild(THEME_ELEMENT, actionScriptPropertiesElement.getNamespace());
        String string = defaultThemeAttr = themeElement == null ? null : themeElement.getAttributeValue(DEFAULT_THEME_ATTR);
        if (defaultThemeAttr != null && "false".equals(defaultThemeAttr) && (themeDirPathRaw = themeElement.getAttributeValue(THEME_LOCATION_ATTR)) != null) {
            project.setThemeDirPathRaw(themeDirPathRaw);
        }
    }
}

