/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.run;

import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.ide.browsers.WebBrowserReferenceConverter;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.xmlb.annotations.OptionTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LauncherParameters
implements Cloneable {
    @NotNull
    private LauncherType myLauncherType;
    @NotNull
    private String myPlayerPath;
    private boolean myNewPlayerInstance;
    @NotNull
    private WebBrowser myBrowser;

    public LauncherParameters() {
        this.myLauncherType = LauncherType.OSDefault;
        this.myPlayerPath = SystemInfo.isMac ? "/Applications/Flash Player Debugger.app" : (SystemInfo.isWindows ? "FlashPlayerDebugger.exe" : "/usr/bin/flashplayerdebugger");
        this.myNewPlayerInstance = false;
        this.myBrowser = WebBrowserManager.getInstance().getFirstBrowser(BrowserFamily.FIREFOX);
    }

    public LauncherParameters(@NotNull LauncherType launcherType, @NotNull WebBrowser browser, @NotNull String playerPath, boolean isNewPlayerInstance) {
        if (launcherType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launcherType", "com/intellij/lang/javascript/flex/run/LauncherParameters", "<init>"));
        }
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/intellij/lang/javascript/flex/run/LauncherParameters", "<init>"));
        }
        if (playerPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "playerPath", "com/intellij/lang/javascript/flex/run/LauncherParameters", "<init>"));
        }
        this.myLauncherType = LauncherType.OSDefault;
        this.myPlayerPath = SystemInfo.isMac ? "/Applications/Flash Player Debugger.app" : (SystemInfo.isWindows ? "FlashPlayerDebugger.exe" : "/usr/bin/flashplayerdebugger");
        this.myNewPlayerInstance = false;
        this.myBrowser = WebBrowserManager.getInstance().getFirstBrowser(BrowserFamily.FIREFOX);
        this.myLauncherType = launcherType;
        this.myBrowser = browser;
        this.myPlayerPath = playerPath;
        this.myNewPlayerInstance = isNewPlayerInstance;
    }

    public String getPresentableText() {
        switch (this.myLauncherType) {
            case OSDefault: {
                return FlexBundle.message("system.default.application", new Object[0]);
            }
            case Browser: {
                return this.myBrowser.getName();
            }
            case Player: {
                return FileUtil.toSystemDependentName((String)this.myPlayerPath);
            }
        }
        assert (false);
        return "";
    }

    @NotNull
    public LauncherType getLauncherType() {
        LauncherType launcherType = this.myLauncherType;
        if (launcherType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/run/LauncherParameters", "getLauncherType"));
        }
        return launcherType;
    }

    public void setLauncherType(@NotNull LauncherType launcherType) {
        if (launcherType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launcherType", "com/intellij/lang/javascript/flex/run/LauncherParameters", "setLauncherType"));
        }
        this.myLauncherType = launcherType;
    }

    @OptionTag(converter=WebBrowserReferenceConverter.class)
    @NotNull
    public WebBrowser getBrowser() {
        WebBrowser webBrowser = this.myBrowser;
        if (webBrowser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/run/LauncherParameters", "getBrowser"));
        }
        return webBrowser;
    }

    public void setBrowser(@Nullable WebBrowser browser) {
        this.myBrowser = browser == null ? WebBrowserManager.getInstance().getFirstBrowser(BrowserFamily.FIREFOX) : browser;
    }

    @NotNull
    public String getPlayerPath() {
        String string = this.myPlayerPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/run/LauncherParameters", "getPlayerPath"));
        }
        return string;
    }

    public void setPlayerPath(@NotNull String playerPath) {
        if (playerPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "playerPath", "com/intellij/lang/javascript/flex/run/LauncherParameters", "setPlayerPath"));
        }
        this.myPlayerPath = FileUtil.toSystemIndependentName((String)playerPath);
    }

    public boolean isNewPlayerInstance() {
        return this.myNewPlayerInstance;
    }

    public void setNewPlayerInstance(boolean newPlayerInstance) {
        this.myNewPlayerInstance = newPlayerInstance;
    }

    public LauncherParameters clone() {
        try {
            return (LauncherParameters)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LauncherParameters that = (LauncherParameters)o;
        if (this.myBrowser != that.myBrowser) {
            return false;
        }
        if (this.myLauncherType != that.myLauncherType) {
            return false;
        }
        return this.myPlayerPath.equals(that.myPlayerPath);
    }

    public int hashCode() {
        assert (false);
        return super.hashCode();
    }

    public static enum LauncherType {
        OSDefault,
        Browser,
        Player;

    }
}

