/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.flex.AnnotationBackedDescriptor;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.generation.ActionScriptEventDispatchUtils;
import com.intellij.lang.javascript.generation.BaseJSGenerateHandler;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.PublicInheritorFilter;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.ui.JSClassChooserDialog;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMethodsFix;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import java.text.MessageFormat;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionScriptGenerateEventHandler
extends BaseJSGenerateHandler {
    protected String getTitleKey() {
        return "";
    }

    protected BaseCreateMethodsFix createFix(JSClass jsClass) {
        return new GenerateEventHandlerFix(jsClass);
    }

    protected boolean collectCandidatesAndShowDialog() {
        return false;
    }

    protected boolean canHaveEmptySelectedElements() {
        return true;
    }

    @Nullable
    public static XmlAttribute getXmlAttribute(PsiFile psiFile, Editor editor) {
        PsiLanguageInjectionHost context = null;
        if (psiFile instanceof JSFile) {
            context = InjectedLanguageManager.getInstance((Project)psiFile.getProject()).getInjectionHost((PsiElement)psiFile);
        } else if (psiFile instanceof XmlFile) {
            context = psiFile.findElementAt(editor.getCaretModel().getOffset());
        }
        return (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)context, XmlAttribute.class);
    }

    @Nullable
    public static String getEventType(XmlAttribute xmlAttribute) {
        PsiElement declarationParent;
        XmlAttributeDescriptor descriptor = xmlAttribute == null ? null : xmlAttribute.getDescriptor();
        PsiElement declaration = descriptor instanceof AnnotationBackedDescriptor ? descriptor.getDeclaration() : null;
        PsiElement psiElement = declarationParent = declaration == null ? null : declaration.getParent();
        if (declaration instanceof JSAttributeNameValuePair && (((JSAttributeNameValuePair)declaration).getName() == null || "name".equals(((JSAttributeNameValuePair)declaration).getName())) && declarationParent instanceof JSAttribute && "Event".equals(((JSAttribute)declarationParent).getName())) {
            return ((AnnotationBackedDescriptor)descriptor).getType();
        }
        return null;
    }

    @Nullable
    public static JSCallExpression getEventListenerCallExpression(PsiFile psiFile, Editor editor) {
        if (!(psiFile instanceof JSFile)) {
            return null;
        }
        PsiElement elementAtCursor = psiFile.findElementAt(editor.getCaretModel().getOffset());
        JSCallExpression callExpression = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAtCursor, JSCallExpression.class);
        if (callExpression == null || !JSResolveUtil.isEventListenerCall((JSCallExpression)callExpression)) {
            return null;
        }
        JSExpression[] params = callExpression.getArguments();
        if (params.length > 0 && (params[0] instanceof JSReferenceExpression && ((JSReferenceExpression)params[0]).getQualifier() != null || params[0] instanceof JSLiteralExpression && ((JSLiteralExpression)params[0]).isQuotedLiteral()) && (params.length == 1 || params.length > 1 && ActionScriptGenerateEventHandler.isUnresolvedReference(params[1]))) {
            return callExpression;
        }
        return null;
    }

    private static boolean isUnresolvedReference(JSExpression parameter) {
        if (parameter instanceof JSReferenceExpression) {
            ASTNode nameNode;
            PsiElement referenceNameElement = ((JSReferenceExpression)parameter).getReferenceNameElement();
            ASTNode aSTNode = nameNode = referenceNameElement == null ? null : referenceNameElement.getNode();
            if (nameNode != null && nameNode.getElementType() == JSTokenTypes.IDENTIFIER && ((JSReferenceExpression)parameter).resolve() == null) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static Trinity<JSExpressionStatement, String, String> getEventConstantInfo(PsiFile psiFile, Editor editor) {
        JSAttributeList functionAttributes;
        PsiElement referenceNameElement;
        if (!(psiFile instanceof JSFile)) {
            return null;
        }
        JSClass jsClass = BaseJSGenerateHandler.findClass((PsiFile)psiFile, (Editor)editor);
        if (jsClass == null || !ActionScriptEventDispatchUtils.isEventDispatcher((JSClass)jsClass)) {
            return null;
        }
        PsiElement elementAtCursor = psiFile.findElementAt(editor.getCaretModel().getOffset());
        JSExpressionStatement expressionStatement = (JSExpressionStatement)PsiTreeUtil.getParentOfType((PsiElement)elementAtCursor, JSExpressionStatement.class);
        PsiElement expressionStatementParent = expressionStatement == null ? null : expressionStatement.getParent();
        JSFunction jsFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)expressionStatement, JSFunction.class);
        JSExpression expression = expressionStatement == null ? null : expressionStatement.getExpression();
        JSReferenceExpression refExpression = expression instanceof JSReferenceExpression ? (JSReferenceExpression)expression : null;
        JSExpression qualifier = refExpression == null ? null : refExpression.getQualifier();
        PsiReference qualifierReference = qualifier == null ? null : qualifier.getReference();
        PsiElement psiElement = referenceNameElement = refExpression == null ? null : refExpression.getReferenceNameElement();
        if (jsFunction == null || (functionAttributes = jsFunction.getAttributeList()) != null && functionAttributes.hasModifier(JSAttributeList.ModifierType.STATIC) || qualifierReference == null || !(referenceNameElement instanceof LeafPsiElement) || !(expressionStatementParent instanceof JSFunction) && !(expressionStatementParent instanceof JSBlockStatement)) {
            return null;
        }
        PsiElement qualifierResolve = qualifierReference.resolve();
        if (!(qualifierResolve instanceof JSClass) || !ActionScriptGenerateEventHandler.isEventClass((JSClass)qualifierResolve)) {
            return null;
        }
        PsiElement expressionResolve = refExpression.resolve();
        if (expressionResolve instanceof JSVariable) {
            JSAttributeList varAttributes = ((JSVariable)expressionResolve).getAttributeList();
            String text = ((JSVariable)expressionResolve).getLiteralOrReferenceInitializerText();
            if (varAttributes != null && varAttributes.hasModifier(JSAttributeList.ModifierType.STATIC) && varAttributes.getAccessType() == JSAttributeList.AccessType.PUBLIC && text != null && StringUtil.isQuotedString((String)text)) {
                return Trinity.create((Object)expressionStatement, (Object)((JSClass)qualifierResolve).getQualifiedName(), (Object)ActionScriptGenerateEventHandler.initializerToPartialMethodName(text));
            }
        }
        return null;
    }

    public static boolean isEventClass(JSClass jsClass) {
        PsiElement eventClass = JSResolveUtil.unwrapProxy((PsiElement)ActionScriptClassResolver.findClassByQNameStatic("flash.events.Event", (PsiElement)jsClass));
        if (eventClass instanceof JSClass && JSInheritanceUtil.isParentClass((JSClass)jsClass, (JSClass)((JSClass)eventClass))) {
            return true;
        }
        PsiElement eventClass2 = JSResolveUtil.unwrapProxy((PsiElement)ActionScriptClassResolver.findClassByQNameStatic("starling.events.Event", (PsiElement)jsClass));
        return eventClass2 instanceof JSClass && JSInheritanceUtil.isParentClass((JSClass)jsClass, (JSClass)((JSClass)eventClass2));
    }

    private static String initializerToPartialMethodName(String initializerText) {
        String unquoted = StringUtil.stripQuotesAroundValue((String)initializerText);
        int dotIndex = unquoted.lastIndexOf(46);
        return unquoted.substring(dotIndex + 1).replaceAll("[^\\p{Alnum}]", "_");
    }

    public static class GenerateEventHandlerFix
    extends BaseCreateMethodsFix {
        private boolean inMxmlEventAttributeValue;
        private boolean inEventListenerCall;
        private PsiElement handlerCallerAnchorInArgumentList;
        private JSReferenceExpression myExistingUnresolvedReverence;
        private boolean inEventConstantExpression;
        private JSExpressionStatement eventConstantExpression;
        private String eventHandlerName;
        private String eventHandlerName2;
        private String methodBody;
        private String eventClassFqn;
        private boolean userCancelled;
        private static final String METHOD_NAME_PATTERN = "{0}_{1}Handler";
        private final JSClass myJsClass;

        public GenerateEventHandlerFix(JSClass jsClass) {
            super(jsClass);
            this.myJsClass = jsClass;
            this.inMxmlEventAttributeValue = false;
            this.inEventListenerCall = false;
            this.handlerCallerAnchorInArgumentList = null;
            this.eventHandlerName = "eventHandler";
            this.eventHandlerName2 = "onEvent";
            this.methodBody = "";
            this.eventClassFqn = "flash.events.Event";
            this.userCancelled = false;
        }

        public void beforeInvoke(@NotNull Project project, Editor editor, PsiFile psiFile) {
            String eventType;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/generation/ActionScriptGenerateEventHandler$GenerateEventHandlerFix", "beforeInvoke"));
            }
            XmlAttribute xmlAttribute = ActionScriptGenerateEventHandler.getXmlAttribute(psiFile, editor);
            String string = eventType = xmlAttribute == null ? null : ActionScriptGenerateEventHandler.getEventType(xmlAttribute);
            if (eventType != null) {
                this.inMxmlEventAttributeValue = true;
                this.prepareForMxmlEventAttributeValue(xmlAttribute, eventType);
                return;
            }
            JSCallExpression callExpression = ActionScriptGenerateEventHandler.getEventListenerCallExpression(psiFile, editor);
            if (callExpression != null) {
                this.inEventListenerCall = true;
                this.prepareForEventListenerCall(callExpression);
                return;
            }
            Trinity<JSExpressionStatement, String, String> eventConstantInfo = ActionScriptGenerateEventHandler.getEventConstantInfo(psiFile, editor);
            if (eventConstantInfo != null) {
                this.inEventConstantExpression = true;
                this.eventConstantExpression = (JSExpressionStatement)eventConstantInfo.first;
                this.eventClassFqn = (String)eventConstantInfo.second;
                String eventName = (String)eventConstantInfo.third;
                this.eventHandlerName = eventName + "Handler";
                this.eventHandlerName2 = "on" + (eventName.isEmpty() ? "Event" : Character.toUpperCase(eventName.charAt(0)) + eventName.substring(1));
                return;
            }
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)psiFile);
            if (module != null && !ApplicationManager.getApplication().isUnitTestMode()) {
                GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
                JSClassChooserDialog dialog = new JSClassChooserDialog(module.getProject(), FlexBundle.message("choose.event.class.title", new Object[0]), scope, this.getEventBaseClass(), (Condition)new PublicInheritorFilter(module.getProject(), "flash.events.Event", scope, false));
                if (dialog.showDialog()) {
                    JSClass selectedClass = dialog.getSelectedClass();
                    if (selectedClass != null) {
                        this.eventClassFqn = selectedClass.getQualifiedName();
                    }
                } else {
                    this.userCancelled = true;
                }
            }
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/generation/ActionScriptGenerateEventHandler$GenerateEventHandlerFix", "invoke"));
            }
            if (this.userCancelled) {
                return;
            }
            PsiElement referenceElement = this.insertEventHandlerReference(editor, file);
            this.evalAnchor(editor, file);
            String eventClassShortName = StringUtil.getShortName((String)this.eventClassFqn);
            String functionText = "private function " + this.eventHandlerName + "(event:" + eventClassShortName + "):void{" + this.methodBody + "\n}\n";
            JSFunction addedElement = (JSFunction)this.doAddOneMethod(project, functionText, this.anchor);
            addedElement = (JSFunction)ImportUtils.importAndShortenReference((String)this.eventClassFqn, (PsiElement)addedElement, (boolean)true, (boolean)false).second;
            JSFunction templateBaseElement = referenceElement == null ? addedElement : this.myJsClass;
            TemplateBuilderImpl templateBuilder = new TemplateBuilderImpl((PsiElement)templateBaseElement);
            PsiElement lastElement = PsiTreeUtil.getDeepestLast((PsiElement)addedElement);
            PsiElement prevElement = lastElement.getPrevSibling();
            templateBuilder.setEndVariableBefore(prevElement != null ? prevElement : lastElement);
            templateBuilder.replaceElement(addedElement.getAttributeList().findAccessTypeElement(), (Expression)new MyExpression("private", "protected", "public"));
            templateBuilder.replaceElement(addedElement.findNameIdentifier().getPsi(), "handlerName", (Expression)new MyExpression(this.eventHandlerName, this.eventHandlerName2), true);
            templateBuilder.replaceElement(addedElement.getParameterVariables()[0].findNameIdentifier().getPsi(), (Expression)new MyExpression("event", "e"));
            if (referenceElement != null && referenceElement.isValid()) {
                templateBuilder.replaceElement(referenceElement, "handlerReference", "handlerName", false);
            }
            Editor topEditor = InjectedLanguageUtil.getTopLevelEditor((Editor)editor);
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(topEditor.getDocument());
            int startOffset = templateBaseElement.getTextRange().getStartOffset();
            Template template = templateBuilder.buildInlineTemplate();
            topEditor.getCaretModel().moveToOffset(InjectedLanguageManager.getInstance((Project)project).injectedToHost((PsiElement)templateBaseElement, startOffset));
            TemplateManager.getInstance((Project)project).startTemplate(topEditor, template);
        }

        @Nullable
        private PsiElement insertEventHandlerReference(Editor editor, PsiFile psiFile) {
            if (this.inMxmlEventAttributeValue) {
                XmlAttribute xmlAttribute = ActionScriptGenerateEventHandler.getXmlAttribute(psiFile, editor);
                if (xmlAttribute != null) {
                    final String attributeValue = this.eventHandlerName + "(event)";
                    xmlAttribute.setValue(attributeValue);
                    PsiLanguageInjectionHost valueElement = (PsiLanguageInjectionHost)xmlAttribute.getValueElement();
                    if (valueElement != null) {
                        final Ref ref = new Ref();
                        InjectedLanguageUtil.enumerate((PsiElement)valueElement, (PsiLanguageInjectionHost.InjectedPsiVisitor)new PsiLanguageInjectionHost.InjectedPsiVisitor(){

                            public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                                if (injectedPsi == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/lang/javascript/generation/ActionScriptGenerateEventHandler$GenerateEventHandlerFix$1", "visit"));
                                }
                                if (places == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "com/intellij/lang/javascript/generation/ActionScriptGenerateEventHandler$GenerateEventHandlerFix$1", "visit"));
                                }
                                int i = injectedPsi.getText().indexOf(attributeValue);
                                if (i != -1) {
                                    ref.set((Object)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)injectedPsi, (int)i, JSReferenceExpression.class, (boolean)false));
                                }
                            }
                        });
                        return (PsiElement)ref.get();
                    }
                }
            } else if (this.inEventListenerCall) {
                if (this.handlerCallerAnchorInArgumentList != null) {
                    PsiElement psi;
                    JSCommaExpression commaExpression;
                    LeafPsiElement comma;
                    PsiElement element = JSChangeUtil.createJSTreeFromText((Project)psiFile.getProject(), (String)this.eventHandlerName, (JSLanguageDialect)JavaScriptSupportLoader.ECMA_SCRIPT_L4).getPsi();
                    PsiElement created = null;
                    if (element != null) {
                        created = this.handlerCallerAnchorInArgumentList.getParent().addAfter(element, this.handlerCallerAnchorInArgumentList);
                    }
                    if (this.handlerCallerAnchorInArgumentList.getNode().getElementType() != JSTokenTypes.COMMA && (comma = (LeafPsiElement)PsiTreeUtil.getChildOfType((PsiElement)(commaExpression = (JSCommaExpression)PsiTreeUtil.getChildOfType((PsiElement)(psi = JSChangeUtil.createJSTreeFromText((Project)psiFile.getProject(), (String)"a,b").getPsi()), JSCommaExpression.class)), LeafPsiElement.class)) != null && comma.getNode().getElementType() == JSTokenTypes.COMMA) {
                        this.handlerCallerAnchorInArgumentList.getParent().addAfter((PsiElement)comma, this.handlerCallerAnchorInArgumentList);
                    }
                    GenerateEventHandlerFix.ensureTrailingSemicolonPresent(psiFile, created);
                    return created;
                }
                if (this.myExistingUnresolvedReverence != null) {
                    GenerateEventHandlerFix.ensureTrailingSemicolonPresent(psiFile, (PsiElement)this.myExistingUnresolvedReverence);
                    return this.myExistingUnresolvedReverence;
                }
            } else if (this.inEventConstantExpression) {
                String text = "addEventListener(" + this.eventConstantExpression.getExpression().getText() + ", " + this.eventHandlerName + ");";
                PsiElement element = JSChangeUtil.createJSTreeFromText((Project)psiFile.getProject(), (String)text, (JSLanguageDialect)JavaScriptSupportLoader.ECMA_SCRIPT_L4).getPsi();
                if (element != null) {
                    JSExpression[] arguments;
                    PsiElement addedElement = this.eventConstantExpression.replace(element);
                    JSExpression expression = ((JSExpressionStatement)addedElement).getExpression();
                    JSArgumentList argumentList = (JSArgumentList)PsiTreeUtil.findChildOfType((PsiElement)expression, JSArgumentList.class);
                    JSExpression[] jSExpressionArray = arguments = argumentList == null ? JSExpression.EMPTY_ARRAY : argumentList.getArguments();
                    if (arguments.length == 2) {
                        return arguments[1];
                    }
                }
            }
            return null;
        }

        private static void ensureTrailingSemicolonPresent(PsiFile psiFile, PsiElement element) {
            PsiElement psi;
            PsiElement semicolon;
            PsiElement lastChild;
            PsiElement parent;
            JSCallExpression callExpression = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSCallExpression.class);
            if (callExpression != null && JSResolveUtil.isEventListenerCall((JSCallExpression)callExpression) && (parent = callExpression.getParent()) instanceof JSExpressionStatement && (lastChild = parent.getLastChild()) == callExpression && (semicolon = (psi = JSChangeUtil.createJSTreeFromText((Project)psiFile.getProject(), (String)";").getPsi()).getFirstChild()) != null && semicolon.getNode().getElementType() == JSTokenTypes.SEMICOLON) {
                parent.addAfter(semicolon, (PsiElement)callExpression);
            }
        }

        @Nullable
        private JSClass getEventBaseClass() {
            PsiElement eventClass = JSResolveUtil.unwrapProxy((PsiElement)JSDialectSpecificHandlersFactory.forElement((PsiElement)this.myJsClass).getClassResolver().findClassByQName("flash.events.Event", (PsiElement)this.myJsClass));
            if (eventClass instanceof JSClass) {
                return (JSClass)eventClass;
            }
            return null;
        }

        private void prepareForMxmlEventAttributeValue(XmlAttribute xmlAttribute, String eventType) {
            String id;
            this.eventClassFqn = eventType;
            this.methodBody = StringUtil.notNullize((String)xmlAttribute.getValue()).trim();
            if (this.methodBody.length() > 0 && !this.methodBody.endsWith(";") && !this.methodBody.endsWith("}")) {
                this.methodBody = this.methodBody + ";";
            }
            XmlTag xmlTag = xmlAttribute.getParent();
            String eventName = xmlAttribute.getName();
            String string = id = xmlTag == null ? null : xmlTag.getAttributeValue("id");
            if (xmlTag != null && xmlTag.getParent() instanceof XmlDocument) {
                this.eventHandlerName = eventName + "Handler";
            } else if (id == null) {
                String name = xmlTag == null ? "" : xmlTag.getLocalName();
                String idBase = name.isEmpty() ? "" : Character.toLowerCase(name.charAt(0)) + name.substring(1);
                int i = 0;
                do {
                    this.eventHandlerName = MessageFormat.format(METHOD_NAME_PATTERN, idBase + ++i, eventName);
                } while (this.myJsClass.findFunctionByName(this.eventHandlerName) != null);
            } else {
                this.eventHandlerName = MessageFormat.format(METHOD_NAME_PATTERN, id, eventName);
            }
            this.eventHandlerName2 = "on" + (eventName.isEmpty() ? "Event" : Character.toUpperCase(eventName.charAt(0)) + eventName.substring(1));
        }

        private void prepareForEventListenerCall(JSCallExpression callExpression) {
            JSExpression[] params = callExpression.getArguments();
            String eventName = "event";
            if (params.length > 0) {
                this.handlerCallerAnchorInArgumentList = params[0];
                JSExpression sibling = params[0];
                while ((sibling = sibling.getNextSibling()) != null) {
                    ASTNode node = sibling.getNode();
                    if (node == null || node.getElementType() != JSTokenTypes.COMMA) continue;
                    this.handlerCallerAnchorInArgumentList = sibling;
                    if (params.length < 2) break;
                    this.handlerCallerAnchorInArgumentList = null;
                    if (!ActionScriptGenerateEventHandler.isUnresolvedReference(params[1])) break;
                    this.myExistingUnresolvedReverence = (JSReferenceExpression)params[1];
                    this.eventHandlerName = this.myExistingUnresolvedReverence.getReferencedName();
                    break;
                }
                if (params[0] instanceof JSReferenceExpression) {
                    PsiReference reference;
                    PsiElement resolved;
                    PsiElement resolveResult;
                    PsiReference[] references;
                    JSReferenceExpression referenceExpression = (JSReferenceExpression)params[0];
                    JSExpression qualifier = referenceExpression.getQualifier();
                    if (qualifier != null && (references = qualifier.getReferences()).length == 1 && (resolveResult = references[0].resolve()) instanceof JSClass && ActionScriptGenerateEventHandler.isEventClass((JSClass)resolveResult)) {
                        this.eventClassFqn = ((JSClass)resolveResult).getQualifiedName();
                    }
                    PsiElement psiElement = resolved = (reference = referenceExpression.getReference()) == null ? null : reference.resolve();
                    if (resolved instanceof JSVariable && ((JSVariable)resolved).hasInitializer()) {
                        eventName = ActionScriptGenerateEventHandler.initializerToPartialMethodName(((JSVariable)resolved).getInitializer().getText());
                    }
                } else if (params[0] instanceof JSLiteralExpression) {
                    eventName = ActionScriptGenerateEventHandler.initializerToPartialMethodName(params[0].getText());
                }
            }
            if (this.handlerCallerAnchorInArgumentList != null) {
                JSExpression qualifier = ((JSReferenceExpression)callExpression.getMethodExpression()).getQualifier();
                NamesValidator validator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(JavaScriptSupportLoader.JAVASCRIPT.getLanguage());
                if (qualifier != null && validator.isIdentifier(qualifier.getText(), null)) {
                    String qualifierText = qualifier.getText();
                    if (qualifierText.length() > 1 && qualifierText.charAt(0) == '_' && validator.isIdentifier(qualifierText.substring(1), null)) {
                        qualifierText = qualifierText.substring(1);
                    }
                    this.eventHandlerName = MessageFormat.format(METHOD_NAME_PATTERN, qualifierText, eventName);
                } else {
                    this.eventHandlerName = eventName + "Handler";
                }
            }
            this.eventHandlerName2 = "on" + (eventName.isEmpty() ? "Event" : Character.toUpperCase(eventName.charAt(0)) + eventName.substring(1));
        }

        private static class MyExpression
        extends Expression {
            private final TextResult myResult;
            private final LookupElement[] myLookupItems;

            public MyExpression(String ... variants) {
                this.myResult = new TextResult(variants[0]);
                LookupElement[] lookupElementArray = this.myLookupItems = variants.length == 1 ? LookupElement.EMPTY_ARRAY : new LookupElement[variants.length];
                if (variants.length > 1) {
                    for (int i = 0; i < variants.length; ++i) {
                        this.myLookupItems[i] = LookupElementBuilder.create((String)variants[i]);
                    }
                }
            }

            public Result calculateResult(ExpressionContext context) {
                return this.myResult;
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return this.myResult;
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                return this.myLookupItems;
            }
        }
    }
}

