/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections.actionscript;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.MacroFactory;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.types.TypeFromUsageDetector;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class JSUntypedDeclarationInspection
extends JSInspection {
    @NotNull
    public String getDisplayName() {
        String string = FlexBundle.message("js.untyped.declaration.inspection.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/actionscript/JSUntypedDeclarationInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSVariable(JSVariable node) {
                JSUntypedDeclarationInspection.process((JSNamedElement)node, holder);
            }

            public void visitJSFunctionExpression(JSFunctionExpression node) {
                JSUntypedDeclarationInspection.process((JSNamedElement)node, holder);
            }

            public void visitJSFunctionDeclaration(JSFunction node) {
                if (node.isConstructor() || node.isSetProperty()) {
                    return;
                }
                JSUntypedDeclarationInspection.process((JSNamedElement)node, holder);
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/actionscript/JSUntypedDeclarationInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    private static void process(JSNamedElement node, ProblemsHolder holder) {
        if (!DialectDetector.isActionScript((PsiElement)node)) {
            return;
        }
        ASTNode nameIdentifier = node.findNameIdentifier();
        if (!(nameIdentifier == null && !(node instanceof JSFunction) || JSPsiImplUtils.getTypeFromDeclaration((JSElement)node) != null || node instanceof JSParameter && ((JSParameter)node).isRest())) {
            LocalQuickFix[] localQuickFixArray;
            if (node instanceof JSFunctionExpression && nameIdentifier != null && PsiTreeUtil.getParentOfType((PsiElement)nameIdentifier.getPsi(), JSFunction.class) != node) {
                nameIdentifier = null;
            }
            if (holder.isOnTheFly()) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = new AddTypeToDclFix();
            } else {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            holder.registerProblem((nameIdentifier != null ? nameIdentifier : node.getNode().findChildByType(JSTokenTypes.FUNCTION_KEYWORD)).getPsi(), FlexBundle.message(node instanceof JSFunction ? "js.untyped.function.problem" : "js.untyped.variable.problem", nameIdentifier != null ? nameIdentifier.getText() : "anonymous"), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes);
        }
    }

    private static class AddTypeToDclFix
    implements LocalQuickFix {
        private AddTypeToDclFix() {
        }

        @NotNull
        public String getName() {
            String string = FlexBundle.message("js.untyped.declaration.problem.addtype.fix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/actionscript/JSUntypedDeclarationInspection$AddTypeToDclFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/actionscript/JSUntypedDeclarationInspection$AddTypeToDclFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/actionscript/JSUntypedDeclarationInspection$AddTypeToDclFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/inspections/actionscript/JSUntypedDeclarationInspection$AddTypeToDclFix", "applyFix"));
            }
            PsiElement anchor = descriptor.getPsiElement();
            PsiFile containingFile = anchor.getContainingFile();
            if (!FileModificationService.getInstance().prepareFileForWrite(containingFile)) {
                return;
            }
            PsiElement parent = anchor.getParent();
            if (parent instanceof JSFunction) {
                anchor = ((JSFunction)parent).getParameterList();
            }
            OpenFileDescriptor openDescriptor = new OpenFileDescriptor(project, containingFile.getVirtualFile(), anchor.getTextRange().getEndOffset());
            openDescriptor.navigate(true);
            Editor textEditor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            TemplateManager templateManager = TemplateManager.getInstance((Project)project);
            Template t = templateManager.createTemplate("", "");
            t.addTextSegment(":");
            JSType detectedTypeFromUsage = TypeFromUsageDetector.detectTypeFromUsage((PsiElement)parent, (PsiFile)containingFile);
            if (detectedTypeFromUsage != null) {
                BaseCreateFix.addTypeVar((Template)t, (String)"a", (PsiElement)anchor, (String)detectedTypeFromUsage.getTypeText(JSType.TypeTextFormat.CODE));
            } else {
                String defaultValue = "uint";
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    t.addTextSegment(defaultValue);
                } else {
                    t.addVariable("a", (Expression)new MacroCallNode(MacroFactory.createMacro((String)"complete")), (Expression)new BaseCreateFix.MyExpression(defaultValue), true);
                }
            }
            templateManager.startTemplate(textEditor, t);
        }
    }
}

